/*
 * Decompiled with CFR 0.152.
 */
package structure;

import structure.Anchor;
import structure.GenomicRegion;
import tree.Cluster;

public class PETInteraction {
    public static final int NO_MOTIF = 10;
    public static final int CONVERGENT = 20;
    public static final int DIVERGENT = 30;
    public static final int TANDEM_LEFT = 40;
    public static final int TANDEM_RIGHT = 50;
    public static int PET_GENOMIC_DISTANCE_CUTOFF = 2000000;
    public static final String ER = "ER";
    public static final String CTCF = "CTCF";
    public static final String POLII = "PolII";
    public static final String[] PROTEIN_FACTORS = new String[]{"ER", "CTCF", "PolII"};
    public static double COEFFICIENT = 0.5;
    public static double DECAY_CONSTANT = 0.2;
    public static double IF_SHIFT = 2.0;
    public static double MINIMUM_DISTANCE_CUTOFF = 0.01;
    private final String factor;
    private final GenomicRegion[] genomicRegions = new GenomicRegion[2];
    private final int interactionCount;
    private final double pValue;
    private final double fdrValue;
    private final double preferredDistance;
    private final Anchor[] anchors = new Anchor[2];
    private final int motif;

    public PETInteraction(String factor, String[] chromosomeNames, int[] genomicStarts, int[] genomicEnds, int interactionCount, double pValue, double fdrValue, int motif) {
        this.factor = factor;
        for (int i = 0; i < 2; ++i) {
            this.genomicRegions[i] = new GenomicRegion(chromosomeNames[i], genomicStarts[i], genomicEnds[i]);
            this.anchors[i] = null;
        }
        this.interactionCount = interactionCount;
        this.pValue = pValue;
        this.fdrValue = fdrValue;
        this.preferredDistance = this.calculatePreferredDistance(interactionCount);
        this.motif = motif;
    }

    public PETInteraction(String factor, String chromosomeName, Cluster cluster0, Cluster cluster1, int interactionCount) {
        this.pValue = 0.0;
        this.fdrValue = 0.0;
        this.factor = factor;
        int[] starts = new int[]{cluster0.getGenomicStart(), cluster1.getGenomicStart()};
        int[] ends = new int[]{cluster0.getGenomicEnd(), cluster1.getGenomicEnd()};
        this.genomicRegions[0] = new GenomicRegion(chromosomeName, starts[0], ends[0]);
        this.genomicRegions[1] = new GenomicRegion(chromosomeName, starts[1], ends[1]);
        this.anchors[0] = new Anchor(chromosomeName, starts[0], ends[0]);
        this.anchors[1] = new Anchor(chromosomeName, starts[1], ends[1]);
        this.anchors[0].setCluster(cluster0);
        this.anchors[1].setCluster(cluster1);
        this.interactionCount = interactionCount;
        this.preferredDistance = this.calculatePreferredDistance(interactionCount);
        this.motif = 10;
    }

    public static void setInteractionFrequencyParameters(double cutoff, double A, double gamma, double IF_shift) {
        MINIMUM_DISTANCE_CUTOFF = cutoff;
        COEFFICIENT = A;
        DECAY_CONSTANT = gamma;
        IF_SHIFT = IF_shift;
    }

    public String[] getChromosomeNames() {
        return new String[]{this.genomicRegions[0].getChromosomeName(), this.genomicRegions[1].getChromosomeName()};
    }

    public String getChromosomeName(int i) {
        return this.genomicRegions[i].getChromosomeName();
    }

    public int[] getGenomicStarts() {
        return new int[]{this.genomicRegions[0].getGenomicStart(), this.genomicRegions[1].getGenomicStart()};
    }

    public int getGenomicStart(int i) {
        return this.genomicRegions[i].getGenomicStart();
    }

    public int[] getGenomicEnds() {
        return new int[]{this.genomicRegions[0].getGenomicEnd(), this.genomicRegions[1].getGenomicEnd()};
    }

    public int getGenomicEnd(int i) {
        return this.genomicRegions[i].getGenomicEnd();
    }

    public int[] getGenomicPositions() {
        return new int[]{this.genomicRegions[0].getGenomicPosition(), this.genomicRegions[1].getGenomicPosition()};
    }

    public int getGenomicPosition(int i) {
        return this.genomicRegions[i].getGenomicPosition();
    }

    public int getGenomicDistance() {
        return Math.abs(this.genomicRegions[1].getGenomicPosition() - this.genomicRegions[0].getGenomicPosition());
    }

    public String getProteinFactor() {
        return this.factor;
    }

    public int getInteractionCount() {
        return this.interactionCount;
    }

    public double getPValue() {
        return this.pValue;
    }

    public double getFDRValue() {
        return this.fdrValue;
    }

    public void setAnchors(Anchor[] anchors) {
        this.anchors[0] = anchors[0];
        this.anchors[1] = anchors[1];
    }

    public void setAnchor(int i, Anchor anchor) {
        this.anchors[i] = anchor;
    }

    private int getMotifDirection(int i) {
        switch (this.motif) {
            case 10: {
                return 0;
            }
            case 20: {
                if (i == 0) {
                    return 2;
                }
                return 1;
            }
            case 30: {
                if (i == 0) {
                    return 1;
                }
                return 2;
            }
            case 40: {
                return 1;
            }
            case 50: {
                return 2;
            }
        }
        return -1;
    }

    public void assignAnchorDirections() {
        if (this.anchors[0] == null || this.anchors[1] == null) {
            System.out.println("Found null anchor when setting directions.");
            return;
        }
        for (int i = 0; i < this.anchors.length; ++i) {
            if (this.motif == 10) {
                this.anchors[i].setMotifFlag(false);
            } else {
                this.anchors[i].setMotifFlag(true);
            }
            this.anchors[i].setMotifDirection(this.getMotifDirection(i));
        }
    }

    public Anchor[] getAnchors() {
        return this.anchors;
    }

    public Anchor getAnchor(int i) {
        return this.anchors[i];
    }

    public int getMotif() {
        return this.motif;
    }

    public boolean contains(int position) {
        return position >= this.genomicRegions[0].getGenomicStart() && position <= this.genomicRegions[1].getGenomicEnd();
    }

    public boolean positionsContain(int position) {
        return position >= this.genomicRegions[0].getGenomicPosition() && position <= this.genomicRegions[1].getGenomicPosition();
    }

    private double calculatePreferredDistance(int count) {
        double value = MINIMUM_DISTANCE_CUTOFF + COEFFICIENT * Math.exp(-DECAY_CONSTANT * ((double)count - IF_SHIFT));
        return value;
    }

    public double getPreferredDistance() {
        return this.preferredDistance;
    }

    public String printPETInteraction() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 2; ++i) {
            sb.append(this.genomicRegions[i].getChromosomeName()).append("\t");
            sb.append(this.genomicRegions[i].getGenomicStart()).append("\t");
            sb.append(this.genomicRegions[i].getGenomicEnd()).append("\t");
        }
        sb.append(Integer.toString(this.interactionCount)).append("\t");
        sb.append(Double.toString(this.pValue)).append("\t");
        sb.append(Double.toString(this.fdrValue)).append("\t");
        return sb.toString();
    }

    public String minimalRepresentation() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.genomicRegions[0].getGenomicStart()).append(" ");
        sb.append(this.genomicRegions[1].getGenomicStart()).append(" ");
        sb.append(this.factor);
        return sb.toString();
    }
}

