/*
 * Decompiled with CFR 0.152.
 */
package structure;

public class GenomicRegion {
    private final String chromosomeName;
    private final int genomicStart;
    private final int genomicEnd;
    private final int genomicPosition;

    public GenomicRegion(String chromosomeName, int genomicStart, int genomicEnd) {
        this.chromosomeName = chromosomeName;
        this.genomicStart = genomicStart;
        this.genomicEnd = genomicEnd;
        this.genomicPosition = (genomicStart + genomicEnd) / 2;
    }

    public final String getChromosomeName() {
        return this.chromosomeName;
    }

    public final int getGenomicStart() {
        return this.genomicStart;
    }

    public final int getGenomicEnd() {
        return this.genomicEnd;
    }

    public final int getGenomicPosition() {
        return this.genomicPosition;
    }

    public boolean contains(int position) {
        return position >= this.genomicStart && position <= this.genomicEnd;
    }

    public boolean contains(int start, int end) {
        return this.contains(start) && this.contains(end);
    }

    public boolean overlaps(int start, int end) {
        return this.contains(start) || this.contains(end);
    }

    public boolean overlaps(GenomicRegion r) {
        return this.overlaps(r.getGenomicStart(), r.getGenomicEnd());
    }

    public String printRegion() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.chromosomeName).append(" ");
        sb.append(Integer.toString(this.genomicStart)).append(" ");
        sb.append(Integer.toString(this.genomicEnd));
        return sb.toString();
    }

    public static double genomicLengthToDistance(int genomicLength) {
        return Math.sqrt((double)genomicLength / 1000.0);
    }
}

