/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.util.ArrayList;
import structure.GenomicRegion;
import structure.PETInteraction;
import tree.Cluster;

public class Anchor
extends GenomicRegion {
    public static final int NO_MOTIF = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    private final ArrayList<PETInteraction> petInteractions = new ArrayList();
    private Cluster cluster = null;
    private boolean hasMotif = false;
    private int motifDirection = 0;

    public Anchor(String chromosomeName, int genomicStart, int genomicEnd) {
        super(chromosomeName, genomicStart, genomicEnd);
    }

    public ArrayList<PETInteraction> getPETInteractions() {
        return this.petInteractions;
    }

    public PETInteraction getPETInteraction(int i) {
        return this.petInteractions.get(i);
    }

    public void addPETInteraction(PETInteraction petInteraction) {
        if (!this.petInteractions.contains(petInteraction)) {
            this.petInteractions.add(petInteraction);
        }
    }

    public void addPETInteraction(int i, PETInteraction petInteraction) {
        this.petInteractions.add(i, petInteraction);
    }

    public void clearPETInteractions() {
        this.petInteractions.clear();
    }

    public boolean hasPETInteractions() {
        return !this.petInteractions.isEmpty();
    }

    public int getPETInteractionNumber() {
        return this.petInteractions.size();
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setMotifFlag(boolean bool) {
        this.hasMotif = true;
    }

    public boolean hasMotif() {
        return this.hasMotif;
    }

    public void setMotifDirection(int direction) {
        if (this.motifDirection == -1 || this.motifDirection == 0) {
            this.motifDirection = direction;
        } else if (direction != 0 && direction != this.motifDirection) {
            System.out.println("Tried to set inconsistent directions for an anchor. Previous direction: " + this.motifDirection + ". New direction: " + direction + "\n" + "Anchor: " + super.getChromosomeName() + " " + super.getGenomicStart() + " " + super.getGenomicEnd());
            System.exit(1);
        }
    }

    public int getMotifDirection() {
        return this.motifDirection;
    }

    public String writeAnchor() {
        StringBuilder sb = new StringBuilder(super.getChromosomeName());
        sb.append("\t").append(super.getGenomicStart()).append("\t").append(super.getGenomicEnd());
        return sb.toString();
    }
}

