/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import helper.IOHelp;
import helper.Vec;
import structure.Anchor;
import tree.Cluster;

public class Site {
    private final Cluster cluster;
    private final Vec pos;
    private final Vec orientation;
    private final int direction;

    public Site(Cluster cluster) {
        this.cluster = cluster;
        this.pos = new Vec();
        Anchor anchor = cluster.getAnchor();
        if (anchor == null) {
            this.orientation = null;
            this.direction = 0;
        } else {
            this.direction = anchor.getMotifDirection();
            this.orientation = anchor.hasMotif() ? new Vec(1.0, 0.0, 0.0) : null;
        }
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setX(double x) {
        this.pos.setX(x);
    }

    public void setY(double y) {
        this.pos.setY(y);
    }

    public void setZ(double z) {
        this.pos.setZ(z);
    }

    public void setPosition(double x, double y, double z) {
        this.pos.setPosition(x, y, z);
    }

    public void setPosition(double[] pos) {
        this.pos.setPosition(pos[0], pos[1], pos[2]);
    }

    public double getX() {
        return this.pos.getX();
    }

    public double getY() {
        return this.pos.getY();
    }

    public double getZ() {
        return this.pos.getZ();
    }

    public Vec getPosition() {
        return this.pos;
    }

    public double[] getPositionAsDoubleArray() {
        return new double[]{this.getX(), this.getY(), this.getZ()};
    }

    public Vec getOriention() {
        return this.orientation;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setOrientation(Vec vec0, Vec vec1) {
        double vx = vec1.getX() - vec0.getX();
        double vy = vec1.getY() - vec0.getY();
        double vz = vec1.getZ() - vec0.getZ();
        this.orientation.setPosition(vx, vy, vz);
        this.orientation.normalize();
    }

    public void setOrientation(Vec v) {
        this.orientation.setPosition(v.getX(), v.getY(), v.getZ());
    }

    public void translate(double dx, double dy, double dz) {
        this.pos.translate(dx, dy, dz);
    }

    public String printSite() {
        StringBuilder sb = new StringBuilder();
        sb.append("Cluster ").append(this.cluster.getID()).append(": (");
        sb.append(IOHelp.DF[6].format(this.pos.getX())).append(", ");
        sb.append(IOHelp.DF[6].format(this.pos.getY())).append(", ");
        sb.append(IOHelp.DF[6].format(this.pos.getZ())).append(")");
        return sb.toString();
    }
}

