/*
 * Decompiled with CFR 0.152.
 */
package jhdf5IO;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import java.util.ArrayList;
import structure.PETInteraction;
import tree.Cluster;
import tree.Level;

public class JHDF5IO {
    public static final String GENOMIC_POSITIONS = "genomicPositions";
    public static final String COORDINATES = "coordinates";
    public static final String PET_INTERACTIONS = "petInteractions";
    public static final String PROTEIN_FACTORS = "proteinFactors";
    public static final String PET_GROUP = "Pet_Group";

    public static void saveLevel(IHDF5Writer writer, String groupName, Level level) {
        int[][] genomicPositions = new int[level.getClusterNumber()][2];
        double[][] coordinates = new double[level.getClusterNumber()][3];
        ArrayList<Cluster> clusters = level.getClusters();
        for (int i = 0; i < clusters.size(); ++i) {
            Cluster cluster = clusters.get(i);
            genomicPositions[i][0] = cluster.getGenomicStart();
            genomicPositions[i][1] = cluster.getGenomicEnd();
            coordinates[i][0] = cluster.getSite().getX();
            coordinates[i][1] = cluster.getSite().getY();
            coordinates[i][2] = cluster.getSite().getZ();
        }
        writer.object().createGroup(groupName);
        writer.int32().writeMatrix("/" + groupName + "/" + GENOMIC_POSITIONS, genomicPositions);
        writer.float64().writeMatrix("/" + groupName + "/" + COORDINATES, coordinates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePETs(String filePath, String id, String chromosomeName, ArrayList<PETInteraction> petInteractions) {
        IHDF5Writer writer = null;
        ArrayList<String> proteinFactors = new ArrayList<String>();
        int[][] petInfo = new int[petInteractions.size()][4];
        try {
            writer = HDF5Factory.configure(filePath).writer();
            for (int k = 0; k < petInteractions.size(); ++k) {
                PETInteraction petInteraction = petInteractions.get(k);
                String factor = petInteraction.getProteinFactor();
                boolean contained = false;
                for (String pf : proteinFactors) {
                    if (!pf.equals(factor)) continue;
                    contained = true;
                }
                if (!contained) {
                    proteinFactors.add(factor);
                }
                int index = -1;
                for (int i = 0; i < proteinFactors.size(); ++i) {
                    if (!((String)proteinFactors.get(i)).equals(factor)) continue;
                    index = i;
                }
                petInfo[k][0] = petInteraction.getGenomicStart(0);
                petInfo[k][1] = petInteraction.getGenomicStart(1);
                petInfo[k][2] = petInteraction.getInteractionCount();
                petInfo[k][3] = index;
            }
            writer.object().createGroup("/" + id + "/" + chromosomeName + "/" + PET_GROUP);
            writer.int32().writeMatrix("/" + id + "/" + chromosomeName + "/" + PET_GROUP + "/" + PET_INTERACTIONS, petInfo);
            String[] factors = new String[proteinFactors.size()];
            for (int i = 0; i < factors.length; ++i) {
                factors[i] = (String)proteinFactors.get(i);
            }
            if (proteinFactors.size() == 0) {
                factors = new String[]{"NONE"};
            }
            writer.string().writeArray("/" + id + "/" + chromosomeName + "/" + PET_GROUP + "/" + PROTEIN_FACTORS, factors);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception ioe) {
                    ioe.printStackTrace(System.out);
                }
            }
        }
    }
}

