/*
 * Decompiled with CFR 0.152.
 */
package helper;

public class Vec {
    private double x;
    private double y;
    private double z;

    public Vec() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Vec(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public void setPosition(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void translate(double dx, double dy, double dz) {
        this.x += dx;
        this.y += dy;
        this.z += dz;
    }

    public void translate(Vec dv) {
        this.x += dv.getX();
        this.y += dv.getY();
        this.z += dv.getZ();
    }

    public double dot(Vec vec) {
        return this.x * vec.getX() + this.y * vec.getY() + this.z * vec.getZ();
    }

    public double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double getLengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public void normalize() {
        double length = this.getLength();
        this.x /= length;
        this.y /= length;
        this.z /= length;
    }

    public Vec add(Vec vec) {
        return new Vec(this.x + vec.getX(), this.y + vec.getY(), this.z + vec.getZ());
    }

    public Vec subtract(Vec vec) {
        return new Vec(this.x - vec.getX(), this.y - vec.getY(), this.z - vec.getZ());
    }
}

