/*
 * Decompiled with CFR 0.152.
 */
package converter;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import helper.ChromosomeData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;
import jhdf5IO.JHDF5IO;
import simulation.Site;
import structure.PETInteraction;
import tree.Cluster;
import tree.Level;

public class HcmToHdfConverter {
    private final String chromosomeName;
    private final File hcmFile;
    private int totalClusters;
    private int totalPETInteractions;
    private int rootClusterIndex;
    private String[] proteinFactors;
    private final Level[] levels;
    private final ArrayList<Cluster> allClusters;
    private Cluster rootCluster;
    private final ArrayList<PETInteraction> petInteractions;

    public HcmToHdfConverter(String chromosomeName, File file) {
        this.chromosomeName = chromosomeName;
        this.hcmFile = file;
        this.levels = new Level[4];
        this.allClusters = new ArrayList();
        this.petInteractions = new ArrayList();
        this.initializeLevels();
    }

    private void initializeLevels() {
        for (int i = 0; i < this.levels.length; ++i) {
            this.levels[i] = new Level(i);
        }
    }

    private Cluster getClusterById(int id) {
        Cluster cluster = null;
        for (Cluster c : this.allClusters) {
            if (c.getID() != id) continue;
            cluster = c;
            break;
        }
        return cluster;
    }

    private int getProteinFactorIndex(String name) {
        int index = -1;
        for (int i = 0; i < this.proteinFactors.length; ++i) {
            if (!this.proteinFactors[i].equals(name)) continue;
            index = i;
            break;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadHcmFile(boolean hasWholeChromosomeNode) {
        FileReader fr = null;
        BufferedReader br = null;
        HashMap level3Children = new HashMap(500);
        ArrayList<Cluster> clustersInHashMap = new ArrayList<Cluster>();
        try {
            Cluster c1;
            String line;
            fr = new FileReader(this.hcmFile);
            br = new BufferedReader(fr);
            Scanner sc = new Scanner(br.readLine());
            this.totalClusters = Integer.parseInt(sc.next());
            this.totalPETInteractions = Integer.parseInt(sc.next());
            this.rootClusterIndex = Integer.parseInt(sc.next());
            if (hasWholeChromosomeNode) {
                --this.rootClusterIndex;
            }
            this.proteinFactors = new String[Integer.parseInt(sc.next())];
            sc.close();
            sc = new Scanner(br.readLine());
            for (int j = 0; j < this.proteinFactors.length; ++j) {
                this.proteinFactors[j] = sc.next();
            }
            sc.close();
            int i = 0;
            while ((line = br.readLine()) != null) {
                sc = new Scanner(line);
                if (i < this.totalClusters) {
                    int firstClusterId;
                    sc.next();
                    int start = Integer.parseInt(sc.next());
                    int end = Integer.parseInt(sc.next());
                    Cluster newCluster = new Cluster(this.chromosomeName, start, end);
                    Site site = newCluster.getSite();
                    double x = Double.parseDouble(sc.next());
                    double y = Double.parseDouble(sc.next());
                    double z = Double.parseDouble(sc.next());
                    site.setPosition(x, y, z);
                    if (Integer.parseInt(sc.next()) == 0) {
                        if (i < this.rootClusterIndex) {
                            newCluster.setLevel(2);
                        } else {
                            newCluster.setLevel(3);
                        }
                        this.allClusters.add(newCluster);
                        this.levels[newCluster.getLevel()].addCluster(newCluster);
                    } else if (i == this.rootClusterIndex) {
                        firstClusterId = Integer.parseInt(sc.next());
                        newCluster.addChild(this.getClusterById(firstClusterId));
                        this.rootCluster = newCluster;
                        this.allClusters.add(newCluster);
                    } else {
                        if (i == this.rootClusterIndex + 1 && hasWholeChromosomeNode) {
                            ++i;
                            continue;
                        }
                        firstClusterId = Integer.parseInt(sc.next());
                        Cluster c = this.getClusterById(firstClusterId);
                        newCluster.setLevel(c.getLevel() - 1);
                        newCluster.addChild(c);
                        while (sc.hasNext()) {
                            int ii = Integer.parseInt(sc.next());
                            Cluster cc = this.getClusterById(ii);
                            if (cc != null) {
                                newCluster.addChild(cc);
                                continue;
                            }
                            if (level3Children.get(newCluster) == null) {
                                clustersInHashMap.add(newCluster);
                                level3Children.put(newCluster, new ArrayList());
                            }
                            ((ArrayList)level3Children.get(newCluster)).add(ii);
                        }
                        this.allClusters.add(newCluster);
                        this.levels[newCluster.getLevel()].addCluster(newCluster);
                    }
                } else {
                    int index0 = Integer.parseInt(sc.next());
                    int index1 = Integer.parseInt(sc.next());
                    int interactionCount = Integer.parseInt(sc.next());
                    String factor = this.proteinFactors[Integer.parseInt(sc.next())];
                    Cluster c0 = this.getClusterById(index0);
                    c1 = this.getClusterById(index1);
                    if (c0 == null) {
                        System.out.println("Null cluster c0. Tried id " + index0);
                        System.exit(1);
                    }
                    if (c1 == null) {
                        System.out.println("Null cluster c1. Tried id " + index1);
                        System.exit(1);
                    }
                    PETInteraction petInteraction = new PETInteraction(factor, this.chromosomeName, c0, c1, interactionCount);
                    this.petInteractions.add(petInteraction);
                    br.readLine();
                }
                sc.close();
                ++i;
            }
            for (Cluster cc : clustersInHashMap) {
                ArrayList indices = (ArrayList)level3Children.get(cc);
                for (Integer ii : indices) {
                    c1 = this.getClusterById(ii);
                    if (c1 != null) {
                        cc.addChild(c1);
                        continue;
                    }
                    System.out.println("Got null child from hashmap array.");
                    System.out.println("Parent cluster index " + cc.getID());
                    System.out.println("Child index " + ii);
                    System.exit(1);
                }
            }
            if (hasWholeChromosomeNode) {
                --this.totalClusters;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.out);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException bioe) {
                    bioe.printStackTrace(System.out);
                }
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException fioe) {
                    fioe.printStackTrace(System.out);
                }
            }
        }
    }

    public void writeHcmFile(String fileName) {
        try (PrintWriter p = new PrintWriter((Writer)new FileWriter(new File(fileName)), true);){
            p.print(this.totalClusters + " " + this.totalPETInteractions + " " + this.rootClusterIndex + " " + this.proteinFactors.length + "\n");
            for (int i = 0; i < this.proteinFactors.length; ++i) {
                if (i != this.proteinFactors.length - 1) {
                    p.print(this.proteinFactors[i] + " ");
                    continue;
                }
                p.print(this.proteinFactors[i] + "\n");
            }
            for (Cluster c : this.levels[2].getClusters()) {
                p.print(c.printCluster() + "\n");
            }
            for (Cluster c : this.levels[1].getClusters()) {
                p.print(c.printCluster() + "\n");
            }
            for (Cluster c : this.levels[0].getClusters()) {
                p.print(c.printCluster() + "\n");
            }
            p.print(this.rootCluster.printCluster() + "\n");
            for (Cluster c : this.levels[3].getClusters()) {
                p.print(c.printCluster() + "\n");
            }
            for (PETInteraction pet : this.petInteractions) {
                int index = this.getProteinFactorIndex(pet.getProteinFactor());
                p.print(pet.getAnchor(0).getCluster().getID() + " " + pet.getAnchor(1).getCluster().getID() + " " + pet.getInteractionCount() + " " + index + "\n");
                p.print(pet.getGenomicPosition(0) + " " + pet.getGenomicPosition(1) + " " + pet.getInteractionCount() + " " + index + "\n");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHdfFile(String fileName, String id, boolean overwrite) {
        IHDF5Writer writer = null;
        try {
            writer = overwrite ? HDF5Factory.configure(fileName).overwrite().writer() : HDF5Factory.configure(fileName).writer();
            for (int i = 0; i < this.levels.length; ++i) {
                JHDF5IO.saveLevel(writer, id + "/" + this.chromosomeName + "/level" + i, this.levels[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception ioe) {
                    ioe.printStackTrace(System.out);
                }
            }
        }
        JHDF5IO.savePETs(fileName, id, this.chromosomeName, this.petInteractions);
    }

    public static void main(String[] args) {
        String outputName;
        if (args.length <= 1 || args.length > 3) {
            System.out.println("Improper arguments provided.\nExample usage:\tjava -jar HcmToHdfConverter.jar chr10 inputFile.hcm outputFile.h5\nArguments:\n1) Chromosome. Mandatory. Must be in form chrN.\n2) Input file. Mandatory. Must be in hcm format.\n3) Output file. Optional. If omitted, ouput will have the same name as input but with hcm replaced by h5.");
            System.exit(0);
        }
        String chromosome = args[0];
        boolean inputOK = false;
        for (String s : ChromosomeData.chromosomes) {
            if (!s.equals(chromosome)) continue;
            inputOK = true;
            break;
        }
        if (!inputOK) {
            System.out.println("Expect first argument to be in form chrN, but received " + args[0] + ".");
            System.exit(1);
        }
        String inputName = args[1];
        if (args.length == 2) {
            if (inputName.length() > 4) {
                String extension = inputName.substring(inputName.length() - 4);
                if (extension.equals(".hcm")) {
                    String leadingPart = inputName.substring(0, inputName.length() - 4);
                    outputName = leadingPart + ".h5";
                } else {
                    outputName = inputName + ".h5";
                }
            } else {
                outputName = inputName + ".h5";
            }
        } else {
            String ext;
            outputName = args[2];
            if (outputName.length() > 3 && !(ext = outputName.substring(outputName.length() - 3)).equals(".h5")) {
                outputName = outputName + ".h5";
            }
        }
        File f = new File(inputName);
        HcmToHdfConverter converter = new HcmToHdfConverter(chromosome, f);
        converter.loadHcmFile(true);
        converter.writeHdfFile(outputName, "HCMConverted", true);
    }
}

