/*
 * The MIT License
 *
 * Copyright (c) 2009 The Broad Institute
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package htsjdk.samtools;

import java.io.Serializable;

/**
 * One component of a cigar string. The component comprises the operator, and
 * the number of bases to which the operator applies.
 */
public class CigarElement implements Serializable {
	public static final long serialVersionUID = 1L;

	private final int length;
	private final CigarOperator operator;

	public CigarElement(final int length, final CigarOperator operator) {
		this.length = length;
		this.operator = operator;
	}

	public int getLength() {
		return length;
	}

	public CigarOperator getOperator() {
		return operator;
	}

	@Override
	public boolean equals(final Object o) {
		if (this == o)
			return true;
		if (!(o instanceof CigarElement))
			return false;

		final CigarElement that = (CigarElement) o;

		if (length != that.length)
			return false;
		if (operator != that.operator)
			return false;

		return true;
	}

	@Override
	public int hashCode() {
		int result = length;
		result = 31 * result + (operator != null ? operator.hashCode() : 0);
		return result;
	}
}
