/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.IClass;
import org.testng.IHookable;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.SuiteRunState;
import org.testng.TestException;
import org.testng.TestNGException;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.IConfigurationListener;
import org.testng.internal.IInvoker;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.InvokeMethodRunnable;
import org.testng.internal.InvokedMethod;
import org.testng.internal.MethodHelper;
import org.testng.internal.MethodInstance;
import org.testng.internal.Parameters;
import org.testng.internal.SingleTestMethodWorker;
import org.testng.internal.TestMethodWorker;
import org.testng.internal.TestResult;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IConfiguration;
import org.testng.internal.thread.ThreadExecutionException;
import org.testng.internal.thread.ThreadUtil;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invoker
implements IInvoker {
    private ITestContext m_testContext;
    private ITestResultNotifier m_notifier;
    private IAnnotationFinder m_annotationFinder;
    private SuiteRunState m_suiteState;
    private Map<String, Boolean> m_beforegroupsFailures = new Hashtable<String, Boolean>();
    private Map<Class, Boolean> m_classInvocationResults = new Hashtable<Class, Boolean>();

    public Invoker(ITestContext testContext, ITestResultNotifier notifier, SuiteRunState state, IAnnotationFinder annotationFinder) {
        this.m_testContext = testContext;
        this.m_suiteState = state;
        this.m_notifier = notifier;
        this.m_annotationFinder = annotationFinder;
    }

    @Override
    public void invokeConfigurations(IClass testClass, ITestNGMethod[] allMethods, XmlSuite suite, Map<String, String> params, Object instance) {
        this.invokeConfigurations(testClass, null, allMethods, suite, params, instance);
    }

    private void invokeConfigurations(IClass testClass, ITestNGMethod currentTestMethod, ITestNGMethod[] allMethods, XmlSuite suite, Map<String, String> params, Object instance) {
        ITestNGMethod[] methods;
        if (null == allMethods) {
            this.log(5, "No @Configuration methods found");
            return;
        }
        for (ITestNGMethod tm : methods = this.filterMethodsUnique(testClass, allMethods)) {
            if (null == testClass) {
                testClass = tm.getTestClass();
            }
            TestResult testResult = new TestResult(testClass, instance, tm, null, System.currentTimeMillis(), System.currentTimeMillis());
            IConfiguration configurationAnnotation = null;
            try {
                Object[] instances = tm.getInstances();
                if (instances == null || instances.length == 0) {
                    instances = new Object[]{instance};
                }
                Class<?> objectClass = instances[0].getClass();
                Method method = tm.getMethod();
                if (MethodHelper.isEnabled(objectClass, this.m_annotationFinder)) {
                    Object[] objectArray;
                    configurationAnnotation = AnnotationHelper.findConfiguration(this.m_annotationFinder, method);
                    boolean isClassConfiguration = this.isClassConfiguration(configurationAnnotation);
                    boolean alwaysRun = this.isAlwaysRun(configurationAnnotation);
                    if (!this.confInvocationPassed(tm) && !alwaysRun) {
                        this.handleConfigurationSkip(tm, testResult);
                        continue;
                    }
                    this.log(3, "Invoking " + Utils.detailedMethodName(tm, true));
                    Object[] parameters = Parameters.createConfigurationParameters(tm.getMethod(), params, currentTestMethod, this.m_annotationFinder, suite);
                    testResult.setParameters(parameters);
                    if (null != instance) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = instance;
                    } else {
                        objectArray = instances;
                    }
                    Object[] newInstances = objectArray;
                    this.invokeConfigurationMethod(newInstances, tm, parameters, isClassConfiguration, testResult);
                    testResult.setEndMillis(System.currentTimeMillis());
                    this.runConfigurationListeners(testResult);
                    continue;
                }
                this.log(3, "Skipping " + Utils.detailedMethodName(tm, true) + " because " + objectClass.getName() + " is not enabled");
            }
            catch (InvocationTargetException ex) {
                this.handleConfigurationFailure(ex, tm, testResult, configurationAnnotation, suite);
            }
            catch (TestNGException ex) {
                this.handleConfigurationFailure(ex, tm, testResult, configurationAnnotation, suite);
            }
            catch (Throwable ex) {
                this.handleConfigurationFailure(ex, tm, testResult, configurationAnnotation, suite);
            }
        }
    }

    private void handleConfigurationSkip(ITestNGMethod tm, ITestResult testResult) {
        testResult.setStatus(3);
        this.runConfigurationListeners(testResult);
    }

    private boolean isClassConfiguration(IConfiguration configurationAnnotation) {
        if (null == configurationAnnotation) {
            return false;
        }
        boolean before = null != configurationAnnotation ? configurationAnnotation.getBeforeTestClass() : false;
        boolean after = null != configurationAnnotation ? configurationAnnotation.getAfterTestClass() : false;
        return before || after;
    }

    private boolean isAlwaysRun(IConfiguration configurationAnnotation) {
        if (null == configurationAnnotation) {
            return false;
        }
        boolean alwaysRun = false;
        if ((configurationAnnotation.getAfterSuite() || configurationAnnotation.getAfterTest() || configurationAnnotation.getAfterTestClass() || configurationAnnotation.getAfterTestMethod()) && configurationAnnotation.getAlwaysRun()) {
            alwaysRun = true;
        }
        return alwaysRun;
    }

    private void handleConfigurationFailure(Throwable ite, ITestNGMethod tm, ITestResult testResult, IConfiguration annotation, XmlSuite suite) {
        Throwable cause = ite.getCause() != null ? ite.getCause() : ite;
        Utils.log("", 3, "Failed to invoke @Configuration method " + tm.getRealClass().getName() + "." + tm.getMethodName() + ":" + cause.getMessage());
        this.handleException(cause, tm, testResult, 1, false);
        this.runConfigurationListeners(testResult);
        if (null != annotation) {
            this.recordConfigurationInvocationFailed(tm, annotation, suite);
        }
    }

    private XmlClass[] findClassesInSameTest(Class cls, XmlSuite suite) {
        HashMap<String, XmlClass> vResult = new HashMap<String, XmlClass>();
        String className = cls.getName();
        for (XmlTest test : suite.getTests()) {
            for (XmlClass testClass : test.getXmlClasses()) {
                if (!testClass.getName().equals(className)) continue;
                for (XmlClass thisClass : test.getXmlClasses()) {
                    vResult.put(thisClass.getName(), thisClass);
                }
            }
        }
        XmlClass[] result = vResult.values().toArray(new XmlClass[vResult.size()]);
        return result;
    }

    private void recordConfigurationInvocationFailed(ITestNGMethod tm, IConfiguration annotation, XmlSuite suite) {
        if (annotation.getBeforeTestClass() || annotation.getAfterTestClass() || annotation.getBeforeTestMethod() || annotation.getAfterTestMethod()) {
            this.setClassInvocationFailure(tm.getRealClass(), false);
        } else if (annotation.getBeforeSuite() || annotation.getAfterSuite()) {
            this.m_suiteState.failed();
        } else if (annotation.getBeforeTest() || annotation.getAfterTest()) {
            XmlClass[] classes = this.findClassesInSameTest(tm.getRealClass(), suite);
            for (XmlClass xmlClass : classes) {
                this.setClassInvocationFailure(xmlClass.getSupportClass(), false);
            }
        }
        String[] beforeGroups = annotation.getBeforeGroups();
        if (null != beforeGroups && beforeGroups.length > 0) {
            for (String group : beforeGroups) {
                this.m_beforegroupsFailures.put(group, Boolean.FALSE);
            }
        }
    }

    private boolean confInvocationPassed(ITestNGMethod method) {
        boolean result = true;
        Class<?> cls = method.getMethod().getDeclaringClass();
        if (this.m_suiteState.isFailed()) {
            result = false;
        } else if (this.m_classInvocationResults.containsKey(cls)) {
            result = this.m_classInvocationResults.get(cls);
        } else {
            for (Class clazz : this.m_classInvocationResults.keySet()) {
                if (!clazz.isAssignableFrom(cls)) continue;
                result = false;
                break;
            }
        }
        String[] groups = method.getGroups();
        if (null != groups && groups.length > 0) {
            for (String group : groups) {
                if (!this.m_beforegroupsFailures.containsKey(group)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private void setClassInvocationFailure(Class clazz, boolean flag) {
        this.m_classInvocationResults.put(clazz, flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeConfigurationMethod(Object[] instances, ITestNGMethod tm, Object[] params, boolean isClass, ITestResult testResult) throws InvocationTargetException, IllegalAccessException {
        tm.setId(ThreadUtil.currentThreadInfo());
        long timeOut = tm.getTimeOut();
        for (Object targetInstance : instances) {
            InvokedMethod im = new InvokedMethod(targetInstance, tm, params, false, isClass, System.currentTimeMillis());
            this.m_notifier.addInvokedMethod(im);
            try {
                Reporter.setCurrentTestResult(testResult);
                MethodHelper.invokeMethod(tm.getMethod(), targetInstance, params);
            }
            finally {
                Reporter.setCurrentTestResult(testResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ITestResult> invokeTestMethod(Object[] instances, ITestNGMethod tm, Object[] parameterValues, XmlSuite suite, Map<String, String> params, ITestClass testClass, ITestNGMethod[] beforeMethods, ITestNGMethod[] afterMethods, ConfigurationGroupMethods groupMethods) {
        ArrayList<ITestResult> results = new ArrayList<ITestResult>();
        tm.setId(ThreadUtil.currentThreadInfo());
        for (int i = 0; i < instances.length; ++i) {
            this.invokeBeforeGroupsConfigurations(testClass, tm, groupMethods, suite, params, instances[i]);
            this.invokeConfigurations(testClass, tm, beforeMethods, suite, params, instances[i]);
            TestResult testResult = null;
            try {
                testResult = new TestResult(testClass, instances[i], tm, null, System.currentTimeMillis(), 0L);
                testResult.setParameters(parameterValues);
                testResult.setHost(this.m_testContext.getHost());
                testResult.setStatus(16);
                this.runTestListeners(testResult);
                results.add(testResult);
                InvokedMethod invokedMethod = new InvokedMethod(instances[i], tm, parameterValues, true, false, System.currentTimeMillis());
                this.m_notifier.addInvokedMethod(invokedMethod);
                Method thisMethod = tm.getMethod();
                if (this.confInvocationPassed(tm)) {
                    this.log(3, "Invoking " + thisMethod.getDeclaringClass().getName() + "." + thisMethod.getName());
                    if (tm.getTimeOut() <= 0L) {
                        if (IHookable.class.isAssignableFrom(thisMethod.getDeclaringClass())) {
                            MethodHelper.invokeHookable(instances[i], parameterValues, testClass, thisMethod, testResult);
                            testResult.setStatus(1);
                            continue;
                        }
                        try {
                            Reporter.setCurrentTestResult(testResult);
                            MethodHelper.invokeMethod(thisMethod, instances[i], parameterValues);
                            testResult.setStatus(1);
                            continue;
                        }
                        finally {
                            Reporter.setCurrentTestResult(null);
                        }
                    }
                    try {
                        Reporter.setCurrentTestResult(testResult);
                        MethodHelper.invokeWithTimeout(tm, instances[i], parameterValues, testResult);
                        continue;
                    }
                    finally {
                        Reporter.setCurrentTestResult(null);
                    }
                }
                testResult.setStatus(3);
                continue;
            }
            catch (InvocationTargetException ite) {
                testResult.setThrowable(ite.getCause());
                continue;
            }
            catch (ThreadExecutionException tee) {
                Throwable cause = tee.getCause();
                if (InvokeMethodRunnable.TestNGRuntimeException.class.equals(cause.getClass())) {
                    testResult.setThrowable(cause.getCause());
                    continue;
                }
                testResult.setThrowable(cause);
                continue;
            }
            catch (Throwable thr) {
                testResult.setThrowable(thr);
                continue;
            }
            finally {
                tm.incrementCurrentInvocationCount();
                if (testResult != null) {
                    testResult.setEndMillis(System.currentTimeMillis());
                }
                this.invokeConfigurations(testClass, tm, afterMethods, suite, params, instances[i]);
                this.invokeAfterGroupsConfigurations(testClass, tm, groupMethods, suite, params, instances[i]);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeBeforeGroupsConfigurations(ITestClass testClass, ITestNGMethod currentTestMethod, ConfigurationGroupMethods groupMethods, XmlSuite suite, Map<String, String> params, Object instance) {
        ConfigurationGroupMethods configurationGroupMethods = groupMethods;
        synchronized (configurationGroupMethods) {
            ArrayList<ITestNGMethod> filteredMethods = new ArrayList<ITestNGMethod>();
            String[] groups = currentTestMethod.getGroups();
            Map<String, List<ITestNGMethod>> beforeGroupMap = groupMethods.getBeforeGroupsMap();
            for (String group : groups) {
                List<ITestNGMethod> methods = beforeGroupMap.get(group);
                if (methods == null) continue;
                filteredMethods.addAll(methods);
            }
            ITestNGMethod[] beforeMethodsArray = filteredMethods.toArray(new ITestNGMethod[filteredMethods.size()]);
            if (beforeMethodsArray.length > 0) {
                this.invokeConfigurations(null, beforeMethodsArray, suite, params, null);
            }
            groupMethods.removeBeforeGroups(groups);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeAfterGroupsConfigurations(ITestClass testClass, ITestNGMethod currentTestMethod, ConfigurationGroupMethods groupMethods, XmlSuite suite, Map<String, String> params, Object instance) {
        if (currentTestMethod.getGroups().length == 0) {
            return;
        }
        HashMap<String, String> filteredGroups = new HashMap<String, String>();
        String[] groups = currentTestMethod.getGroups();
        ConfigurationGroupMethods configurationGroupMethods = groupMethods;
        synchronized (configurationGroupMethods) {
            for (String group : groups) {
                if (!groupMethods.isLastMethodForGroup(group, currentTestMethod)) continue;
                filteredGroups.put(group, group);
            }
            if (filteredGroups.isEmpty()) {
                return;
            }
            HashMap<ITestNGMethod, ITestNGMethod> afterMethods = new HashMap<ITestNGMethod, ITestNGMethod>();
            Map<String, List<ITestNGMethod>> map = groupMethods.getAfterGroupsMap();
            for (String g : filteredGroups.values()) {
                List<ITestNGMethod> methods = map.get(g);
                if (methods == null) continue;
                for (ITestNGMethod m : methods) {
                    afterMethods.put(m, m);
                }
            }
            ITestNGMethod[] afterMethodsArray = afterMethods.keySet().toArray(new ITestNGMethod[afterMethods.size()]);
            this.invokeConfigurations(null, afterMethodsArray, suite, params, null);
            groupMethods.removeAfterGroups(filteredGroups.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITestResult> invokeTestMethods(ITestNGMethod testMethod, ITestNGMethod[] allTestMethods, int testMethodIndex, XmlSuite suite, Map<String, String> parameters, ConfigurationGroupMethods groupMethods, Object[] instances, ITestContext testContext) {
        assert (null != testMethod.getTestClass()) : "COULDN'T FIND TESTCLASS FOR " + testMethod.getMethod().getDeclaringClass();
        List<ITestResult> result = new ArrayList<ITestResult>();
        ITestClass testClass = testMethod.getTestClass();
        Method method = testMethod.getMethod();
        long start = System.currentTimeMillis();
        int invocationCount = testMethod.getThreadPoolSize() > 1 ? 1 : testMethod.getInvocationCount();
        int failureCount = 0;
        Class[] expectedExceptionClasses = MethodHelper.findExpectedExceptions(this.m_annotationFinder, testMethod.getMethod());
        while (invocationCount-- > 0) {
            boolean okToProceed = this.checkDependencies(testMethod, testClass, allTestMethods);
            if (okToProceed) {
                if (!MethodHelper.isEnabled(testMethod.getMethod(), this.m_annotationFinder)) continue;
                if (testMethod.getThreadPoolSize() > 1) {
                    try {
                        result = this.invokePooledTestMethods(testMethod, allTestMethods, suite, parameters, groupMethods, testContext);
                        continue;
                    }
                    finally {
                        failureCount = this.handleInvocationResults(testMethod, result, failureCount, expectedExceptionClasses, false);
                        continue;
                    }
                }
                ITestNGMethod[] beforeMethods = this.filterMethods(testClass, testClass.getBeforeTestMethods());
                ITestNGMethod[] afterMethods = this.filterMethods(testClass, testClass.getAfterTestMethods());
                HashMap<String, String> allParameterNames = new HashMap<String, String>();
                Iterator<Object[]> allParameterValues = Parameters.handleParameters(testMethod, allParameterNames, testClass, parameters, suite, this.m_annotationFinder, testContext);
                while (allParameterValues.hasNext()) {
                    Object[] parameterValues = allParameterValues.next();
                    try {
                        result = this.invokeTestMethod(instances, testMethod, parameterValues, suite, allParameterNames, testClass, beforeMethods, afterMethods, groupMethods);
                    }
                    finally {
                        failureCount = this.handleInvocationResults(testMethod, result, failureCount, expectedExceptionClasses, true);
                    }
                }
                continue;
            }
            TestResult testResult = new TestResult(testClass, null, testMethod, null, start, System.currentTimeMillis());
            testResult.setEndMillis(System.currentTimeMillis());
            String missingGroup = testMethod.getMissingGroup();
            if (missingGroup != null) {
                testResult.setThrowable(new Throwable("Method " + testMethod + " depends on nonexistent group \"" + missingGroup + "\""));
            }
            testResult.setStatus(3);
            this.m_notifier.addSkippedTest(testMethod, testResult);
            this.runTestListeners(testResult);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ITestResult> invokePooledTestMethods(ITestNGMethod testMethod, ITestNGMethod[] allTestMethods, XmlSuite suite, Map<String, String> parameters, ConfigurationGroupMethods groupMethods, ITestContext testContext) {
        Object[] instances;
        ITestClass testClass = testMethod.getTestClass();
        for (Object instance : instances = testClass.getInstances(true)) {
            this.invokeBeforeGroupsConfigurations(testClass, testMethod, groupMethods, suite, parameters, instance);
        }
        ArrayList<ITestResult> result = new ArrayList();
        ArrayList<TestMethodWorker> workers = new ArrayList<TestMethodWorker>();
        ArrayList<ITestNGMethod> clones = new ArrayList<ITestNGMethod>(testMethod.getInvocationCount());
        for (int i = 0; i < testMethod.getInvocationCount(); ++i) {
            ITestNGMethod clonedMethod = testMethod.clone();
            clonedMethod.setInvocationCount(1);
            clonedMethod.setThreadPoolSize(1);
            clones.add(clonedMethod);
            MethodInstance mi = new MethodInstance(clonedMethod, clonedMethod.getTestClass().getInstances(true));
            workers.add(new SingleTestMethodWorker(this, mi, suite, parameters, allTestMethods, testContext));
        }
        try {
            result = this.runWorkers(testMethod, workers, testMethod.getThreadPoolSize());
        }
        finally {
            for (ITestNGMethod clone : clones) {
                clone = null;
            }
            clones.clear();
            clones = null;
            for (Object instance : instances) {
                this.invokeAfterGroupsConfigurations(testClass, testMethod, groupMethods, suite, parameters, instance);
            }
        }
        return result;
    }

    private int handleInvocationResults(ITestNGMethod testMethod, List<ITestResult> result, int failureCount, Class[] expectedExceptionClasses, boolean triggerListeners) {
        for (ITestResult testResult : result) {
            Throwable ite = testResult.getThrowable();
            int status = testResult.getStatus();
            if (ite != null) {
                if (this.isExpectedException(ite, expectedExceptionClasses)) {
                    testResult.setStatus(1);
                    status = 1;
                } else {
                    this.handleException(ite, testMethod, testResult, failureCount++, true);
                    status = testResult.getStatus();
                }
            } else if (status != 3 && expectedExceptionClasses.length > 0) {
                testResult.setThrowable(new TestException("Expected an exception in test method " + testMethod));
                status = 2;
            }
            testResult.setStatus(status);
            if (1 == status) {
                this.m_notifier.addPassedTest(testMethod, testResult);
            } else if (3 == status) {
                this.m_notifier.addSkippedTest(testMethod, testResult);
            } else if (2 == status) {
                this.m_notifier.addFailedTest(testMethod, testResult);
            } else if (4 == status) {
                this.m_notifier.addFailedButWithinSuccessPercentageTest(testMethod, testResult);
            } else assert (false) : "UNKNOWN STATUS:" + status;
            if (!triggerListeners) continue;
            this.runTestListeners(testResult);
        }
        return failureCount;
    }

    private List<ITestResult> runWorkers(ITestNGMethod testMethod, List<TestMethodWorker> workers, int threadPoolSize) {
        long maxTimeOut = -1L;
        for (TestMethodWorker tmw : workers) {
            long mt = tmw.getMaxTimeOut();
            if (mt <= maxTimeOut) continue;
            maxTimeOut = mt;
        }
        ThreadUtil.execute(workers, threadPoolSize, maxTimeOut, true);
        ArrayList<ITestResult> result = new ArrayList<ITestResult>();
        for (TestMethodWorker tmw : workers) {
            result.addAll(tmw.getTestResults());
        }
        return result;
    }

    private boolean checkDependencies(ITestNGMethod testMethod, ITestClass testClass, ITestNGMethod[] allTestMethods) {
        boolean result = true;
        if (testMethod.isAlwaysRun()) {
            return true;
        }
        if (testMethod.getMissingGroup() != null) {
            return false;
        }
        if (this.dependsOnGroups(testMethod)) {
            String[] groupsDependedUpon = testMethod.getGroupsDependedUpon();
            for (int i = 0; i < groupsDependedUpon.length; ++i) {
                ITestNGMethod[] methods = MethodHelper.findMethodsThatBelongToGroup(testMethod, this.m_testContext.getAllTestMethods(), groupsDependedUpon[i]);
                result = result && this.haveBeenRunSuccessfully(methods);
            }
        }
        if (this.dependsOnMethods(testMethod)) {
            ITestNGMethod[] methods = MethodHelper.findMethodsNamed(testMethod.getMethod().getName(), allTestMethods, testMethod.getMethodsDependedUpon());
            result = result && this.haveBeenRunSuccessfully(methods);
        }
        return result;
    }

    private boolean haveBeenRunSuccessfully(ITestNGMethod[] methods) {
        for (int j = 0; j < methods.length; ++j) {
            Set<ITestResult> results = this.m_notifier.getPassedTests(methods[j]);
            if (results == null || results.size() == 0) {
                return false;
            }
            for (ITestResult result : results) {
                if (result.isSuccess()) continue;
                return false;
            }
        }
        return true;
    }

    private void handleException(Throwable throwable, ITestNGMethod testMethod, ITestResult testResult, int failureCount, boolean notify) {
        testResult.setThrowable(throwable);
        int successPercentage = testMethod.getSuccessPercentage();
        int invocationCount = testMethod.getInvocationCount();
        float numberOfTestsThatCanFail = (100 - successPercentage) * invocationCount / 100;
        if ((float)failureCount < numberOfTestsThatCanFail) {
            testResult.setStatus(4);
            if (notify) {
                this.m_notifier.addFailedButWithinSuccessPercentageTest(testMethod, testResult);
            }
        } else {
            testResult.setStatus(2);
            if (notify) {
                this.m_notifier.addFailedTest(testMethod, testResult);
            }
        }
    }

    private boolean isExpectedException(Throwable ite, Class[] exceptions) {
        if (null == exceptions) {
            return false;
        }
        Class<?> realExceptionClass = ite.getClass();
        for (int i = 0; i < exceptions.length; ++i) {
            if (!exceptions[i].isAssignableFrom(realExceptionClass)) continue;
            return true;
        }
        return false;
    }

    private ITestNGMethod[] filterMethods(IClass testClass, ITestNGMethod[] methods) {
        ArrayList<ITestNGMethod> vResult = new ArrayList<ITestNGMethod>();
        for (ITestNGMethod tm : methods) {
            if (tm.canRunFromClass(testClass)) {
                this.log(9, "Keeping method " + tm + " for class " + testClass);
                vResult.add(tm);
                continue;
            }
            this.log(9, "Filtering out method " + tm + " for class " + testClass);
        }
        ITestNGMethod[] result = vResult.toArray(new ITestNGMethod[vResult.size()]);
        return result;
    }

    private ITestNGMethod[] filterMethodsUnique(IClass testClass, ITestNGMethod[] methods) {
        if (null == testClass) {
            return methods;
        }
        ArrayList<ITestNGMethod> vResult = new ArrayList<ITestNGMethod>();
        for (ITestNGMethod tm : methods) {
            if (null == testClass) {
                testClass = tm.getTestClass();
            }
            if (tm.getTestClass().getName().equals(testClass.getName())) {
                this.log(9, "        Keeping method " + tm + " for class " + testClass);
                vResult.add(tm);
                continue;
            }
            this.log(9, "        Filtering out method " + tm + " for class " + testClass);
        }
        ITestNGMethod[] result = vResult.toArray(new ITestNGMethod[vResult.size()]);
        return result;
    }

    private boolean dependsOnGroups(ITestNGMethod tm) {
        String[] groups = tm.getGroupsDependedUpon();
        boolean result = null != groups && groups.length > 0;
        return result;
    }

    private boolean dependsOnMethods(ITestNGMethod tm) {
        String[] methods = tm.getMethodsDependedUpon();
        boolean result = null != methods && methods.length > 0;
        return result;
    }

    private void runConfigurationListeners(ITestResult tr) {
        for (IConfigurationListener icl : this.m_notifier.getConfigurationListeners()) {
            switch (tr.getStatus()) {
                case 3: {
                    icl.onConfigurationSkip(tr);
                    break;
                }
                case 2: {
                    icl.onConfigurationFailure(tr);
                    break;
                }
                case 1: {
                    icl.onConfigurationSuccess(tr);
                }
            }
        }
    }

    private void runTestListeners(ITestResult tr) {
        Invoker.runTestListeners(tr, this.m_notifier.getTestListeners());
    }

    public static void runTestListeners(ITestResult tr, List<ITestListener> listeners) {
        block7: for (ITestListener itl : listeners) {
            switch (tr.getStatus()) {
                case 3: {
                    itl.onTestSkipped(tr);
                    continue block7;
                }
                case 4: {
                    itl.onTestFailedButWithinSuccessPercentage(tr);
                    continue block7;
                }
                case 2: {
                    itl.onTestFailure(tr);
                    continue block7;
                }
                case 1: {
                    itl.onTestSuccess(tr);
                    continue block7;
                }
                case 16: {
                    itl.onTestStart(tr);
                    continue block7;
                }
            }
            assert (false) : "UNKNOWN STATUS:" + tr;
        }
    }

    private static void ppp(String s) {
        System.out.println("[Invoker]" + s);
    }

    private void log(int level, String s) {
        Utils.log("Invoker " + Thread.currentThread().hashCode(), level, s);
    }
}

