/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.utils;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import edu.umd.marbl.mhap.main.MhapMain;
import edu.umd.marbl.mhap.utils.MhapRuntimeException;
import edu.umd.marbl.mhap.utils.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import org.apache.lucene.util.OpenBitSet;

public final class Utils {
    private static OpenBitSet validKmerHashes;
    public static final int BUFFER_BYTE_SIZE = 0x800000;
    public static final NumberFormat DECIMAL_FORMAT;
    public static final int FASTA_LINE_LENGTH = 60;
    public static final int MBYTES = 0x100000;

    public static int checkForEnd(String string, int n) {
        if (string.startsWith("{")) {
            ++n;
        }
        if (string.startsWith("}")) {
            --n;
        }
        if (n == 0) {
            return -1;
        }
        return n;
    }

    public static long[] computeHashes(String string, int n, int n2) {
        long[] lArray = new long[n];
        for (int i = 0; i < n; i += 2) {
            HashFunction hashFunction = Hashing.murmur3_128((int)(n2 + i));
            Hasher hasher = hashFunction.newHasher();
            hasher.putUnencodedChars((CharSequence)string);
            HashCode hashCode = hasher.hash();
            ByteBuffer byteBuffer = ByteBuffer.wrap(hashCode.asBytes());
            lArray[i] = byteBuffer.getLong(0);
            if (i + 1 >= n) continue;
            lArray[i + 1] = byteBuffer.getLong(8);
        }
        return lArray;
    }

    public static final int[] computeHashesInt(Object object, int n, int n2) {
        if (object instanceof Integer) {
            return Utils.computeHashesIntInt((Integer)object, n, n2);
        }
        if (object instanceof Long) {
            return Utils.computeHashesIntLong((Long)object, n, n2);
        }
        if (object instanceof Double) {
            return Utils.computeHashesIntDouble((Double)object, n, n2);
        }
        if (object instanceof Float) {
            return Utils.computeHashesIntFloat(((Float)object).floatValue(), n, n2);
        }
        if (object instanceof String) {
            return Utils.computeHashesIntString((String)object, n, n2);
        }
        throw new MhapRuntimeException("Cannot hash class type " + object.getClass().getCanonicalName());
    }

    public static final int[] computeHashesIntDouble(double d, int n, int n2) {
        int[] nArray = new int[n];
        HashFunction hashFunction = Hashing.murmur3_32((int)n2);
        for (int i = 0; i < n; ++i) {
            HashCode hashCode = hashFunction.newHasher().putDouble(d).putInt(i).hash();
            nArray[i] = hashCode.asInt();
        }
        return nArray;
    }

    public static final int[] computeHashesIntFloat(float f, int n, int n2) {
        int[] nArray = new int[n];
        HashFunction hashFunction = Hashing.murmur3_32((int)n2);
        for (int i = 0; i < n; ++i) {
            HashCode hashCode = hashFunction.newHasher().putFloat(f).putInt(i).hash();
            nArray[i] = hashCode.asInt();
        }
        return nArray;
    }

    public static final int[] computeHashesIntInt(int n, int n2, int n3) {
        int[] nArray = new int[n2];
        HashFunction hashFunction = Hashing.murmur3_32((int)n3);
        for (int i = 0; i < n2; ++i) {
            HashCode hashCode = hashFunction.newHasher().putInt(n).putInt(i).hash();
            nArray[i] = hashCode.asInt();
        }
        return nArray;
    }

    public static final int[] computeHashesIntLong(long l, int n, int n2) {
        int[] nArray = new int[n];
        HashFunction hashFunction = Hashing.murmur3_32((int)n2);
        for (int i = 0; i < n; ++i) {
            HashCode hashCode = hashFunction.newHasher().putLong(l).putInt(i).hash();
            nArray[i] = hashCode.asInt();
        }
        return nArray;
    }

    public static final int[] computeHashesIntString(String string, int n, int n2) {
        int[] nArray = new int[n];
        HashFunction hashFunction = Hashing.murmur3_32((int)n2);
        for (int i = 0; i < n; ++i) {
            HashCode hashCode = hashFunction.newHasher().putUnencodedChars((CharSequence)string).putInt(i).hash();
            nArray[i] = hashCode.asInt();
        }
        return nArray;
    }

    public static final long[][] computeKmerHashes(String string, int n, int n2, int n3) {
        int n4 = string.length() - n + 1;
        if (n4 < 1) {
            throw new MhapRuntimeException("Kmer size bigger than string length.");
        }
        long[] lArray = Utils.computeSequenceHashesLong(string, n, n3);
        long[][] lArray2 = new long[lArray.length][n2];
        for (int i = 0; i < lArray.length; ++i) {
            long l = lArray[i];
            for (int j = 0; j < n2; ++j) {
                l ^= l << 21;
                l ^= l >>> 35;
                l ^= l << 4;
                lArray2[i][j] = l;
            }
        }
        return lArray2;
    }

    public static final long[][] computeKmerHashesExact(String string, int n, int n2, int n3) {
        HashFunction hashFunction = Hashing.murmur3_128((int)n3);
        long[][] lArray = new long[string.length() - n + 1][n2];
        for (int i = 0; i < lArray.length; ++i) {
            String string2 = string.substring(i, i + n);
            for (int j = 0; j < n2; ++j) {
                HashCode hashCode = hashFunction.newHasher().putUnencodedChars((CharSequence)string2).putInt(j).hash();
                lArray[i][j] = hashCode.asLong();
            }
        }
        return lArray;
    }

    public static final int[] computeSequenceHashes(String string, int n) {
        HashFunction hashFunction = Hashing.murmur3_32((int)0);
        int[] nArray = new int[string.length() - n + 1];
        for (int i = 0; i < nArray.length; ++i) {
            HashCode hashCode = hashFunction.newHasher().putUnencodedChars((CharSequence)string.substring(i, i + n)).hash();
            nArray[i] = hashCode.asInt();
        }
        return nArray;
    }

    public static final long[] computeSequenceHashesLongValidKmers(String string, int n, int n2) {
        HashFunction hashFunction = Hashing.murmur3_128((int)n2);
        long[] lArray = new long[string.length() - n + 1];
        for (int i = 0; i < lArray.length; ++i) {
            String string2 = string.substring(i, i + n);
            lArray[i] = Long.MAX_VALUE;
            if (string2.contains("N")) continue;
            long l = Utils.computeHashYGS(string2);
            if (!MhapMain.getValidKmersHashes().fastGet(l)) continue;
            HashCode hashCode = hashFunction.newHasher().putUnencodedChars((CharSequence)string2).hash();
            lArray[i] = hashCode.asLong();
        }
        return lArray;
    }

    public static final long[] computeSequenceHashesLong(String string, int n, int n2) {
        HashFunction hashFunction = Hashing.murmur3_128((int)n2);
        long[] lArray = new long[string.length() - n + 1];
        for (int i = 0; i < lArray.length; ++i) {
            HashCode hashCode = hashFunction.newHasher().putUnencodedChars((CharSequence)string.substring(i, i + n)).hash();
            lArray[i] = hashCode.asLong();
        }
        return lArray;
    }

    public static final String convertToFasta(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        String[] stringArray = string.trim().split("\\s+");
        if (stringArray.length > 1) {
            int n2 = 0;
            for (n = 0; n < stringArray.length; ++n) {
                stringBuffer.append(stringArray[n]);
                n2 += stringArray[n].length();
                if (n == stringArray.length - 1) continue;
                if (n2 >= 60) {
                    n2 = 0;
                    stringBuffer.append("\n");
                    continue;
                }
                stringBuffer.append(" ");
            }
        } else {
            n = 0;
            while (n + 60 < string.length()) {
                stringBuffer.append(string.substring(n, n + 60));
                stringBuffer.append("\n");
                n += 60;
            }
            stringBuffer.append(string.substring(n, string.length()));
        }
        return stringBuffer.toString();
    }

    public static final int countLetterInRead(String string, String string2) {
        return Utils.countLetterInRead(string, string2, false);
    }

    public static final int countLetterInRead(String string, String string2, Boolean bl) {
        String string3 = Utils.getUngappedRead(string);
        int n = string3.length();
        if (n == 0) {
            return -1;
        }
        int n2 = string2.length();
        int n3 = 0;
        for (int i = 0; i <= string3.length() - n2; i += n2) {
            if (string2.equals(string3.substring(i, i + n2)) && bl.booleanValue()) {
                ++n3;
            }
            if (!string2.equalsIgnoreCase(string3.substring(i, i + n2)) || bl.booleanValue()) continue;
            ++n3;
        }
        return n3;
    }

    public static final HashSet<Long> createKmerFilter(String string, double d, int n, int n2) throws IOException {
        File file = new File(string);
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file), 0x800000);){
            Object object;
            ArrayList<Long> arrayList = new ArrayList<Long>();
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                object = string2.split("\\s+", 3);
                if (((String[])object).length < 2) {
                    throw new MhapRuntimeException("Kmer filter file must have at least two column [kmer kmer_percent].");
                }
                double d2 = Double.parseDouble(object[1]);
                if (!(d2 > d)) break;
                long[] lArray = Utils.computeSequenceHashesLong(object[0], n, n2);
                if (lArray.length > 1) {
                    System.err.println("Warning filter file kmer size larger than setting!");
                }
                for (long l : lArray) {
                    arrayList.add(l);
                }
                string2 = bufferedReader.readLine();
            }
            object = new HashSet(arrayList);
            return object;
        }
    }

    public static void createValidKmerFilter(String string, int n, int n2) throws FileNotFoundException, IOException {
        File file = new File(string);
        long l = 0xFFFFFFFFL;
        validKmerHashes = new OpenBitSet(l);
        boolean bl = false;
        Utils.checkValidKmersFile(file, n);
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file), 0x800000);){
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                long l2 = Utils.computeHashYGS(string2);
                validKmerHashes.fastSet(l2);
                String string3 = Utils.rc(string2);
                l2 = Utils.computeHashYGS(string3);
                validKmerHashes.fastSet(l2);
                string2 = bufferedReader.readLine();
            }
        }
    }

    private static void checkValidKmersFile(File file, int n) throws FileNotFoundException, IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String string = bufferedReader.readLine();
            for (int i = 1; string != null && i <= 100; ++i) {
                String[] stringArray = string.split("\\s+");
                if (stringArray.length > 1) {
                    throw new MhapRuntimeException("Valid kmer file must have at most one column [kmer]. Offending line: " + i + ". With text: " + string);
                }
                if (string.length() != n) {
                    throw new MhapRuntimeException("Kmers of valid kmers file have " + string.length() + ", but the expected was " + n + "Offending line: " + i + ". With text: " + string);
                }
                if (!string.matches("[^ATGCatgc]")) continue;
                throw new MhapRuntimeException("non ATGC character found at valid kmers file. Offending line: " + i + ". With text: " + string);
            }
        }
    }

    public static long computeHashYGS(String string) {
        String string2 = string.replaceAll("A", "00");
        string2 = string2.replaceAll("C", "01");
        string2 = string2.replaceAll("G", "10");
        string2 = string2.replaceAll("T", "11");
        long l = Long.parseLong(string2, 2);
        return l;
    }

    public static String reverseComputeHashYGS(long l) {
        String string = Long.toBinaryString(l);
        if (string.length() < 32) {
            string = Utils.completeZeros(string);
        }
        String string2 = "";
        for (int i = 0; i < 32; i += 2) {
            String string3 = string.substring(i, i + 2);
            string3 = string3.replaceAll("00", "A");
            string3 = string3.replaceAll("01", "C");
            string3 = string3.replaceAll("10", "G");
            string3 = string3.replaceAll("11", "T");
            string2 = string2 + string3;
        }
        return string2;
    }

    private static String completeZeros(String string) {
        while (string.length() < 32) {
            string = "0" + string;
        }
        return string;
    }

    public static long[] computeHashYGSToArray(String string, int n) {
        long[] lArray = new long[string.length() - n + 1];
        for (int i = 0; i < lArray.length; ++i) {
            String string2 = string.substring(i, i + n);
            lArray[i] = !string2.contains("N") ? Utils.computeHashYGS(string2) : Integer.MAX_VALUE;
        }
        return lArray;
    }

    public static final int[] errorString(int[] nArray, double d) {
        int[] nArray2 = (int[])nArray.clone();
        Random random = new Random();
        for (int i = 0; i < nArray.length; ++i) {
            if (!(random.nextDouble() < d)) continue;
            while (nArray2[i] == nArray[i]) {
                nArray2[i] = random.nextInt(3);
            }
        }
        return nArray2;
    }

    public static final int[] generateInts(long l, int n) {
        int[] nArray = new int[n];
        long l2 = l;
        for (int i = 0; i < n; ++i) {
            l2 ^= l2 << 21;
            l2 ^= l2 >>> 35;
            l2 ^= l2 << 4;
            nArray[i] = (int)l2;
        }
        return nArray;
    }

    public static final long[] generateLongs(long l, int n) {
        long[] lArray = new long[n];
        long l2 = l;
        for (int i = 0; i < n; ++i) {
            l2 ^= l2 << 21;
            l2 ^= l2 >>> 35;
            l2 ^= l2 << 4;
            lArray[i] = l2;
        }
        return lArray;
    }

    public static final BufferedReader getFile(String string, String string2) throws Exception {
        String[] stringArray = new String[]{string2};
        return Utils.getFile(string, stringArray);
    }

    public static final BufferedReader getFile(String string, String[] stringArray) throws IOException {
        BufferedReader bufferedReader = null;
        if (string.endsWith("bz2")) {
            System.err.println("Running command bzip2 -dc " + new File(string).getAbsolutePath() + " |");
            Process process = Runtime.getRuntime().exec("bzip2 -dc " + new File(string).getAbsolutePath() + " |");
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 0x800000);
            System.err.println(bufferedReader.ready());
        } else if (string.endsWith("gz")) {
            System.err.println("Runnning comand gzip -dc " + new File(string).getAbsolutePath() + " |");
            Process process = Runtime.getRuntime().exec("gzip -dc " + new File(string).getAbsolutePath() + " |");
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 0x800000);
            System.err.println(bufferedReader.ready());
        } else {
            int n = 0;
            for (n = 0; n < stringArray.length; ++n) {
                if (!string.endsWith(stringArray[n])) continue;
                bufferedReader = new BufferedReader(new FileReader(string), 0x800000);
                break;
            }
            if (n == stringArray.length) {
                System.err.println("Unknown file format " + string + " Skipping!");
            }
        }
        return bufferedReader;
    }

    public static final String getID(String string) {
        String[] stringArray = string.split(":");
        int n = stringArray[1].indexOf(",");
        if (n != -1) {
            return stringArray[1].substring(1, n).trim();
        }
        return stringArray[1];
    }

    public static final double getLetterPercentInRead(String string, String string2) {
        int n = Utils.getUngappedRead(string).length();
        int n2 = Utils.countLetterInRead(string, string2);
        return (double)n2 / (double)n;
    }

    public static final int getOvlSize(int n, int n2, int n3, int n4) {
        if (n3 <= 0 && n4 >= 0 || n3 >= 0 && n4 <= 0) {
            return -1;
        }
        if (n3 < 0) {
            return n - Math.abs(n4);
        }
        return n - n3;
    }

    public static final int getRangeOverlap(int n, int n2, int n3, int n4) {
        int n5 = Math.min(n, n2);
        int n6 = Math.min(n3, n4);
        int n7 = Math.max(n, n2);
        int n8 = Math.max(n3, n4);
        int n9 = Math.max(n5, n6);
        int n10 = Math.min(n7, n8);
        return n10 - n9 + 1;
    }

    public static final String getUngappedRead(String string) {
        string = string.replaceAll("N", "");
        string = string.replaceAll("-", "");
        assert (string.length() >= 0);
        return string;
    }

    public static final String getValue(String string, String string2) {
        if (string.startsWith(string2)) {
            return string.split(":")[1];
        }
        return null;
    }

    public static final <H> double hashEfficiency(HashMap<Integer, ArrayList<H>> hashMap) {
        double d = Utils.hashEnthropy(hashMap);
        double d2 = 1.0 / Math.log(2.0);
        double d3 = Math.log(hashMap.size()) * d2;
        return d / d3;
    }

    public static final <H> double hashEnthropy(HashMap<Integer, ArrayList<H>> hashMap) {
        double d = 0.0;
        double d2 = 1.0 / Math.log(2.0);
        double[] dArray = new double[hashMap.size()];
        int n = 0;
        int n2 = 0;
        for (ArrayList<H> arrayList : hashMap.values()) {
            n += arrayList.size();
            dArray[n2++] = arrayList.size();
        }
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = dArray[i] / (double)n;
            d -= d3 * Math.log(d3) * d2;
        }
        return d;
    }

    public static final boolean isAContainedInB(int n, int n2, int n3, int n4) {
        int n5 = Math.min(n, n2);
        int n6 = Math.min(n3, n4);
        int n7 = Math.max(n, n2);
        int n8 = Math.max(n3, n4);
        return n6 < n5 && n8 > n7;
    }

    public static final Pair<Double, Double> linearRegression(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += nArray[i] * nArray2[i];
            n3 += nArray[i];
            n4 += nArray2[i];
            n5 += nArray[i] * nArray[i];
        }
        double d = 1.0 / (double)n;
        double d2 = ((double)n2 - d * (double)(n3 * n4)) / ((double)n5 - d * (double)(n3 * n3));
        double d3 = d * ((double)n4 - d2 * (double)n3);
        return new Pair<Double, Double>(d3, d2);
    }

    public static final double mean(double[] dArray, int n) {
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i];
        }
        return d / (double)n;
    }

    public static final double mean(int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += nArray[i];
        }
        return (double)n2 / (double)n;
    }

    public static final double pearsonCorr(int[] nArray, int[] nArray2, int n) {
        if (n < 2) {
            return 0.0;
        }
        double d = Utils.mean(nArray, n);
        double d2 = Utils.mean(nArray2, n);
        double d3 = Utils.std(nArray, n, d);
        double d4 = Utils.std(nArray2, n, d2);
        double d5 = 0.0;
        for (int i = 0; i < n; ++i) {
            d5 += ((double)nArray[i] - d) * ((double)nArray2[i] - d2) / (d3 * d4);
        }
        return d5 / (double)(n - 1);
    }

    public static final int quickSelect(int[] nArray, int n, int n2) {
        if (nArray == null || n2 <= n) {
            return Integer.MAX_VALUE;
        }
        int n3 = 0;
        int n4 = n2 - 1;
        while (n3 < n4) {
            int n5 = n3;
            int n6 = n4;
            int n7 = nArray[(n5 + n6) / 2];
            while (n5 < n6) {
                if (nArray[n5] >= n7) {
                    int n8 = nArray[n6];
                    nArray[n6] = nArray[n5];
                    nArray[n5] = n8;
                    --n6;
                    continue;
                }
                ++n5;
            }
            if (nArray[n5] > n7) {
                --n5;
            }
            if (n <= n5) {
                n4 = n5;
                continue;
            }
            n3 = n5 + 1;
        }
        return nArray[n];
    }

    public static final String rc(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (c != '-') {
                Translate translate = Translate.valueOf(Character.toString(c).toUpperCase());
                stringBuilder.append(translate.getCompliment());
                continue;
            }
            stringBuilder.append("-");
        }
        return stringBuilder.toString();
    }

    public static final double std(double[] dArray, int n, double d) {
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d3 = dArray[i] - d;
            d2 += d3 * d3;
        }
        return Math.sqrt(d2 / (double)(n - 1));
    }

    public static final double std(int[] nArray, int n, double d) {
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d3 = (double)nArray[i] - d;
            d2 += d3 * d3;
        }
        return Math.sqrt(d2 / (double)(n - 1));
    }

    public static final String toProtein(String string, boolean bl, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            string = Utils.rc(string);
        }
        string = string.replaceAll("-", "");
        for (int i = n; i < string.length() - 3; i += 3) {
            String string2 = string.substring(i, i + 3);
            String string3 = ToProtein.valueOf(string2).getProtein();
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    public static String toString(double[][] dArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (double[] dArray2 : dArray) {
            if (dArray2 != null) {
                for (int i = 0; i < dArray2.length - 1; ++i) {
                    stringBuilder.append("" + dArray2[i] + ",");
                }
                if (dArray2.length > 0) {
                    stringBuilder.append("" + dArray2[dArray2.length - 1]);
                }
            }
            stringBuilder.append("\n");
        }
        stringBuilder.append("]");
        return new String(stringBuilder);
    }

    public static String toString(long[][] lArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (long[] lArray2 : lArray) {
            if (lArray2 != null) {
                for (int i = 0; i < lArray2.length - 1; ++i) {
                    stringBuilder.append("" + lArray2[i] + ",");
                }
                if (lArray2.length > 0) {
                    stringBuilder.append("" + lArray2[lArray2.length - 1]);
                }
            }
            stringBuilder.append("\n");
        }
        stringBuilder.append("]");
        return new String(stringBuilder);
    }

    public static OpenBitSet getValidKmerHashes() {
        return validKmerHashes;
    }

    static {
        DECIMAL_FORMAT = new DecimalFormat("############.########");
    }

    public static enum Translate {
        A("T"),
        B("V"),
        C("G"),
        D("H"),
        G("C"),
        H("D"),
        K("M"),
        M("K"),
        N("N"),
        R("Y"),
        S("S"),
        T("A"),
        V("B"),
        W("W"),
        Y("R");

        private String other;

        private Translate(String string2) {
            this.other = string2;
        }

        public String getCompliment() {
            return this.other;
        }
    }

    public static enum ToProtein {
        AAA("K"),
        AAC("N"),
        AAG("K"),
        AAT("N"),
        ACA("T"),
        ACC("T"),
        ACG("T"),
        ACT("T"),
        AGA("R"),
        AGC("S"),
        AGG("R"),
        AGT("S"),
        ATA("I"),
        ATC("I"),
        ATG("M"),
        ATT("I"),
        CAA("Q"),
        CAC("H"),
        CAG("Q"),
        CAT("H"),
        CCA("P"),
        CCC("P"),
        CCG("P"),
        CCT("P"),
        CGA("R"),
        CGC("R"),
        CGG("R"),
        CGT("R"),
        CTA("L"),
        CTC("L"),
        CTG("L"),
        CTT("L"),
        GAA("E"),
        GAC("D"),
        GAG("E"),
        GAT("D"),
        GCA("A"),
        GCC("A"),
        GCG("A"),
        GCT("A"),
        GGA("G"),
        GGC("G"),
        GGG("G"),
        GGT("G"),
        GTA("V"),
        GTC("V"),
        GTG("V"),
        GTT("V"),
        TAA("X"),
        TAC("Y"),
        TAG("X"),
        TAT("Y"),
        TCA("S"),
        TCC("S"),
        TCG("S"),
        TCT("S"),
        TGA("X"),
        TGC("C"),
        TGG("W"),
        TGT("C"),
        TTA("L"),
        TTC("F"),
        TTG("L"),
        TTT("F");

        private String other;

        private ToProtein(String string2) {
            this.other = string2;
        }

        public String getProtein() {
            return this.other;
        }
    }
}

