/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.utils;

import edu.umd.marbl.mhap.utils.PackageInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class ParseOptions {
    private final ArrayList<String> startText = new ArrayList();
    private final HashMap<String, Option<?>> optionsByFlag = new HashMap();
    private final HashMap<String, Option<?>> optionsByName = new HashMap();

    public ParseOptions() {
        this.addOption("-h", "Displays the help menu.", false);
        this.addOption("--help", "Displays the help menu.", false);
        this.addOption("--version", "Displays the version and build time.", false);
    }

    public void addStartTextLine(String string) {
        this.startText.add(string);
    }

    public <T> void addOption(String string, String string2, T t) {
        if (this.optionsByFlag.get(string = this.parseFlag(string)) != null) {
            return;
        }
        Option option = new Option(string, string2, t);
        this.optionsByFlag.put(string, option);
        this.optionsByName.put(string, option);
    }

    public <T> void setOptions(String string, T t) {
        Option option = new Option(string, ((Option)this.getFlag(string)).description, t);
        this.optionsByFlag.put(string, option);
        this.optionsByName.put(string, option);
    }

    public <T> void addRequiredOption(String string, String string2, Class<T> clazz) {
        string = this.parseFlag(string);
        Option option = new Option(string, string2, true, clazz);
        this.optionsByFlag.put(string, option);
        this.optionsByName.put(string, option);
    }

    public String parseFlag(String string) {
        return string;
    }

    public boolean process(String[] stringArray) {
        try {
            this.parse(stringArray);
            if (this.needsHelp()) {
                System.out.println(this.helpMenuString());
                return false;
            }
            if (this.needsVersion()) {
                System.out.println("MHAP Version = " + PackageInfo.VERSION + ", Build time = " + PackageInfo.BUILD_TIME);
                return false;
            }
            this.checkParameters();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.out.println(this.helpMenuString());
            return false;
        }
        return true;
    }

    public Option<?> get(String string) throws RuntimeException {
        Option<?> option = this.optionsByName.get(string);
        if (option == null) {
            throw new RuntimeException("Invalid option name \"" + string + "\".");
        }
        return option;
    }

    public Option<?> getFlag(String string) throws RuntimeException {
        Option<?> option = this.optionsByFlag.get(string);
        if (option == null) {
            throw new RuntimeException("Invalid flag \"" + string + "\".");
        }
        return option;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>(this.optionsByFlag.keySet());
        Collections.sort(arrayList);
        for (String string : arrayList) {
            Option<?> option = this.optionsByFlag.get(string);
            stringBuilder.append("" + ((Option)option).flag + " = ");
            stringBuilder.append("" + ((Option)option).value);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public String helpMenuString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String object2 : this.startText) {
            stringBuilder.append(object2 + "\n");
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.optionsByFlag.keySet());
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Option<?> option = this.optionsByFlag.get(string);
            stringBuilder.append("\t\t" + ((Option)option).flag + ", ");
            if (option.isRequired()) {
                stringBuilder.append("*required, ");
            } else if (option.isString()) {
                stringBuilder.append("default = \"" + ((Option)option).value + "\"");
            } else {
                stringBuilder.append("default = " + ((Option)option).value);
            }
            stringBuilder.append("\n");
            stringBuilder.append("\t\t\t" + ((Option)option).description);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public void checkParameters() {
        for (Option<?> option : this.optionsByFlag.values()) {
            if (!((Option)option).required || ((Option)option).wasSet) continue;
            throw new RuntimeException("Required option flag \"" + ((Option)option).flag + "\" was not set.");
        }
    }

    public boolean needsHelp() {
        return this.get("--help").getBoolean() || this.get("-h").getBoolean();
    }

    public boolean needsVersion() {
        return this.get("--version").getBoolean();
    }

    public void parse(String[] stringArray) throws RuntimeException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].trim();
            if (!string.startsWith("-")) {
                throw new RuntimeException("Unknown parameter in command line: " + string);
            }
            Option<?> option = this.getFlag(string = this.parseFlag(string));
            if (option == null) {
                throw new RuntimeException("Unknown flag \"" + string + "\".");
            }
            if (option.isBoolean()) {
                option.setValue(true);
                continue;
            }
            if (i + 1 < stringArray.length && !stringArray[i + 1].startsWith("-")) {
                if (option.isDouble()) {
                    option.setValue(new Double(stringArray[i + 1]));
                    ++i;
                    continue;
                }
                if (option.isInteger()) {
                    option.setValue(new Integer(stringArray[i + 1]));
                    ++i;
                    continue;
                }
                if (option.isString()) {
                    option.setValue(stringArray[i + 1]);
                    ++i;
                    continue;
                }
                throw new RuntimeException("Cannot parse flag \"" + option.getFlag() + "\" of type " + option.getType().getName() + ".");
            }
            throw new RuntimeException("Not value provided for flag \"" + option.getFlag() + "\" of type " + option.getType().getName() + ".");
        }
    }

    public class Option<T> {
        protected final Class<T> objectClass;
        private final String description;
        private final String flag;
        private Object value;
        private boolean wasSet;
        private boolean required;

        private Option(String string, String string2, T t) {
            this.flag = string;
            this.description = string2;
            this.value = t;
            this.wasSet = false;
            this.required = false;
            this.objectClass = t.getClass();
        }

        private Option(String string, String string2, boolean bl, Class<T> clazz) {
            this.flag = this.parseFlag(string);
            this.description = string2;
            this.value = null;
            this.wasSet = false;
            this.required = bl;
            this.objectClass = clazz;
        }

        private String parseFlag(String string) {
            if ((string = string.trim()).startsWith("-")) {
                string = string.substring(1);
            }
            return string;
        }

        public boolean isBoolean() {
            return Boolean.class.isAssignableFrom(this.objectClass);
        }

        public boolean isDouble() {
            return Double.class.isAssignableFrom(this.objectClass);
        }

        public boolean isInteger() {
            return Integer.class.isAssignableFrom(this.objectClass);
        }

        public boolean isString() {
            return String.class.isAssignableFrom(this.objectClass);
        }

        public boolean getBoolean() {
            return (Boolean)this.value;
        }

        public String getString() {
            if (this.value == null) {
                return "";
            }
            return (String)this.value;
        }

        public double getDouble() {
            return (Double)this.value;
        }

        public int getInteger() {
            return (Integer)this.value;
        }

        public void setValue(Object object) {
            if (!this.objectClass.isInstance(object)) {
                throw new RuntimeException("Incompatable value type for flag \"" + this.flag + "\" of type " + this.objectClass.getName() + ": " + object.getClass().getName());
            }
            this.value = object;
            this.wasSet = true;
        }

        public String getFlag() {
            return this.flag;
        }

        public boolean isSet() {
            return this.wasSet;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Class<T> getType() {
            return this.objectClass;
        }
    }
}

