/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.utils;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;

public final class LimitedSizeCollection<T extends Comparable<T>>
implements Collection<T> {
    private T best;
    private int maxSize;
    private final PriorityQueue<T> queue;

    public LimitedSizeCollection(int n) {
        this(n, Priority.MIN_VALUES);
    }

    public LimitedSizeCollection(int n, Priority priority) {
        this.queue = priority == Priority.MIN_VALUES ? new PriorityQueue(n, new Comparator<T>(){

            @Override
            public final int compare(T t, T t2) {
                return t2.compareTo(t);
            }
        }) : new PriorityQueue(n, new Comparator<T>(){

            @Override
            public final int compare(T t, T t2) {
                return t.compareTo(t2);
            }
        });
        this.maxSize = n;
        this.best = null;
    }

    @Override
    public boolean add(T t) {
        if (t == null) {
            return false;
        }
        if (this.maxSize <= 0) {
            return false;
        }
        if (this.queue.size() < this.maxSize) {
            this.queue.add(t);
        } else if (this.queue.comparator().compare(t, this.queue.peek()) > 0) {
            this.queue.add(t);
            this.queue.poll();
        } else {
            return false;
        }
        if (this.best == null || this.queue.comparator().compare(t, this.best) > 0) {
            this.best = t;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        for (Comparable comparable : collection) {
            this.add((T)comparable);
        }
        return true;
    }

    @Override
    public void clear() {
        this.best = null;
        this.queue.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.queue.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.queue.containsAll(collection);
    }

    public T getBest() {
        return this.best;
    }

    public Collection<T> getCollection() {
        return this.queue;
    }

    public T getWorst() {
        return (T)((Comparable)this.queue.peek());
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public boolean isFull() {
        return this.queue.size() >= this.maxSize;
    }

    @Override
    public Iterator<T> iterator() {
        return this.queue.iterator();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.best = null;
        return this.queue.removeAll(collection);
    }

    public T removeWorst() {
        return (T)((Comparable)this.queue.poll());
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    public void setSize(int n) {
        this.maxSize = n;
        while (this.queue.size() > this.maxSize) {
            this.queue.poll();
        }
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public <Y> Y[] toArray(Y[] YArray) {
        return this.queue.toArray(YArray);
    }

    public static enum Priority {
        MAX_VALUES,
        MIN_VALUES;

    }
}

