/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.utils;

import edu.umd.marbl.mhap.utils.Interval;
import edu.umd.marbl.mhap.utils.IntervalNode;
import java.util.ArrayList;
import java.util.List;

public class IntervalTree<Type> {
    private IntervalNode<Type> head;
    private List<Interval<Type>> intervalList;
    private boolean inSync;
    private int size;

    public IntervalTree() {
        this.head = new IntervalNode();
        this.intervalList = new ArrayList<Interval<Type>>();
        this.inSync = true;
        this.size = 0;
    }

    public IntervalTree(List<Interval<Type>> list) {
        this.head = new IntervalNode<Type>(list);
        this.intervalList = new ArrayList<Interval<Type>>();
        this.intervalList.addAll(list);
        this.inSync = true;
        this.size = list.size();
    }

    public List<Type> get(long l) {
        List<Interval<Type>> list = this.getIntervals(l);
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (Interval<Type> interval : list) {
            arrayList.add(interval.getData());
        }
        return arrayList;
    }

    public List<Interval<Type>> getIntervals(long l) {
        this.build();
        return this.head.stab(l);
    }

    public List<Type> get(long l, long l2) {
        List<Interval<Type>> list = this.getIntervals(l, l2);
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (Interval<Type> interval : list) {
            arrayList.add(interval.getData());
        }
        return arrayList;
    }

    public List<Interval<Type>> getIntervals(long l, long l2) {
        this.build();
        return this.head.query(new Interval<Object>(l, l2, null));
    }

    public void addInterval(Interval<Type> interval) {
        this.intervalList.add(interval);
        this.inSync = false;
    }

    public void addInterval(long l, long l2, Type Type2) {
        this.intervalList.add(new Interval<Type>(l, l2, Type2));
        this.inSync = false;
    }

    public boolean inSync() {
        return this.inSync;
    }

    public void build() {
        if (!this.inSync) {
            this.head = new IntervalNode<Type>(this.intervalList);
            this.inSync = true;
            this.size = this.intervalList.size();
        }
    }

    public int currentSize() {
        return this.size;
    }

    public int listSize() {
        return this.intervalList.size();
    }

    public String toString() {
        return this.nodeString(this.head, 0);
    }

    private String nodeString(IntervalNode<Type> intervalNode, int n) {
        if (intervalNode == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\t");
        }
        stringBuffer.append(intervalNode + "\n");
        stringBuffer.append(this.nodeString(intervalNode.getLeft(), n + 1));
        stringBuffer.append(this.nodeString(intervalNode.getRight(), n + 1));
        return stringBuffer.toString();
    }
}

