/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.utils;

import edu.umd.marbl.mhap.utils.Interval;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class IntervalNode<Type> {
    private SortedMap<Interval<Type>, List<Interval<Type>>> intervals = new TreeMap<Interval<Type>, List<Interval<Type>>>();
    private long center;
    private IntervalNode<Type> leftNode;
    private IntervalNode<Type> rightNode;

    public IntervalNode() {
        this.center = 0L;
        this.leftNode = null;
        this.rightNode = null;
    }

    public IntervalNode(List<Interval<Type>> list) {
        long l;
        TreeSet<Long> treeSet = new TreeSet<Long>();
        for (Interval<Type> interval : list) {
            treeSet.add(interval.getStart());
            treeSet.add(interval.getEnd());
        }
        this.center = l = this.getMedian(treeSet).longValue();
        ArrayList<Interval<Type>> arrayList = new ArrayList<Interval<Type>>();
        ArrayList<Interval<Type>> arrayList2 = new ArrayList<Interval<Type>>();
        for (Interval<Type> interval : list) {
            if (interval.getEnd() < l) {
                arrayList.add(interval);
                continue;
            }
            if (interval.getStart() > l) {
                arrayList2.add(interval);
                continue;
            }
            ArrayList<Interval<Type>> arrayList3 = (ArrayList<Interval<Type>>)this.intervals.get(interval);
            if (arrayList3 == null) {
                arrayList3 = new ArrayList<Interval<Type>>();
                this.intervals.put(interval, arrayList3);
            }
            arrayList3.add(interval);
        }
        if (arrayList.size() > 0) {
            this.leftNode = new IntervalNode<Type>(arrayList);
        }
        if (arrayList2.size() > 0) {
            this.rightNode = new IntervalNode<Type>(arrayList2);
        }
    }

    public List<Interval<Type>> stab(long l) {
        ArrayList<Interval<Type>> arrayList = new ArrayList<Interval<Type>>();
        for (Map.Entry<Interval<Type>, List<Interval<Type>>> entry : this.intervals.entrySet()) {
            if (entry.getKey().contains(l)) {
                for (Interval<Type> interval : entry.getValue()) {
                    arrayList.add(interval);
                }
                continue;
            }
            if (entry.getKey().getStart() <= l) continue;
            break;
        }
        if (l < this.center && this.leftNode != null) {
            arrayList.addAll(this.leftNode.stab(l));
        } else if (l > this.center && this.rightNode != null) {
            arrayList.addAll(this.rightNode.stab(l));
        }
        return arrayList;
    }

    public List<Interval<Type>> query(Interval<?> interval) {
        ArrayList<Interval<Type>> arrayList = new ArrayList<Interval<Type>>();
        for (Map.Entry<Interval<Type>, List<Interval<Type>>> entry : this.intervals.entrySet()) {
            if (entry.getKey().intersects(interval)) {
                for (Interval<Type> interval2 : entry.getValue()) {
                    arrayList.add(interval2);
                }
                continue;
            }
            if (entry.getKey().getStart() <= interval.getEnd()) continue;
            break;
        }
        if (interval.getStart() < this.center && this.leftNode != null) {
            arrayList.addAll(this.leftNode.query(interval));
        }
        if (interval.getEnd() > this.center && this.rightNode != null) {
            arrayList.addAll(this.rightNode.query(interval));
        }
        return arrayList;
    }

    public long getCenter() {
        return this.center;
    }

    public void setCenter(long l) {
        this.center = l;
    }

    public IntervalNode<Type> getLeft() {
        return this.leftNode;
    }

    public void setLeft(IntervalNode<Type> intervalNode) {
        this.leftNode = intervalNode;
    }

    public IntervalNode<Type> getRight() {
        return this.rightNode;
    }

    public void setRight(IntervalNode<Type> intervalNode) {
        this.rightNode = intervalNode;
    }

    private Long getMedian(SortedSet<Long> sortedSet) {
        int n = 0;
        int n2 = sortedSet.size() / 2;
        for (Long l : sortedSet) {
            if (n == n2) {
                return l;
            }
            ++n;
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.center + ": ");
        for (Map.Entry<Interval<Type>, List<Interval<Type>>> entry : this.intervals.entrySet()) {
            stringBuffer.append("[" + entry.getKey().getStart() + "," + entry.getKey().getEnd() + "]:{");
            for (Interval<Type> interval : entry.getValue()) {
                stringBuffer.append("(" + interval.getStart() + "," + interval.getEnd() + "," + interval.getData() + ")");
            }
            stringBuffer.append("} ");
        }
        return stringBuffer.toString();
    }
}

