/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.utils;

import java.lang.reflect.Array;

public final class HashCodeUtil {
    private static final int fODD_PRIME_NUMBER = 37;
    public static final int SEED = 23;

    private static int firstTerm(int n) {
        return 37 * n;
    }

    public static int hash(int n, boolean bl) {
        return HashCodeUtil.firstTerm(n) + (bl ? 1 : 0);
    }

    public static int hash(int n, char c) {
        return HashCodeUtil.firstTerm(n) + c;
    }

    public static final int hash(int n, char[] cArray, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            n4 += HashCodeUtil.firstTerm(n) + cArray[n2 + i];
        }
        return n4;
    }

    public static int hash(int n, double d) {
        return HashCodeUtil.hash(n, Double.doubleToLongBits(d));
    }

    public static int hash(int n, float f) {
        return HashCodeUtil.hash(n, Float.floatToIntBits(f));
    }

    public static int hash(int n, int n2) {
        return HashCodeUtil.firstTerm(n) + n2;
    }

    public static int hash(int n, long l) {
        return HashCodeUtil.firstTerm(n) + (int)(l ^ l >>> 32);
    }

    public static int hash(int n, Object object) {
        int n2 = n;
        if (object == null) {
            n2 = HashCodeUtil.hash(n2, 0);
        } else if (!HashCodeUtil.isArray(object)) {
            n2 = HashCodeUtil.hash(n2, object.hashCode());
        } else {
            int n3 = Array.getLength(object);
            for (int i = 0; i < n3; ++i) {
                Object object2 = Array.get(object, i);
                n2 = HashCodeUtil.hash(n2, object2);
            }
        }
        return n2;
    }

    private static boolean isArray(Object object) {
        return object.getClass().isArray();
    }
}

