/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.sketch;

import edu.umd.marbl.mhap.general.FastaData;
import edu.umd.marbl.mhap.general.Sequence;
import edu.umd.marbl.mhap.sketch.KmerCounts;
import edu.umd.marbl.mhap.sketch.SequenceSketch;
import edu.umd.marbl.mhap.utils.MhapRuntimeException;
import edu.umd.marbl.mhap.utils.ReadBuffer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class SequenceSketchStreamer {
    private final DataInputStream buffInput;
    private final FastaData fastaData;
    private final HashSet<Long> filter;
    private final KmerCounts kmerCounter;
    private final int kmerSize;
    private final AtomicLong numberProcessed;
    private final AtomicLong numberSubSequencesProcessed;
    private final int numHashes;
    private final int offset;
    private final boolean weighted;
    private final int orderedKmerSize;
    private boolean readClosed;
    private final boolean readingFasta;
    private final ConcurrentLinkedQueue<SequenceSketch> sequenceHashList;

    public SequenceSketchStreamer(String string, int n) throws FileNotFoundException {
        this.fastaData = null;
        this.readingFasta = false;
        this.sequenceHashList = new ConcurrentLinkedQueue();
        this.numberProcessed = new AtomicLong();
        this.kmerCounter = null;
        this.weighted = true;
        this.kmerSize = 0;
        this.numHashes = 0;
        this.orderedKmerSize = 0;
        this.filter = null;
        this.numberSubSequencesProcessed = new AtomicLong();
        this.readClosed = false;
        this.offset = n;
        this.buffInput = new DataInputStream(new BufferedInputStream(new FileInputStream(string), 0x800000));
    }

    public SequenceSketchStreamer(String string, int n, int n2, int n3, int n4, HashSet<Long> hashSet, KmerCounts kmerCounts, boolean bl, int n5) throws IOException {
        this.fastaData = new FastaData(string, n5);
        this.readingFasta = true;
        this.sequenceHashList = new ConcurrentLinkedQueue();
        this.numberProcessed = new AtomicLong();
        this.weighted = bl;
        this.kmerCounter = kmerCounts;
        this.kmerSize = n;
        this.numHashes = n2;
        this.orderedKmerSize = n4;
        this.filter = hashSet;
        this.numberSubSequencesProcessed = new AtomicLong();
        this.buffInput = null;
        this.readClosed = false;
        this.offset = n5;
    }

    public SequenceSketch dequeue(boolean bl, ReadBuffer readBuffer) throws IOException {
        this.enqueue(bl, readBuffer);
        return this.sequenceHashList.poll();
    }

    private boolean enqueue(boolean bl, ReadBuffer readBuffer) throws IOException {
        if (this.readingFasta) {
            Sequence sequence = this.fastaData.dequeue();
            SequenceSketch sequenceSketch = null;
            if (sequence != null) {
                sequenceSketch = this.getSketch(sequence);
            }
            if (sequenceSketch == null) {
                return false;
            }
            this.processAddition(sequenceSketch);
            this.sequenceHashList.add(sequenceSketch);
            if (!bl) {
                sequenceSketch = this.getSketch(sequence.getReverseCompliment());
                this.sequenceHashList.add(sequenceSketch);
                this.processAddition(sequenceSketch);
            }
        } else {
            SequenceSketch sequenceSketch = this.readFromBinary(readBuffer, bl);
            while (sequenceSketch != null && bl && !sequenceSketch.getSequenceId().isForward()) {
                sequenceSketch = this.readFromBinary(readBuffer, bl);
            }
            if (sequenceSketch == null) {
                return false;
            }
            this.processAddition(sequenceSketch);
            this.sequenceHashList.add(sequenceSketch);
        }
        return true;
    }

    public synchronized void enqueueFullFile(final boolean bl, int n) throws IOException {
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        for (int i = 0; i < n; ++i) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ReadBuffer readBuffer = new ReadBuffer();
                    try {
                        while (SequenceSketchStreamer.this.enqueue(bl, readBuffer)) {
                        }
                    }
                    catch (IOException iOException) {
                        throw new MhapRuntimeException(iOException);
                    }
                }
            };
            executorService.execute(runnable);
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(365L, TimeUnit.DAYS);
        }
        catch (InterruptedException interruptedException) {
            executorService.shutdownNow();
            throw new MhapRuntimeException("Unable to finish all tasks.");
        }
    }

    public Iterator<SequenceSketch> getDataIterator() {
        return this.sequenceHashList.iterator();
    }

    public int getFastaProcessed() {
        if (this.fastaData == null) {
            return 0;
        }
        return this.fastaData.getNumberProcessed();
    }

    public SequenceSketch getSketch(Sequence sequence) {
        return new SequenceSketch(sequence, this.kmerSize, this.numHashes, this.orderedKmerSize, false, this.filter, this.kmerCounter, this.weighted);
    }

    public int getNumberProcessed() {
        return this.numberProcessed.intValue();
    }

    public int getNumberSubSequencesProcessed() {
        return this.numberSubSequencesProcessed.intValue();
    }

    protected void processAddition(SequenceSketch sequenceSketch) {
        this.numberProcessed.getAndIncrement();
        int n = this.getNumberProcessed();
        if (n % 5000 == 0) {
            System.err.println("Current # sequences loaded and processed from file: " + n + "...");
        }
        if (sequenceSketch != null) {
            this.numberSubSequencesProcessed.getAndAdd(1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SequenceSketch readFromBinary(ReadBuffer readBuffer, boolean bl) throws IOException {
        byte[] byArray = null;
        Object object = this.buffInput;
        synchronized (object) {
            if (this.readClosed) {
                return null;
            }
            try {
                boolean bl2 = true;
                while (bl2) {
                    byte by = this.buffInput.readByte();
                    if (!bl || by == 1) {
                        bl2 = false;
                    }
                    int n = this.buffInput.readInt();
                    byArray = readBuffer.getBuffer(n);
                    this.buffInput.read(byArray, 0, n);
                }
            }
            catch (EOFException eOFException) {
                this.buffInput.close();
                this.readClosed = true;
                return null;
            }
        }
        object = SequenceSketch.fromByteStream(new DataInputStream(new ByteArrayInputStream(byArray)), this.offset);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToBinary(String string, final boolean bl, int n) throws IOException {
        try (OutputStream outputStream = null;){
            final OutputStream outputStream2 = outputStream = new BufferedOutputStream(new FileOutputStream(string), 0x800000);
            ExecutorService executorService = Executors.newFixedThreadPool(n);
            for (int i = 0; i < n; ++i) {
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ReadBuffer readBuffer = new ReadBuffer();
                        try {
                            SequenceSketch sequenceSketch = SequenceSketchStreamer.this.dequeue(bl, readBuffer);
                            while (sequenceSketch != null) {
                                byte[] byArray = sequenceSketch.getAsByteArray();
                                int n = byArray.length;
                                byte by = sequenceSketch.getSequenceId().isForward() ? (byte)1 : 0;
                                byte[] byArray2 = ByteBuffer.allocate(5).put(by).putInt(n).array();
                                OutputStream outputStream = outputStream2;
                                synchronized (outputStream) {
                                    outputStream2.write(byArray2);
                                    outputStream2.write(byArray);
                                }
                                sequenceSketch = SequenceSketchStreamer.this.dequeue(bl, readBuffer);
                            }
                        }
                        catch (IOException iOException) {
                            throw new MhapRuntimeException(iOException);
                        }
                    }
                };
                executorService.execute(runnable);
            }
            executorService.shutdown();
            try {
                executorService.awaitTermination(365L, TimeUnit.DAYS);
            }
            catch (InterruptedException interruptedException) {
                executorService.shutdownNow();
                throw new MhapRuntimeException("Unable to finish all tasks.");
            }
            outputStream2.flush();
        }
    }
}

