/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.sketch;

import edu.umd.marbl.mhap.general.Sequence;
import edu.umd.marbl.mhap.general.SequenceId;
import edu.umd.marbl.mhap.sketch.KmerCounts;
import edu.umd.marbl.mhap.sketch.MinHash;
import edu.umd.marbl.mhap.sketch.OrderKmerHashes;
import edu.umd.marbl.mhap.utils.MhapRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;

public final class SequenceSketch
implements Serializable {
    private static final long serialVersionUID = -3155689614837922443L;
    private final SequenceId id;
    private final MinHash mainHashes;
    private final OrderKmerHashes orderedHashes;
    public static final double SHIFT_CONSENSUS_PERCENTAGE = 0.75;

    public static SequenceSketch fromByteStream(DataInputStream dataInputStream, int n) throws IOException {
        try {
            boolean bl = dataInputStream.readBoolean();
            SequenceId sequenceId = new SequenceId(dataInputStream.readInt() + n, bl);
            MinHash minHash = MinHash.fromByteStream(dataInputStream);
            if (minHash == null) {
                throw new MhapRuntimeException("Unexpected data read error.");
            }
            OrderKmerHashes orderKmerHashes = OrderKmerHashes.fromByteStream(dataInputStream);
            if (orderKmerHashes == null) {
                throw new MhapRuntimeException("Unexpected data read error.");
            }
            return new SequenceSketch(sequenceId, minHash, orderKmerHashes);
        }
        catch (EOFException eOFException) {
            return null;
        }
    }

    public SequenceSketch(SequenceId sequenceId, MinHash minHash, OrderKmerHashes orderKmerHashes) {
        this.id = sequenceId;
        this.mainHashes = minHash;
        this.orderedHashes = orderKmerHashes;
    }

    public SequenceSketch(Sequence sequence, int n, int n2, int n3, boolean bl, HashSet<Long> hashSet, KmerCounts kmerCounts, boolean bl2) {
        this.id = sequence.getId();
        this.mainHashes = new MinHash(sequence, n, n2, hashSet, kmerCounts, bl2);
        this.orderedHashes = new OrderKmerHashes(sequence, n3);
    }

    public SequenceSketch createOffset(int n) {
        return new SequenceSketch(this.id.createOffset(n), this.mainHashes, this.orderedHashes);
    }

    public byte[] getAsByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.mainHashes.numHashes() * 4 + this.orderedHashes.size() * 2);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeBoolean(this.id.isForward());
            dataOutputStream.writeInt(this.id.getHeaderId());
            dataOutputStream.write(this.mainHashes.getAsByteArray());
            dataOutputStream.write(this.orderedHashes.getAsByteArray());
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new MhapRuntimeException("Unexpected IO error.");
        }
    }

    public MinHash getMinHashes() {
        return this.mainHashes;
    }

    public OrderKmerHashes getOrderedHashes() {
        return this.orderedHashes;
    }

    public SequenceId getSequenceId() {
        return this.id;
    }

    public int getSequenceLength() {
        return this.mainHashes.getSequenceLength();
    }
}

