/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.sketch;

import edu.umd.marbl.mhap.general.OverlapInfo;
import edu.umd.marbl.mhap.general.Sequence;
import edu.umd.marbl.mhap.utils.MhapRuntimeException;
import edu.umd.marbl.mhap.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;

public class OrderKmerHashes {
    private final int[][][] orderedHashes;
    private final int seqLength;
    public static final int MAX_ARRAY_SIZE = 1000;
    public static final int REDUCTION = 4;

    private static final int[][][] allocateMemory(int n) {
        int n2 = n / 1000 + 1;
        if (n % 1000 == 0) {
            --n2;
        }
        int[][][] nArrayArray = new int[n2][][];
        int n3 = 0;
        for (int i = 0; i < n; i += 1000) {
            nArrayArray[n3] = new int[Math.min(1000, n - i)][2];
            ++n3;
        }
        return nArrayArray;
    }

    public static final OrderKmerHashes fromByteStream(DataInputStream dataInputStream) throws IOException {
        try {
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            int[][][] nArray = OrderKmerHashes.allocateMemory(n2);
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                if (nArray[n3].length <= n4) {
                    ++n3;
                    n4 = 0;
                }
                nArray[n3][n4][0] = dataInputStream.readInt();
                nArray[n3][n4][1] = dataInputStream.readInt();
                ++n4;
            }
            return new OrderKmerHashes(n, nArray);
        }
        catch (EOFException eOFException) {
            return null;
        }
    }

    private OrderKmerHashes(int n, int[][][] nArray) {
        this.seqLength = n;
        this.orderedHashes = nArray;
    }

    public OrderKmerHashes(Sequence sequence, int n) {
        this.seqLength = sequence.length() - n + 1;
        this.orderedHashes = this.getFullHashes(sequence, n);
    }

    public byte[] getAsByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.size() * 2);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.seqLength);
            dataOutputStream.writeInt(this.size());
            for (int i = 0; i < this.orderedHashes.length; ++i) {
                for (int j = 0; j < this.orderedHashes[i].length; ++j) {
                    dataOutputStream.writeInt(this.orderedHashes[i][j][0]);
                    dataOutputStream.writeInt(this.orderedHashes[i][j][1]);
                }
            }
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new MhapRuntimeException("Unexpected IO error.");
        }
    }

    public int getHash(int n) {
        int n2 = n / this.orderedHashes[0].length;
        int n3 = n % this.orderedHashes[0].length;
        return this.orderedHashes[n2][n3][0];
    }

    private int[][][] storeAsArray(SortableIntPair[] sortableIntPairArray) {
        int[][][] nArray = OrderKmerHashes.allocateMemory(sortableIntPairArray.length);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < sortableIntPairArray.length; ++i) {
            if (nArray[n].length <= n2) {
                ++n;
                n2 = 0;
            }
            nArray[n][n2][0] = sortableIntPairArray[i].x;
            nArray[n][n2][1] = sortableIntPairArray[i].y;
            ++n2;
        }
        return nArray;
    }

    private int[][][] getFullHashes(Sequence sequence, int n) {
        int n2 = -1073741825;
        int[] nArray = Utils.computeSequenceHashes(sequence.getString(), n);
        int n3 = 0;
        int[] objectArray = nArray;
        int n4 = objectArray.length;
        for (int i = 0; i < n4; ++i) {
            int n5 = objectArray[i];
            if (n5 > n2) continue;
            ++n3;
        }
        Object[] objectArray2 = new SortableIntPair[n3];
        n3 = 0;
        for (n4 = 0; n4 < nArray.length; ++n4) {
            if (nArray[n4] > n2) continue;
            objectArray2[n3] = new SortableIntPair(nArray[n4], n4);
            ++n3;
        }
        Arrays.sort(objectArray2);
        return this.storeAsArray((SortableIntPair[])objectArray2);
    }

    public OverlapInfo getFullScore(OrderKmerHashes orderKmerHashes, double d) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int[][][] nArray = this.orderedHashes;
        int[][][] nArray2 = orderKmerHashes.orderedHashes;
        int n12 = this.size();
        int n13 = orderKmerHashes.size();
        int n14 = this.seqLength;
        int n15 = orderKmerHashes.seqLength;
        int n16 = 0;
        int n17 = n14;
        int n18 = 0;
        int n19 = n15;
        int n20 = 0;
        int n21 = Math.min(n14, n15);
        int n22 = Math.max(n14, n15);
        int n23 = 0;
        int[] nArray3 = new int[Math.min(n12, n13) / 8 + 1];
        int[] nArray4 = new int[nArray3.length];
        int[] nArray5 = new int[nArray3.length];
        int n24 = 2;
        if (d <= 0.0) {
            n24 = 1;
            d = Math.abs(d);
        }
        for (n11 = 0; n11 < n24; ++n11) {
            n23 = 0;
            n10 = 0;
            n9 = 0;
            n8 = 0;
            n7 = 0;
            n6 = 0;
            n5 = 0;
            while (true) {
                if (n8 >= nArray[n10].length) {
                    n8 = 0;
                    if (++n10 >= nArray.length) break;
                }
                if (n7 >= nArray2[n9].length) {
                    n7 = 0;
                    if (++n9 >= nArray2.length) break;
                }
                n6 = nArray[n10][n8][0];
                n4 = nArray[n10][n8][1];
                n5 = nArray2[n9][n7][0];
                n3 = nArray2[n9][n7][1];
                if (n6 < n5 || n4 < n16 || n4 >= n17) {
                    ++n8;
                    continue;
                }
                if (n5 < n6 || n3 < n18 || n3 >= n19) {
                    ++n7;
                    continue;
                }
                n2 = n3 - n4;
                if (Math.abs(n2 - n20) > n22) {
                    ++n7;
                    continue;
                }
                if (nArray3.length <= n23) {
                    nArray3 = Arrays.copyOf(nArray3, nArray3.length * 2);
                    nArray4 = Arrays.copyOf(nArray4, nArray4.length * 2);
                    nArray5 = Arrays.copyOf(nArray5, nArray5.length * 2);
                }
                nArray3[n23] = n2;
                nArray4[n23] = n4;
                nArray5[n23] = n3;
                if (n11 == 0) {
                    ++n8;
                }
                ++n7;
                ++n23;
            }
            if (n23 <= 0) {
                return new OverlapInfo(0.0, 0, 0, 0, 0, 0);
            }
            if (n11 > 0) {
                n2 = -1;
                for (n = 0; n < n23; ++n) {
                    if (n2 >= 0 && nArray4[n2] == nArray4[n]) {
                        if (Math.abs(nArray3[n2] - n20) <= Math.abs(nArray3[n] - n20)) continue;
                        nArray4[n2] = nArray4[n];
                        nArray5[n2] = nArray5[n];
                        nArray3[n2] = nArray3[n];
                        continue;
                    }
                    nArray4[++n2] = nArray4[n];
                    nArray5[n2] = nArray5[n];
                    nArray3[n2] = nArray3[n];
                }
                n23 = n2 + 1;
            }
            n20 = n23 <= 0 ? 0 : Utils.quickSelect(Arrays.copyOf(nArray3, n23), n23 / 2, n23);
            n2 = Math.max(0, -n20);
            n = Math.min(n14, n15 - n20);
            n21 = Math.max(this.seqLength - n14, n - n2);
            n22 = Math.min(Math.max(n14, n15), (int)((double)n21 * d));
            n16 = Math.max(0, -n20 - n22);
            n17 = Math.min(n14, n15 - n20 + n22);
            n18 = Math.max(0, n20 - n22);
            n19 = Math.min(n15, n14 + n20 + n22);
        }
        n11 = Integer.MAX_VALUE;
        n10 = Integer.MAX_VALUE;
        n9 = Integer.MIN_VALUE;
        n8 = Integer.MIN_VALUE;
        n7 = 0;
        for (n6 = 0; n6 < n23; ++n6) {
            n5 = nArray4[n6];
            n4 = nArray5[n6];
            if (Math.abs(nArray3[n6] - n20) > n22) continue;
            if (n5 < n11) {
                n11 = n5;
            }
            if (n4 < n10) {
                n10 = n4;
            }
            if (n5 > n9) {
                n9 = n5;
            }
            if (n4 > n8) {
                n8 = n4;
            }
            ++n7;
        }
        if (n7 <= 1) {
            return new OverlapInfo(0.0, 0, 0, 0, 0, 0);
        }
        double d2 = (double)n7 / (double)n21;
        n4 = Math.max(0, (int)Math.round((double)(n7 * n11 - n9) / (double)(n7 - 1)));
        n3 = Math.max(0, (int)Math.round((double)(n7 * n10 - n8) / (double)(n7 - 1)));
        n2 = Math.min(this.seqLength, (int)Math.round((double)(n7 * n9 - n11) / (double)(n7 - 1)));
        n = Math.min(orderKmerHashes.seqLength, (int)Math.round((double)(n7 * n8 - n10) / (double)(n7 - 1)));
        return new OverlapInfo(d2 * 4.0, n7, n4, n3, n2, n);
    }

    public int size() {
        return (this.orderedHashes.length - 1) * this.orderedHashes[0].length + this.orderedHashes[this.orderedHashes.length - 1].length;
    }

    private static final class SortableIntPair
    implements Comparable<SortableIntPair>,
    Serializable {
        public final int x;
        public final int y;
        private static final long serialVersionUID = 2525278831423582446L;

        public SortableIntPair(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        @Override
        public int compareTo(SortableIntPair sortableIntPair) {
            return Integer.compare(this.x, sortableIntPair.x);
        }
    }
}

