/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.sketch;

import edu.umd.marbl.mhap.general.AbstractMatchSearch;
import edu.umd.marbl.mhap.general.MatchResult;
import edu.umd.marbl.mhap.general.OverlapInfo;
import edu.umd.marbl.mhap.general.SequenceId;
import edu.umd.marbl.mhap.sketch.MinHash;
import edu.umd.marbl.mhap.sketch.SequenceSketch;
import edu.umd.marbl.mhap.sketch.SequenceSketchStreamer;
import edu.umd.marbl.mhap.utils.HitCounter;
import edu.umd.marbl.mhap.utils.MhapRuntimeException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class MinHashSearch
extends AbstractMatchSearch {
    private final double acceptScore;
    private final ArrayList<Map<Integer, ArrayList<SequenceId>>> hashes;
    private final double maxShift;
    private final AtomicLong minhashSearchTime;
    private final AtomicLong sortMergeSearchTime;
    private final int minStoreLength;
    private final AtomicLong numberElementsProcessed;
    private final AtomicLong numberSequencesFullyCompared;
    private final AtomicLong numberSequencesHit;
    private final AtomicLong numberSequencesMinHashed;
    private final AtomicLong numberSubSequences;
    private final AtomicLong numberSubSequencesHit;
    private final int numMinMatches;
    private final HashMap<SequenceId, SequenceSketch> sequenceVectorsHash;

    public MinHashSearch(SequenceSketchStreamer sequenceSketchStreamer, int n, int n2, int n3, boolean bl, int n4, double d, double d2) throws IOException {
        super(n3, bl);
        this.minStoreLength = n4;
        this.numMinMatches = n2;
        this.maxShift = d;
        this.acceptScore = d2;
        this.numberSubSequencesHit = new AtomicLong();
        this.numberSequencesHit = new AtomicLong();
        this.numberSequencesFullyCompared = new AtomicLong();
        this.numberSubSequences = new AtomicLong();
        this.numberSequencesMinHashed = new AtomicLong();
        this.numberElementsProcessed = new AtomicLong();
        this.minhashSearchTime = new AtomicLong();
        this.sortMergeSearchTime = new AtomicLong();
        sequenceSketchStreamer.enqueueFullFile(false, this.numThreads);
        this.sequenceVectorsHash = new HashMap(sequenceSketchStreamer.getNumberProcessed() + 100, 0.75f);
        this.hashes = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            HashMap hashMap = new HashMap(sequenceSketchStreamer.getNumberSubSequencesProcessed() + 100);
            this.hashes.add(hashMap);
        }
        this.addData(sequenceSketchStreamer);
        System.err.println("Stored " + this.sequenceVectorsHash.size() + " sequences in the index.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addSequence(SequenceSketch sequenceSketch) {
        Serializable serializable;
        int[] nArray = sequenceSketch.getMinHashes().getMinHashArray();
        if (nArray.length != this.hashes.size()) {
            throw new MhapRuntimeException("Number of MinHashes of the sequence does not match current settings.");
        }
        HashMap<SequenceId, SequenceSketch> hashMap = this.sequenceVectorsHash;
        synchronized (hashMap) {
            serializable = this.sequenceVectorsHash.put(sequenceSketch.getSequenceId(), sequenceSketch);
            if (serializable != null) {
                this.sequenceVectorsHash.put(sequenceSketch.getSequenceId(), (SequenceSketch)serializable);
                throw new MhapRuntimeException("Sequence ID already exists in the hash table.");
            }
        }
        int n = 0;
        serializable = sequenceSketch.getSequenceId();
        for (Map<Integer, ArrayList<SequenceId>> map : this.hashes) {
            ArrayList<SequenceId> arrayList;
            int n2 = nArray[n];
            Object object = map;
            synchronized (object) {
                arrayList = map.get(n2);
                if (arrayList == null) {
                    arrayList = new ArrayList(2);
                    map.put(n2, arrayList);
                }
            }
            object = arrayList;
            synchronized (object) {
                arrayList.add((SequenceId)serializable);
            }
            ++n;
        }
        this.numberSubSequences.getAndIncrement();
        this.numberSequencesMinHashed.getAndIncrement();
        return true;
    }

    @Override
    public List<MatchResult> findMatches(SequenceSketch sequenceSketch, boolean bl) {
        Object object;
        ArrayList<SequenceId> arrayList;
        long l = System.nanoTime();
        MinHash minHash = sequenceSketch.getMinHashes();
        if (this.hashes.size() != minHash.numHashes()) {
            throw new MhapRuntimeException("Number of hashes does not match. Stored size " + this.hashes.size() + ", input size " + minHash.numHashes() + ".");
        }
        HashMap<SequenceId, Object> hashMap = new HashMap<SequenceId, Object>(this.numberSequencesMinHashed.intValue() / 5 + 1);
        int[] nArray = minHash.getMinHashArray();
        int n = 0;
        for (Map<Integer, ArrayList<SequenceId>> map : this.hashes) {
            arrayList = map.get(nArray[n]);
            if (arrayList != null) {
                this.numberElementsProcessed.getAndAdd(arrayList.size());
                for (SequenceId object2 : arrayList) {
                    object = (HitCounter)hashMap.get(object2);
                    if (object == null) {
                        object = new HitCounter(1);
                        hashMap.put(object2, object);
                        continue;
                    }
                    ((HitCounter)object).addHit();
                }
            }
            ++n;
        }
        long l2 = System.nanoTime();
        this.minhashSearchTime.getAndAdd(l2 - l);
        this.numberSequencesHit.getAndAdd(hashMap.size());
        this.numberSubSequencesHit.getAndAdd(hashMap.size());
        arrayList = new ArrayList(32);
        for (Map.Entry entry : hashMap.entrySet()) {
            object = (SequenceId)entry.getKey();
            if (bl && ((SequenceId)object).getHeaderId() == sequenceSketch.getSequenceId().getHeaderId() || ((HitCounter)entry.getValue()).count < this.numMinMatches) continue;
            SequenceSketch sequenceSketch2 = this.sequenceVectorsHash.get(entry.getKey());
            if (sequenceSketch2 == null) {
                throw new MhapRuntimeException("Hashes not found for given id.");
            }
            if (sequenceSketch2.getSequenceLength() < this.minStoreLength && sequenceSketch.getSequenceLength() < this.minStoreLength || bl && ((SequenceId)object).getHeaderId() > sequenceSketch.getSequenceId().getHeaderId() && sequenceSketch2.getSequenceLength() >= this.minStoreLength && sequenceSketch.getSequenceLength() >= this.minStoreLength || bl && sequenceSketch2.getSequenceLength() < this.minStoreLength && sequenceSketch.getSequenceLength() >= this.minStoreLength) continue;
            OverlapInfo overlapInfo = sequenceSketch.getOrderedHashes().getFullScore(sequenceSketch2.getOrderedHashes(), this.maxShift);
            this.numberSequencesFullyCompared.getAndIncrement();
            if (!(overlapInfo.score >= this.acceptScore)) continue;
            MatchResult matchResult = new MatchResult(sequenceSketch.getSequenceId(), (SequenceId)object, overlapInfo, sequenceSketch.getSequenceLength(), sequenceSketch2.getSequenceLength());
            arrayList.add((SequenceId)((Object)matchResult));
        }
        long l3 = System.nanoTime();
        this.sortMergeSearchTime.getAndAdd(l3 - l2);
        return arrayList;
    }

    public double getMinHashSearchTime() {
        return (double)this.minhashSearchTime.longValue() * 1.0E-9;
    }

    public double getSortMergeTime() {
        return (double)this.sortMergeSearchTime.longValue() * 1.0E-9;
    }

    public long getNumberElementsProcessed() {
        return this.numberElementsProcessed.get();
    }

    public long getNumberSequenceHashed() {
        return this.numberSequencesMinHashed.get();
    }

    public long getNumberSequencesFullyCompared() {
        return this.numberSequencesFullyCompared.get();
    }

    public long getNumberSequencesHit() {
        return this.numberSequencesHit.get();
    }

    public long getNumberSubSequencesHit() {
        return this.numberSubSequencesHit.get();
    }

    @Override
    public List<SequenceId> getStoredForwardSequenceIds() {
        ArrayList<SequenceId> arrayList = new ArrayList<SequenceId>(this.sequenceVectorsHash.size());
        for (SequenceSketch sequenceSketch : this.sequenceVectorsHash.values()) {
            if (!sequenceSketch.getSequenceId().isForward()) continue;
            arrayList.add(sequenceSketch.getSequenceId());
        }
        return arrayList;
    }

    @Override
    public SequenceSketch getStoredSequenceHash(SequenceId sequenceId) {
        return this.sequenceVectorsHash.get(sequenceId);
    }

    @Override
    public int size() {
        return this.sequenceVectorsHash.size();
    }
}

