/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.sketch;

import edu.umd.marbl.mhap.general.Sequence;
import edu.umd.marbl.mhap.main.MhapMain;
import edu.umd.marbl.mhap.sketch.KmerCounts;
import edu.umd.marbl.mhap.utils.HitCounter;
import edu.umd.marbl.mhap.utils.MersenneTwisterFast;
import edu.umd.marbl.mhap.utils.MhapRuntimeException;
import edu.umd.marbl.mhap.utils.Utils;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MinHash
implements Serializable {
    private final int[] minHashes;
    private final int seqLength;
    private static final long serialVersionUID = 8846482698636860862L;

    public static final int[] computeKmerMinHashesWeightedIntSuper(String string, int n, int n2, HashSet<Long> hashSet, KmerCounts kmerCounts, boolean bl) {
        int n3 = string.length() - n + 1;
        if (n3 < 1) {
            throw new MhapRuntimeException("Kmer size bigger than string length.");
        }
        long[] lArray = MhapMain.getValidKmersHashes() != null ? Utils.computeSequenceHashesLongValidKmers(string, n, 0) : Utils.computeSequenceHashesLong(string, n, 0);
        LinkedHashMap<Long, HitCounter> linkedHashMap = new LinkedHashMap<Long, HitCounter>(lArray.length);
        int n4 = 0;
        for (long entry : lArray) {
            HitCounter hitCounter = (HitCounter)((HashMap)linkedHashMap).get(entry);
            if (hitCounter == null) {
                hitCounter = new HitCounter(1);
                linkedHashMap.put(entry, hitCounter);
            } else {
                hitCounter.addHit();
            }
            if (n4 >= hitCounter.count) continue;
            n4 = hitCounter.count;
        }
        int[] nArray = new int[Math.max(1, n2)];
        long[] lArray2 = new long[n2];
        Arrays.fill(lArray2, Long.MAX_VALUE);
        for (Map.Entry entry : ((HashMap)linkedHashMap).entrySet()) {
            long l = (Long)entry.getKey();
            int n5 = ((HitCounter)entry.getValue()).count;
            if (kmerCounts != null || hashSet != null) {
                if (kmerCounts != null && kmerCounts.documentFrequencyRatio(l) > kmerCounts.getFilterCutoff() || hashSet != null && hashSet.contains(l)) {
                    if (!bl) {
                        n5 = 0;
                    }
                } else {
                    n5 = bl ? (n5 *= 3) : 1;
                }
            }
            if (MhapMain.getValidKmersHashes() != null && l == Long.MAX_VALUE) {
                n5 = 0;
            }
            if (n5 <= 0) continue;
            long l2 = l;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n5; ++j) {
                    l2 ^= l2 << 21;
                    l2 ^= l2 >>> 35;
                    if ((l2 ^= l2 << 4) >= lArray2[i]) continue;
                    lArray2[i] = l2;
                    nArray[i] = (int)l;
                }
            }
        }
        return nArray;
    }

    public static final int[] computeKmerMinHashes(String string, int n, int n2, HashSet<Integer> hashSet) {
        if (n2 % 2 != 0) {
            throw new MhapRuntimeException("Number of words must be multiple of 2.");
        }
        int n3 = string.length() - n + 1;
        if (n3 < 1) {
            throw new MhapRuntimeException("Kmer size bigger than string length.");
        }
        int[] nArray = Utils.computeSequenceHashes(string, n);
        int[] nArray2 = new int[Math.max(1, n2)];
        Arrays.fill(nArray2, Integer.MAX_VALUE);
        int n4 = n2 / 2;
        for (int i = 0; i < nArray.length; ++i) {
            if (hashSet != null && hashSet.contains(nArray[i])) continue;
            if (n2 == 0) {
                nArray2[0] = nArray[i];
                continue;
            }
            long l = nArray[i];
            for (int j = 0; j < n4; ++j) {
                l ^= l << 21;
                l ^= l >>> 35;
                l ^= l << 4;
                int n5 = (int)l;
                int n6 = (int)(l >> 32);
                if (n5 < nArray2[2 * j]) {
                    nArray2[2 * j] = n5;
                }
                if (n6 >= nArray2[2 * j + 1]) continue;
                nArray2[2 * j + 1] = n6;
            }
        }
        return nArray2;
    }

    public static MinHash fromByteStream(DataInputStream dataInputStream) throws IOException {
        try {
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = dataInputStream.readInt();
            }
            return new MinHash(n, nArray);
        }
        catch (EOFException eOFException) {
            return null;
        }
    }

    private MinHash(int n, int[] nArray) {
        this.seqLength = n;
        this.minHashes = nArray;
    }

    public MinHash(Sequence sequence, int n, int n2, HashSet<Long> hashSet, KmerCounts kmerCounts, boolean bl) {
        this.seqLength = sequence.length();
        this.minHashes = MinHash.computeKmerMinHashesWeightedIntSuper(sequence.getString(), n, n2, hashSet, kmerCounts, bl);
    }

    public MinHash(String string, int n, int n2) {
        this.seqLength = string.length();
        this.minHashes = MinHash.computeKmerMinHashesWeightedIntSuper(string, n, n2, null, null, true);
    }

    public byte[] getAsByteArray() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 * (2 + this.minHashes.length));
        byteBuffer.putInt(this.seqLength);
        byteBuffer.putInt(this.minHashes.length);
        for (int i = 0; i < this.minHashes.length; ++i) {
            byteBuffer.putInt(this.minHashes[i]);
        }
        return byteBuffer.array();
    }

    public final int[] getMinHashArray() {
        return this.minHashes;
    }

    public final int getSequenceLength() {
        return this.seqLength;
    }

    public final double jaccard(MinHash minHash) {
        int n = 0;
        int n2 = this.minHashes.length;
        if (minHash.minHashes.length != n2) {
            throw new MhapRuntimeException("MinHashes must be of same length in order to be comapred.");
        }
        for (int i = 0; i < n2; ++i) {
            if (this.minHashes[i] != minHash.minHashes[i]) continue;
            ++n;
        }
        return (double)n / (double)n2;
    }

    public final int numHashes() {
        return this.minHashes.length;
    }

    public String toString() {
        return "MinHash " + Arrays.toString(this.minHashes) + "";
    }

    /*
     * WARNING - void declaration
     */
    public static final int[] computeKmerMinHashesWeighted(String string, int n, int n2, HashSet<Integer> hashSet, KmerCounts kmerCounts) {
        int n3 = string.length() - n + 1;
        if (n3 < 1) {
            throw new MhapRuntimeException("Kmer size bigger than string length.");
        }
        int[] nArray = Utils.computeSequenceHashes(string, n);
        LinkedHashMap<Integer, HitCounter> linkedHashMap = new LinkedHashMap<Integer, HitCounter>(nArray.length);
        int n4 = 0;
        for (int n5 : nArray) {
            void object2;
            HitCounter hitCounter = (HitCounter)((HashMap)linkedHashMap).get(n5);
            if (hitCounter == null) {
                HitCounter hitCounter2 = new HitCounter(1);
                linkedHashMap.put(n5, hitCounter2);
            } else {
                hitCounter.addHit();
            }
            if (n4 >= object2.count) continue;
            n4 = object2.count;
        }
        Object object = new MersenneTwisterFast();
        int[] nArray2 = new int[Math.max(1, n2)];
        Arrays.fill(nArray2, Integer.MAX_VALUE);
        double[] dArray = new double[n2];
        Arrays.fill(dArray, Double.MAX_VALUE);
        for (Map.Entry entry : ((HashMap)linkedHashMap).entrySet()) {
            int n5 = (Integer)entry.getKey();
            int n6 = ((HitCounter)entry.getValue()).count;
            ((MersenneTwisterFast)object).setSeed(n5);
            for (int i = 0; i < n2; ++i) {
                double d = ((MersenneTwisterFast)object).nextDouble();
                if (!((d = -Math.log(d) / (double)n6) < dArray[i])) continue;
                nArray2[i] = n5;
                dArray[i] = d;
            }
        }
        return nArray2;
    }

    public static final int[] computeKmerMinHashesWeightedInt(String string, int n, int n2, HashSet<Integer> hashSet, KmerCounts kmerCounts) {
        if (n2 % 2 != 0) {
            throw new MhapRuntimeException("Number of words must be multiple of 2.");
        }
        int n3 = string.length() - n + 1;
        if (n3 < 1) {
            throw new MhapRuntimeException("Kmer size bigger than string length.");
        }
        int[] nArray = Utils.computeSequenceHashes(string, n);
        LinkedHashMap<Integer, HitCounter> linkedHashMap = new LinkedHashMap<Integer, HitCounter>(nArray.length);
        int n4 = 0;
        for (int n5 : nArray) {
            Object object = (HitCounter)((HashMap)linkedHashMap).get(n5);
            if (object == null) {
                object = new HitCounter(1);
                linkedHashMap.put(n5, (HitCounter)object);
            } else {
                ((HitCounter)object).addHit();
            }
            if (n4 >= ((HitCounter)object).count) continue;
            n4 = ((HitCounter)object).count;
        }
        int[] nArray2 = new int[Math.max(1, n2)];
        int n6 = n2 / 2;
        int[] nArray3 = new int[n6];
        int[] nArray4 = new int[n6];
        Arrays.fill(nArray3, Integer.MAX_VALUE);
        Arrays.fill(nArray4, Integer.MAX_VALUE);
        for (Map.Entry entry : ((HashMap)linkedHashMap).entrySet()) {
            int n7 = (Integer)entry.getKey();
            int n8 = ((HitCounter)entry.getValue()).count;
            if (kmerCounts.documentFrequencyRatio(n7) > 1.0E-5 || hashSet != null && hashSet.contains(n7)) continue;
            long l = n7;
            for (int i = 0; i < n6; ++i) {
                for (int j = 0; j < n8; ++j) {
                    l ^= l << 21;
                    l ^= l >>> 35;
                    l ^= l << 4;
                    int n9 = (int)l;
                    int n10 = (int)(l >> 32);
                    if (n9 < nArray3[i]) {
                        nArray3[i] = n9;
                        nArray2[2 * i] = n7;
                    }
                    if (n10 >= nArray4[i]) continue;
                    nArray4[i] = n10;
                    nArray2[2 * i + 1] = n7;
                }
            }
        }
        return nArray2;
    }
}

