/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.sketch;

import edu.umd.marbl.mhap.sketch.CountMin;

public class KmerCounts {
    private final CountMin<Long> counter;
    private final long totalReads;
    private final double filterCutoff;

    public KmerCounts(CountMin<Long> countMin, int n, double d) {
        this.counter = countMin;
        this.totalReads = n;
        this.filterCutoff = d;
    }

    public long getTotalReads() {
        return this.totalReads;
    }

    public double inverseDocumentFrequency(long l) {
        long l2 = this.counter.getCount((Object)l);
        long l3 = this.counter.totalAdded();
        return Math.log10((double)l3 / (double)(l2 + 1L));
    }

    public double documentFrequencyRatio(long l) {
        long l2 = this.counter.getCount((Object)l);
        long l3 = this.counter.totalAdded();
        return (double)l2 / (double)l3;
    }

    public double weight(long l, int n, int n2) {
        double d = this.inverseDocumentFrequency(l);
        double d2 = 0.5 + 0.5 * (double)n / (double)n2;
        return d2 * d;
    }

    public double getFilterCutoff() {
        return this.filterCutoff;
    }
}

