/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.sketch;

import edu.umd.marbl.mhap.general.Counter;
import edu.umd.marbl.mhap.utils.MhapRuntimeException;
import edu.umd.marbl.mhap.utils.Utils;
import java.util.concurrent.atomic.LongAdder;

public final class CountMin<T>
implements Counter<T> {
    private final LongAdder[][] countTable;
    private final int depth;
    private final int seed;
    private final LongAdder totalAdded;
    private final int width;

    public CountMin(double d, double d2, int n) {
        this((int)Math.ceil(-Math.log(1.0 - d2) / Math.log(2.0)), (int)Math.ceil(2.0 / d), n);
    }

    public CountMin(int n, int n2, int n3) {
        this.depth = n;
        this.width = n2;
        this.seed = n3;
        this.countTable = new LongAdder[n][n2];
        this.totalAdded = new LongAdder();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.countTable[i][j] = new LongAdder();
            }
        }
    }

    @Override
    public void add(T t) {
        this.add(t, 1L);
    }

    @Override
    public void add(T t, long l) {
        if (l <= 0L) {
            throw new MhapRuntimeException("Positive value expected for increment.");
        }
        int[] nArray = Utils.computeHashesInt(t, this.depth, this.seed);
        for (int i = 0; i < this.depth; ++i) {
            this.countTable[i][(nArray[i] << 1 >>> 1) % this.width].add(l);
        }
        this.totalAdded.add(l);
    }

    @Override
    public long getCount(Object object) {
        int[] nArray = Utils.computeHashesInt(object, this.depth, this.seed);
        long l = Long.MAX_VALUE;
        for (int i = 0; i < this.depth; ++i) {
            long l2 = this.countTable[i][(nArray[i] << 1 >>> 1) % this.width].longValue();
            if (l <= l2) continue;
            l = l2;
        }
        return l;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getWidth() {
        return this.width;
    }

    @Override
    public long maxCount() {
        throw new MhapRuntimeException("Method not implemented.");
    }

    public long totalAdded() {
        return this.totalAdded.longValue();
    }
}

