/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.simhash;

import edu.umd.marbl.mhap.simhash.VectorHash;
import edu.umd.marbl.mhap.utils.MhapRuntimeException;

public abstract class AbstractBitSketch<T extends AbstractBitSketch<T>>
implements VectorHash<T>,
Comparable<T> {
    protected final long[] bits;

    protected AbstractBitSketch(long[] lArray) {
        this.bits = lArray;
    }

    public final double adjScore(T t) {
        double d = this.jaccard(t);
        return d;
    }

    public long[] getBits() {
        return this.bits;
    }

    @Override
    public int compareTo(T t) {
        for (int i = 0; i < this.bits.length; ++i) {
            if (this.bits[i] < ((AbstractBitSketch)t).bits[i]) {
                return -1;
            }
            if (this.bits[i] <= ((AbstractBitSketch)t).bits[i]) continue;
            return 1;
        }
        return 0;
    }

    public final int getIntersectionCount(T t) {
        if (this.bits.length != ((AbstractBitSketch)t).bits.length) {
            throw new MhapRuntimeException("Size of bits in tables must match.");
        }
        int n = 0;
        for (int i = 0; i < this.bits.length; ++i) {
            long l = this.bits[i] ^ ((AbstractBitSketch)t).bits[i];
            n += Long.bitCount(l);
        }
        return this.bits.length * 64 - n;
    }

    @Override
    public final double jaccard(T t) {
        int n = this.getIntersectionCount(t);
        double d = ((double)n / (double)(this.bits.length * 64) - 0.5) * 2.0;
        return Math.max(0.0, d);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.bits.length; ++i) {
            long l = Long.MIN_VALUE;
            for (int j = 63; j >= 0; --j) {
                if ((this.bits[i] & l) == 0L) {
                    stringBuilder.append("0");
                } else {
                    stringBuilder.append("1");
                }
                l >>>= 1;
            }
        }
        return stringBuilder.toString();
    }
}

