/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.main;

import edu.umd.marbl.mhap.utils.MhapRuntimeException;
import edu.umd.marbl.mhap.utils.Utils;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import org.apache.lucene.util.OpenBitSet;

public class ValidBitVectorsFileBuilder {
    public OpenBitSet readValidBitVectorsFile(String string) {
        ObjectInputStream objectInputStream = null;
        OpenBitSet openBitSet = null;
        try {
            System.err.println("Reading binary file of valid kmer hashes");
            objectInputStream = new ObjectInputStream(new FileInputStream(string));
            long[] lArray = (long[])objectInputStream.readObject();
            openBitSet = new OpenBitSet(lArray, lArray.length);
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("There was a problem opening the file: " + exception);
        }
        return openBitSet;
    }

    public void createValidBitVectorsFile(String string, OpenBitSet openBitSet) {
        long l = System.nanoTime();
        try {
            ObjectOutputStream objectOutputStream = null;
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
            System.err.println("Creating binary file of valid kmer hashes");
            objectOutputStream.writeObject(openBitSet.getBits());
            objectOutputStream.close();
        }
        catch (Exception exception) {
            throw new MhapRuntimeException("Could not parse valid k-mer file.", exception);
        }
        System.err.println("Time (s) to read valid kmer file: " + (double)(System.nanoTime() - l) * 1.0E-9);
    }

    public void createKmersFileFromBinaryBitVectors(String string, String string2, int n) throws IOException {
        FileWriter fileWriter = new FileWriter("kmersFromBinaryFile.kmer");
        OpenBitSet openBitSet = null;
        OpenBitSet openBitSet2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        long l = 0xFFFFFFFFL;
        System.err.println("Creating valid kmer hashes.");
        Utils.createValidKmerFilter(string, n, 0);
        openBitSet = Utils.getValidKmerHashes();
        this.createValidBitVectorsFile(string2, openBitSet);
        openBitSet2 = this.readValidBitVectorsFile(string2);
        System.err.println("Creating reverse hash computation");
        for (long i = 0L; i < l; ++i) {
            if (!openBitSet2.get(i)) continue;
            arrayList.add(Utils.reverseComputeHashYGS(i));
        }
        System.err.println("Writing results to new kmers file.");
        for (String string3 : arrayList) {
            fileWriter.write(string3);
            fileWriter.write("\n");
        }
        fileWriter.close();
    }
}

