/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.main;

import edu.umd.marbl.mhap.general.FastaData;
import edu.umd.marbl.mhap.general.Sequence;
import edu.umd.marbl.mhap.general.SequenceId;
import edu.umd.marbl.mhap.sketch.MinHash;
import edu.umd.marbl.mhap.utils.Utils;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Random;

public class KmerStatSimulator {
    private boolean verbose = false;
    private int kmer = -1;
    private int overlap = 100;
    private ArrayList<Double> randomJaccard = new ArrayList();
    private ArrayList<Double> randomMinHash = new ArrayList();
    private ArrayList<Double> randomMerCounts = new ArrayList();
    private String reference = null;
    private double requestedLength = 5000.0;
    private double sharedCount = 0.0;
    private ArrayList<Double> sharedJaccard = new ArrayList();
    private ArrayList<Double> sharedMinHash = new ArrayList();
    private ArrayList<Double> sharedMerCounts = new ArrayList();
    private HashMap<String, Integer> skipMers = new HashMap();
    private int totalTrials = 10000;
    private boolean halfError = false;
    private static Random generator = null;
    public static int seed = 0;

    public static void main(String[] stringArray) throws Exception {
        boolean bl = true;
        if (stringArray.length >= 5 && stringArray.length <= 6) {
            bl = false;
        } else if (stringArray.length >= 7) {
            bl = true;
        } else {
            KmerStatSimulator.printUsage();
            System.exit(1);
        }
        KmerStatSimulator kmerStatSimulator = new KmerStatSimulator();
        kmerStatSimulator.totalTrials = Integer.parseInt(stringArray[0]);
        if (bl) {
            kmerStatSimulator.requestedLength = Double.parseDouble(stringArray[2]);
            kmerStatSimulator.kmer = Integer.parseInt(stringArray[1]);
            kmerStatSimulator.overlap = Integer.parseInt(stringArray[3]);
            if (stringArray.length > 7) {
                kmerStatSimulator.halfError = Boolean.parseBoolean(stringArray[7]);
            }
            if (stringArray.length > 8) {
                kmerStatSimulator.reference = stringArray[8];
            }
            if ((double)kmerStatSimulator.overlap > kmerStatSimulator.requestedLength) {
                System.err.println("Cannot have overlap > sequence length");
                System.exit(1);
            }
            if (stringArray.length > 9) {
                kmerStatSimulator.loadSkipMers(stringArray[9]);
            }
            kmerStatSimulator.simulate(Double.parseDouble(stringArray[4]), Double.parseDouble(stringArray[5]), Double.parseDouble(stringArray[6]));
        } else {
            kmerStatSimulator.requestedLength = Double.parseDouble(stringArray[1]);
            if (stringArray.length > 5) {
                kmerStatSimulator.reference = stringArray[5];
            }
            kmerStatSimulator.simulate(Double.parseDouble(stringArray[2]), Double.parseDouble(stringArray[3]), Double.parseDouble(stringArray[4]));
        }
    }

    public static void printUsage() {
        System.err.println("Example usage: simulateSharedKmers <#trials> <kmer size> <seq length> <overlap length> <insertion> <del> <subst> [only one sequence error] [reference genome] [kmers to ignore]");
        System.err.println("Usage 2: simulateSharedKmers <#trials> <seq length> <insertion> <del> <subst> [reference genome]");
    }

    public KmerStatSimulator() {
        generator = new Random(seed);
    }

    private void loadSkipMers(String string) throws Exception {
        BufferedReader bufferedReader = Utils.getFile(string, "repeats");
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            String[] stringArray = string2.trim().split("\\s+");
            String string3 = stringArray[0].trim();
            int n = Integer.parseInt(stringArray[1]);
            this.skipMers.put(string3, n);
        }
        bufferedReader.close();
    }

    private String buildRandomSequence(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.getRandomBase(null));
        }
        return stringBuilder.toString();
    }

    public double compareKmers(String string, String string2) {
        String string3;
        int n;
        HashSet<String> hashSet = new HashSet<String>(string.length());
        HashSet<String> hashSet2 = new HashSet<String>(string.length() + string2.length());
        HashSet<String> hashSet3 = new HashSet<String>(string.length());
        for (n = 0; n <= string.length() - this.kmer; ++n) {
            string3 = string.substring(n, n + this.kmer);
            if (!this.skipMers.containsKey(string3)) {
                hashSet.add(string3);
            }
            hashSet2.add(string3);
        }
        for (n = 0; n <= string2.length() - this.kmer; ++n) {
            string3 = string2.substring(n, n + this.kmer);
            if (hashSet.contains(string3)) {
                hashSet3.add(string3);
                continue;
            }
            hashSet2.add(string3);
        }
        this.sharedCount = hashSet3.size();
        return (double)hashSet3.size() / (double)hashSet2.size();
    }

    public double compareMinHash(String string, String string2) {
        MinHash minHash = new MinHash(new Sequence(string, new SequenceId(1)), this.kmer, 1256, null, null, true);
        MinHash minHash2 = new MinHash(new Sequence(string2, new SequenceId(2)), this.kmer, 1256, null, null, true);
        return minHash.jaccard(minHash2);
    }

    private char getRandomBase(Character c) {
        Character c2 = null;
        while (c2 == null) {
            double d = generator.nextDouble();
            c2 = d < 0.25 ? Character.valueOf('A') : (d < 0.5 ? Character.valueOf('C') : (d < 0.75 ? Character.valueOf('G') : Character.valueOf('T')));
            if (c == null || !c.equals(c2)) continue;
            c2 = null;
        }
        return c2.charValue();
    }

    private String getSequence(int n, int n2, String string, double d, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        return this.getSequence(n, n2, string, d, stringBuilder, stringBuilder2, 0.792, 0.122, 0.086, true);
    }

    private String getSequence(int n, int n2, String string, double d, StringBuilder stringBuilder, StringBuilder stringBuilder2, double d2, double d3, double d4, boolean bl) {
        StringBuilder stringBuilder3 = new StringBuilder();
        stringBuilder3.append(string.substring(n2, Math.min(string.length(), n2 + 2 * n)));
        if (stringBuilder3.length() < 2 * n) {
            stringBuilder3.append(string.substring(0, Math.min(string.length(), 2 * n - stringBuilder3.length())));
        }
        LinkedList<Character> linkedList = new LinkedList<Character>();
        for (char c : stringBuilder3.toString().toCharArray()) {
            linkedList.add(Character.valueOf(c));
        }
        int n3 = 0;
        ListIterator<Character> listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            int n4 = ((Character)listIterator.next()).charValue();
            if (!(generator.nextDouble() < d)) continue;
            double d5 = generator.nextDouble();
            if (d5 < d4) {
                listIterator.set(Character.valueOf(this.getRandomBase(Character.valueOf((char)n4))));
                ++n3;
                n4 = (char)(n4 + '\u0001');
                continue;
            }
            if (d5 < d2 + d4) {
                listIterator.previous();
                listIterator.add(Character.valueOf(this.getRandomBase(null)));
                ++n3;
                continue;
            }
            listIterator.remove();
            ++n3;
        }
        stringBuilder3 = new StringBuilder();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            char c = ((Character)iterator.next()).charValue();
            stringBuilder3.append(c);
        }
        stringBuilder2.append((double)n3 / (double)n);
        if (bl) {
            return stringBuilder3.substring(0, n).toString();
        }
        return stringBuilder3.substring(stringBuilder3.length() - n, stringBuilder3.length()).toString();
    }

    private void outputStats(ArrayList<Double> arrayList, PrintStream printStream) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        for (double d3 : arrayList) {
            ++n;
            d += d3;
        }
        d /= (double)n;
        n = 0;
        for (double d3 : arrayList) {
            ++n;
            d2 += (d3 - d) * (d3 - d);
        }
        double d4 = Math.sqrt(d2 /= (double)(n - 1));
        printStream.print(d + "\t" + d4);
    }

    public void simulate(double d, double d2, double d3) throws Exception {
        int n;
        int n2;
        double d4 = d + d2 + d3;
        double d5 = d / d4;
        double d6 = d2 / d4;
        double d7 = d3 / d4;
        if (d4 < 0.0 || d4 > 1.0) {
            System.err.println("Error rate must be between 0 and 1");
            System.exit(1);
        }
        System.err.println("Started...");
        String[] stringArray = null;
        if (this.reference != null) {
            FastaData fastaData = new FastaData(this.reference, 0);
            fastaData.enqueueFullFile();
            stringArray = new String[fastaData.getNumberProcessed()];
            n2 = 0;
            while (!fastaData.isEmpty()) {
                stringArray[n2++] = fastaData.dequeue().getString().toUpperCase().replace("N", "");
            }
        }
        System.err.println("Loaded reference");
        for (n = 0; n < this.totalTrials; ++n) {
            if (n % 100 == 0) {
                System.err.println("Done " + n + "/" + this.totalTrials);
            }
            n2 = (int)this.requestedLength;
            int n3 = 0;
            String string = null;
            int n4 = 0;
            if (this.reference != null) {
                string = null;
                while (string == null || string.length() < 4 * n2) {
                    n4 = generator.nextInt(stringArray.length);
                    string = stringArray[n4];
                }
                n3 = generator.nextInt(string.length());
            } else {
                string = this.buildRandomSequence(n2 * 4);
            }
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            String string2 = this.getSequence(n2, n3, string, d4, stringBuilder, stringBuilder2, d5, d6, d7, false);
            if (this.kmer < 0) {
                System.out.println(">s" + n + " " + n4 + " " + (n3 + n2));
                System.out.println(Utils.convertToFasta(string2));
                continue;
            }
            int n5 = (int)(this.requestedLength * 2.0 - (double)this.overlap);
            int n6 = (n3 + n5) % string.length();
            String string3 = this.getSequence(n2, n6, string, this.halfError ? 0.0 : d4, stringBuilder, stringBuilder2, this.halfError ? 0.0 : d5, this.halfError ? 0.0 : d6, this.halfError ? 0.0 : d7, true);
            if (this.verbose) {
                System.err.println("Given seq " + n3 + " of len " + string.length() + " and offset " + n6 + " due to offset " + n5);
                System.err.println(">" + n4 + "_" + n3 + "\n" + string2);
                System.err.println(">" + n4 + "_" + n6 + "\n" + string3);
            }
            if (string2.length() != string3.length() || (double)string2.length() != this.requestedLength) {
                System.err.println("Error wrong length first: " + string2.length() + " second: " + string3.length() + " requested " + this.requestedLength);
                System.exit(1);
            }
            this.sharedJaccard.add(this.compareKmers(string2, string3));
            this.sharedMinHash.add(this.compareMinHash(string2, string3));
            this.sharedMerCounts.add(this.sharedCount);
            if (this.reference != null) {
                string = null;
                int n7 = 0;
                while (string == null || string.length() < 2 * n2) {
                    n7 = generator.nextInt(stringArray.length);
                    string = stringArray[n7];
                }
                n6 = generator.nextInt(string.length());
                while (n4 == n7 && Utils.getRangeOverlap(n3, n3 + n2, n6, n6 + n2) > 0) {
                    n6 = generator.nextInt(string.length());
                }
                string3 = this.getSequence(n2, n6, string, this.halfError ? 0.0 : d4, stringBuilder, stringBuilder2, this.halfError ? 0.0 : d5, this.halfError ? 0.0 : d6, this.halfError ? 0.0 : d7, true);
            } else {
                n6 = 0;
                string3 = this.buildRandomSequence(n2);
            }
            if (string2.length() != string3.length() || (double)string2.length() != this.requestedLength) {
                System.err.println("Error wrong length " + string2.length());
                System.exit(1);
            }
            this.randomJaccard.add(this.compareKmers(string2, string3));
            this.randomMinHash.add(this.compareMinHash(string2, string3));
            this.randomMerCounts.add(this.sharedCount);
        }
        if (this.randomJaccard.size() != this.randomMerCounts.size() || this.sharedJaccard.size() != this.sharedMerCounts.size() || this.sharedJaccard.size() != this.randomJaccard.size()) {
            System.err.println("Error trial number not consistent!");
        }
        if (this.sharedMerCounts.size() == 0) {
            return;
        }
        for (n = 0; n < this.totalTrials; ++n) {
            System.out.println(this.sharedMerCounts.get(n) + "\t" + this.sharedJaccard.get(n) + "\t" + this.sharedMinHash.get(n) + "\t" + this.randomMerCounts.get(n) + "\t" + this.randomJaccard.get(n) + "\t" + this.randomMinHash.get(n));
        }
        System.out.print("Shared mer counts stats: ");
        this.outputStats(this.sharedMerCounts, System.out);
        System.out.println();
        System.out.print("Shared jaccard stats: ");
        this.outputStats(this.sharedJaccard, System.out);
        System.out.println();
        System.out.print("Shared MinHash jaccard stats: ");
        this.outputStats(this.sharedMinHash, System.out);
        System.out.println();
        System.out.print("Random mer counts stats: ");
        this.outputStats(this.randomMerCounts, System.out);
        System.out.println();
        System.out.print("Random jaccard stats: ");
        this.outputStats(this.randomJaccard, System.out);
        System.out.println();
        System.out.print("Random MinHash jaccard stats: ");
        this.outputStats(this.randomMinHash, System.out);
        System.out.println();
    }
}

