/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.main;

import edu.umd.marbl.mhap.utils.Utils;
import java.io.BufferedReader;
import java.util.TreeMap;

public class GetHistogramStats {
    private static final int NUM_SD = 7;
    private TreeMap<Integer, Long> histogram = new TreeMap();
    private double percent = 0.99;
    private double mean = 0.0;
    private double stdev = 0.0;
    private long cut = 0L;

    public GetHistogramStats(String string, double d) {
        try {
            BufferedReader bufferedReader = Utils.getFile(string, "hist");
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = string2.trim().split("\\s+");
                int n = Integer.parseInt(stringArray[0]);
                long l = Long.parseLong(stringArray[1]);
                this.histogram.put(n, l);
            }
            bufferedReader.close();
            this.percent = d;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void process() throws NumberFormatException {
        long l;
        double d = 0.0;
        double d2 = 0.0;
        long l2 = 0L;
        for (int n : this.histogram.keySet()) {
            long l3 = this.histogram.get(n);
            for (l = 0L; l < l3; ++l) {
                double d3 = (double)n - this.mean;
                this.mean += d3 / (double)(++l2);
                d += d3 * ((double)n - this.mean);
                d2 += (double)n;
            }
        }
        this.stdev = Math.sqrt(d /= (double)l2);
        double d4 = 0.0;
        for (int n : this.histogram.keySet()) {
            if (!((d4 += (double)n * (double)(l = this.histogram.get(n).longValue())) / d2 > this.percent)) continue;
            this.cut = n;
            break;
        }
    }

    public String toString() {
        return Utils.DECIMAL_FORMAT.format(this.mean) + "\t" + Utils.DECIMAL_FORMAT.format(this.stdev) + "\t" + "\t" + this.cut + "\t" + Utils.DECIMAL_FORMAT.format(this.mean + 7.0 * this.stdev);
    }

    public static void main(String[] stringArray) throws NumberFormatException {
        GetHistogramStats getHistogramStats = new GetHistogramStats(stringArray[0], Double.parseDouble(stringArray[1]));
        getHistogramStats.process();
        System.out.println(getHistogramStats.toString());
    }
}

