/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.main;

import edu.umd.marbl.mhap.general.FastaData;
import edu.umd.marbl.mhap.utils.IntervalTree;
import edu.umd.marbl.mhap.utils.Utils;
import jaligner.Alignment;
import jaligner.Sequence;
import jaligner.SmithWatermanGotoh;
import jaligner.matrix.Matrix;
import jaligner.matrix.MatrixLoader;
import jaligner.matrix.MatrixLoaderException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EstimateROC {
    private static final boolean ALIGN_SW = true;
    private static final double MIN_OVERLAP_DIFFERENCE = 0.8;
    private static final double MIN_IDENTITY = 0.7;
    private static final double MIN_REF_IDENTITY = 0.7999999999999999;
    private static final int DEFAULT_NUM_TRIALS = 10000;
    private static final int DEFAULT_MIN_OVL = 2000;
    private static final boolean DEFAULT_DO_DP = false;
    private static boolean DEBUG = false;
    private static Random generator = null;
    public static int seed = 0;
    private HashMap<String, IntervalTree<Integer>> clusters = new HashMap();
    private HashMap<String, String> seqToChr = new HashMap(10000000);
    private HashMap<String, Integer> seqToScore = new HashMap(10000000);
    private HashMap<String, Pair> seqToPosition = new HashMap(10000000);
    private HashMap<Integer, String> seqToName = new HashMap(10000000);
    private HashMap<String, Integer> seqNameToIndex = new HashMap(10000000);
    private HashSet<String> ovlNames = new HashSet(100000000);
    private HashMap<String, Overlap> ovlInfo = new HashMap(100000000);
    private HashMap<Integer, String> ovlToName = new HashMap(100000000);
    private int minOvlLen = 2000;
    private int numTrials = 10000;
    private boolean doDP = false;
    private long tp = 0L;
    private long fn = 0L;
    private long tn = 0L;
    private long fp = 0L;
    private double ppv = 0.0;
    private edu.umd.marbl.mhap.general.Sequence[] dataSeq = null;

    public static void printUsage() {
        System.err.println("This program uses random sampling to estimate PPV/Sensitivity/Specificity");
        System.err.println("The sequences in the fasta file used to generate the truth must be sequentially numbered from 1 to N!");
        System.err.println("\t1. A blasr M4 file mapping sequences to a reference (or reference subset)");
        System.err.println("\t2. All-vs-all mappings of same sequences in CA ovl format");
        System.err.println("\t3. Fasta sequences sequentially numbered from 1 to N.");
        System.err.println("\t4. Minimum overlap length (default: 2000");
        System.err.println("\t5. Number of random trials, 0 means full compute (default : 10000");
        System.err.println("\t6. Compute DP during PPV true/false");
        System.err.println("\t7. Debug output true/false");
    }

    public static void main(String[] stringArray) throws Exception {
        long l;
        if (stringArray.length < 3) {
            EstimateROC.printUsage();
            System.exit(1);
        }
        EstimateROC estimateROC = null;
        estimateROC = stringArray.length > 5 ? new EstimateROC(Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[4]), Boolean.parseBoolean(stringArray[5])) : (stringArray.length > 4 ? new EstimateROC(Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[4])) : (stringArray.length > 3 ? new EstimateROC(Integer.parseInt(stringArray[3])) : new EstimateROC()));
        if (stringArray.length > 6) {
            DEBUG = Boolean.parseBoolean(stringArray[6]);
        }
        System.err.println("Running, reference: " + stringArray[0] + " matches: " + stringArray[1]);
        System.err.println("Number trials:  " + (estimateROC.numTrials == 0 ? "all" : Integer.valueOf(estimateROC.numTrials)));
        System.err.println("Minimum ovl:  " + estimateROC.minOvlLen);
        System.err.print("Loading reference...");
        long l2 = l = System.nanoTime();
        estimateROC.processReference(stringArray[0]);
        System.err.println("done " + (double)(System.nanoTime() - l) * 1.0E-9 + "s.");
        System.err.print("Loading fasta...");
        l = System.nanoTime();
        estimateROC.loadFasta(stringArray[2]);
        System.err.println("done " + (double)(System.nanoTime() - l) * 1.0E-9 + "s.");
        System.err.print("Loading matches...");
        l = System.nanoTime();
        estimateROC.processOverlaps(stringArray[1]);
        System.err.println("done " + (double)(System.nanoTime() - l) * 1.0E-9 + "s.");
        if (estimateROC.numTrials == 0) {
            System.err.print("Computing full statistics O(" + estimateROC.seqToName.size() + "^2) operations!...");
            l = System.nanoTime();
            estimateROC.fullEstimate();
            System.err.println("done " + (double)(System.nanoTime() - l) * 1.0E-9 + "s.");
        } else {
            System.err.print("Computing sensitivity...");
            l = System.nanoTime();
            estimateROC.estimateSensitivity();
            System.err.println("done " + (double)(System.nanoTime() - l) * 1.0E-9 + "s.");
            System.err.print("Computing specificity...");
            l = System.nanoTime();
            estimateROC.estimateSpecificity();
            System.err.println("done " + (double)(System.nanoTime() - l) * 1.0E-9 + "s.");
            System.err.print("Computing PPV...");
            l = System.nanoTime();
            estimateROC.estimatePPV();
            System.err.println("done " + (double)(System.nanoTime() - l) * 1.0E-9 + "s.");
        }
        System.err.println("Total time: " + (double)(System.nanoTime() - l2) * 1.0E-9 + "s.");
        System.out.println("Estimated sensitivity:\t" + Utils.DECIMAL_FORMAT.format((double)estimateROC.tp / (double)(estimateROC.tp + estimateROC.fn)));
        System.out.println("Estimated specificity:\t" + Utils.DECIMAL_FORMAT.format((double)estimateROC.tn / (double)(estimateROC.fp + estimateROC.tn)));
        System.out.println("Estimated PPV:\t " + Utils.DECIMAL_FORMAT.format(estimateROC.ppv));
    }

    public EstimateROC() {
        this(2000, 10000);
    }

    public EstimateROC(int n) {
        this(n, 10000);
    }

    public EstimateROC(int n, int n2) {
        this(n, n2, false);
    }

    public EstimateROC(int n, int n2, boolean bl) {
        this.minOvlLen = n;
        this.numTrials = n2;
        this.doDP = bl;
        generator = new Random(seed);
    }

    private static int getSequenceId(String string) {
        return Integer.parseInt(string) - 1;
    }

    private static String getOvlName(String string, String string2) {
        return string.compareTo(string2) <= 0 ? string + "_" + string2 : string2 + "_" + string;
    }

    private String pickRandomSequence() {
        int n = generator.nextInt(this.seqToName.size());
        return this.seqToName.get(n);
    }

    private String pickRandomMatch() {
        int n = generator.nextInt(this.ovlToName.size());
        return this.ovlToName.get(n);
    }

    private int getOverlapSize(String string, String string2) {
        String string3 = this.seqToChr.get(string);
        String string4 = this.seqToChr.get(string2);
        Pair pair = this.seqToPosition.get(string);
        Pair pair2 = this.seqToPosition.get(string2);
        if (!string3.equalsIgnoreCase(string4)) {
            System.err.println("Error: comparing wrong chromosomes betweeen sequences " + string + " and sequence " + string2);
            System.exit(1);
        }
        return Utils.getRangeOverlap(pair.first, pair.second, pair2.first, pair2.second);
    }

    private HashSet<String> getSequenceMatches(String string, int n) {
        String string2 = this.seqToChr.get(string);
        Pair pair = this.seqToPosition.get(string);
        List<Integer> list = this.clusters.get(string2).get(pair.first, pair.second);
        HashSet<String> hashSet = new HashSet<String>();
        Iterator<Integer> iterator = list.iterator();
        while (iterator.hasNext()) {
            int n2;
            String string3 = this.seqToName.get(iterator.next());
            Pair pair2 = this.seqToPosition.get(string3);
            String string4 = this.seqToChr.get(string3);
            if (!string2.equalsIgnoreCase(string4)) {
                System.err.println("Error: comparing wrong chromosomes betweeen sequences " + string + " and sequence in its cluster " + string3);
                System.exit(1);
            }
            if ((n2 = Utils.getRangeOverlap(pair.first, pair.second, pair2.first, pair2.second)) < n || string.equalsIgnoreCase(string3)) continue;
            hashSet.add(string3);
        }
        return hashSet;
    }

    private Overlap getOverlapInfo(String string) {
        Overlap overlap = new Overlap();
        String[] stringArray = string.trim().split("\\s+");
        try {
            if (stringArray.length == 7 || stringArray.length == 6) {
                overlap.id1 = stringArray[0];
                overlap.id2 = stringArray[1];
                double d = Double.parseDouble(stringArray[5]) * 5.0;
                int n = Integer.parseInt(stringArray[3]);
                int n2 = Integer.parseInt(stringArray[4]);
                overlap.isFwd = "N".equalsIgnoreCase(stringArray[2]);
                if (this.dataSeq != null) {
                    int n3 = this.dataSeq[Integer.parseInt(overlap.id1) - 1].length();
                    int n4 = this.dataSeq[Integer.parseInt(overlap.id2) - 1].length();
                    overlap.afirst = Math.max(0, n);
                    overlap.asecond = Math.min(n3, n3 + n2);
                    overlap.bfirst = -1 * Math.min(0, n);
                    overlap.bsecond = Math.min(n4, n4 - n2);
                }
            } else if (stringArray.length == 12) {
                overlap.id1 = stringArray[0];
                overlap.id2 = stringArray[1];
                double d = Double.parseDouble(stringArray[2]);
                boolean bl = overlap.isFwd = Integer.parseInt(stringArray[8]) == 0;
                if (this.dataSeq != null) {
                    int n = this.dataSeq[EstimateROC.getSequenceId(overlap.id1)].length();
                    int n5 = this.dataSeq[EstimateROC.getSequenceId(overlap.id2)].length();
                    overlap.afirst = Integer.parseInt(stringArray[5]);
                    overlap.asecond = Integer.parseInt(stringArray[6]);
                    overlap.bfirst = Integer.parseInt(stringArray[9]);
                    overlap.bsecond = Integer.parseInt(stringArray[10]);
                    if (overlap.asecond > n) {
                        overlap.asecond = n;
                    }
                    if (overlap.bsecond > n5) {
                        overlap.bsecond = n5;
                    }
                }
            } else if (stringArray.length == 13 && !string.contains("[")) {
                overlap.afirst = Integer.parseInt(stringArray[5]);
                overlap.asecond = Integer.parseInt(stringArray[6]);
                overlap.bfirst = Integer.parseInt(stringArray[9]);
                overlap.bsecond = Integer.parseInt(stringArray[10]);
                boolean bl = overlap.isFwd = Integer.parseInt(stringArray[8]) == 0;
                if (!overlap.isFwd) {
                    overlap.bsecond = Integer.parseInt(stringArray[11]) - Integer.parseInt(stringArray[9]);
                    overlap.bfirst = Integer.parseInt(stringArray[11]) - Integer.parseInt(stringArray[10]);
                }
                overlap.id1 = stringArray[0];
                if (overlap.id1.indexOf("/") != -1) {
                    overlap.id1 = overlap.id1.substring(0, stringArray[0].indexOf("/"));
                }
                if (overlap.id1.indexOf(",") != -1) {
                    overlap.id1 = overlap.id1.split(",")[1];
                }
                overlap.id2 = stringArray[1];
                if (overlap.id2.indexOf(",") != -1) {
                    overlap.id2 = overlap.id2.split(",")[1];
                }
                if (this.dataSeq != null) {
                    int n = this.dataSeq[EstimateROC.getSequenceId(overlap.id1)].length();
                    int n6 = this.dataSeq[EstimateROC.getSequenceId(overlap.id2)].length();
                    if (overlap.asecond > n) {
                        overlap.asecond = n;
                    }
                    if (overlap.bsecond > n6) {
                        overlap.bsecond = n6;
                    }
                }
            } else if (stringArray.length >= 13 && stringArray.length <= 18) {
                overlap.id1 = stringArray[0].replaceAll(",", "");
                overlap.id2 = stringArray[1].replaceAll(",", "");
                overlap.isFwd = stringArray[2].equalsIgnoreCase("n");
                String[] stringArray2 = string.split("\\[");
                String string2 = stringArray2[1].substring(0, stringArray2[1].indexOf("]"));
                String string3 = stringArray2[2].substring(0, stringArray2[2].indexOf("]"));
                String[] stringArray3 = string2.replaceAll(",", "").split("\\.\\.");
                String[] stringArray4 = string3.replaceAll(",", "").split("\\.\\.");
                overlap.afirst = Integer.parseInt(stringArray3[0].trim());
                overlap.asecond = Integer.parseInt(stringArray3[1].trim());
                overlap.bfirst = Integer.parseInt(stringArray4[0].trim());
                overlap.bsecond = Integer.parseInt(stringArray4[1].trim());
                if (!overlap.isFwd) {
                    overlap.bsecond = this.dataSeq[EstimateROC.getSequenceId(overlap.id2)].length() - Integer.parseInt(stringArray4[0].trim());
                    overlap.bfirst = this.dataSeq[EstimateROC.getSequenceId(overlap.id2)].length() - Integer.parseInt(stringArray4[1].trim());
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Warning: could not parse input line: " + string + " " + numberFormatException.getMessage());
        }
        return overlap;
    }

    private void loadFasta(String string) throws IOException {
        FastaData fastaData = new FastaData(string, 0);
        fastaData.enqueueFullFile();
        this.dataSeq = new edu.umd.marbl.mhap.general.Sequence[fastaData.getNumberProcessed()];
        int n = 0;
        while (!fastaData.isEmpty()) {
            this.dataSeq[n++] = fastaData.dequeue();
        }
    }

    private void processOverlaps(String string) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
        String string2 = null;
        int n = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            String string3;
            Overlap overlap = this.getOverlapInfo(string2);
            String string4 = overlap.id1;
            String string5 = overlap.id2;
            if (string4 == null || string5 == null || string4.equalsIgnoreCase(string5) || this.seqToChr.get(string4) == null || this.seqToChr.get(string5) == null || this.ovlNames.contains(string3 = EstimateROC.getOvlName(string4, string5))) continue;
            this.ovlNames.add(string3);
            this.ovlToName.put(n, string3);
            this.ovlInfo.put(string3, overlap);
            if (++n % 100000 != 0) continue;
            System.err.println("Loaded " + n);
        }
        System.err.print("Processed " + this.ovlNames.size() + " overlaps");
        if (this.ovlNames.isEmpty()) {
            System.err.println("Error: No sequence matches to reference loaded!");
            System.exit(1);
        }
        bufferedReader.close();
    }

    private void processReference(String string) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
        String string2 = null;
        int n = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            double d;
            String[] stringArray = string2.trim().split("\\s+");
            String string3 = stringArray[0];
            if (string3.indexOf("/") != -1) {
                string3 = string3.substring(0, ((String)stringArray[0]).indexOf("/"));
            }
            if (string3.indexOf(",") != -1) {
                string3 = string3.split(",")[1];
            }
            double d2 = Double.parseDouble((String)stringArray[3]);
            int n2 = Integer.parseInt((String)stringArray[5]);
            int n3 = Integer.parseInt((String)stringArray[6]);
            int n4 = Integer.parseInt((String)stringArray[7]);
            int n5 = Integer.parseInt((String)stringArray[4]);
            if (n5 != 0) {
                System.err.println("Error: malformed line, first sequences should always be in fwd orientation");
                System.exit(1);
            }
            int n6 = Integer.parseInt((String)stringArray[9]);
            int n7 = Integer.parseInt((String)stringArray[10]);
            int n8 = Integer.parseInt((String)stringArray[11]);
            int n9 = Integer.parseInt((String)stringArray[8]);
            int n10 = Integer.parseInt((String)stringArray[2]);
            if (n9 == 1) {
                int n11 = n8 - n7;
                n7 = n8 - n6;
                n6 = n11;
            }
            if (d2 < 80.0 || (d = (double)(n3 - n2) / (double)(n7 - n6)) < 0.8) continue;
            Object object = stringArray[1];
            if (!this.clusters.containsKey(object)) {
                this.clusters.put((String)object, new IntervalTree());
            }
            if (this.seqToPosition.containsKey(string3)) {
                if (n10 >= this.seqToScore.get(string3)) continue;
                this.seqToPosition.put(string3, new Pair(n6, n7));
                this.seqToChr.put(string3, (String)object);
                this.seqToScore.put(string3, n10);
                continue;
            }
            this.seqToPosition.put(string3, new Pair(n6, n7));
            this.seqToChr.put(string3, (String)object);
            this.seqToName.put(n, string3);
            this.seqNameToIndex.put(string3, n);
            this.seqToScore.put(string3, n10);
            ++n;
        }
        bufferedReader.close();
        for (String string3 : this.seqToPosition.keySet()) {
            String string4 = this.seqToChr.get(string3);
            if (!this.clusters.containsKey(string4)) {
                this.clusters.put(string4, new IntervalTree());
            }
            Pair pair = this.seqToPosition.get(string3);
            this.clusters.get(string4).addInterval(pair.first, pair.second, this.seqNameToIndex.get(string3));
        }
        System.err.print("Processed " + this.clusters.size() + " chromosomes, " + this.seqToPosition.size() + " sequences matching ref");
        if (this.seqToPosition.isEmpty()) {
            System.err.println("Error: No sequence matches to reference loaded!");
            System.exit(1);
        }
    }

    private boolean overlapExists(String string, String string2) {
        return this.ovlNames.contains(EstimateROC.getOvlName(string, string2));
    }

    private boolean overlapMatches(String string, String string2) {
        int n = this.getOverlapSize(string, string2);
        Overlap overlap = this.ovlInfo.get(EstimateROC.getOvlName(string, string2));
        if (overlap == null) {
            return false;
        }
        int n2 = Math.abs(overlap.getSize() - n);
        double d = (double)n2 / (double)n;
        if (DEBUG) {
            System.err.println("Overlap " + overlap + " " + overlap.getSize() + " versus ref " + n + " " + " diff is " + n2 + "(" + d + ")");
        }
        return !(d > 0.3);
    }

    private void checkMatches(String string, HashSet<String> hashSet) {
        for (String string2 : hashSet) {
            if (this.overlapMatches(string, string2)) {
                ++this.tp;
                continue;
            }
            ++this.fn;
            if (!DEBUG) continue;
            System.err.println("Overlap between sequences: " + string + ", " + string2 + " is missing.");
            System.err.println(">" + string + " reference location " + this.seqToChr.get(string) + " " + this.seqToPosition.get((Object)string).first + ", " + this.seqToPosition.get((Object)string).second);
            System.err.println(this.dataSeq[Integer.parseInt(string) - 1].getString());
            System.err.println(">" + string2 + " reference location " + this.seqToChr.get(string2) + " " + this.seqToPosition.get((Object)string2).first + ", " + this.seqToPosition.get((Object)string2).second);
            System.err.println(this.dataSeq[Integer.parseInt(string2) - 1].getString());
        }
    }

    private static double getScore(Alignment alignment) {
        char[] cArray = alignment.getSequence1();
        char[] cArray2 = alignment.getSequence2();
        int n = Math.max(cArray.length, cArray2.length);
        int n2 = Math.min(cArray.length, cArray2.length);
        int n3 = 45;
        int n4 = 0;
        for (int i = 0; i <= n; ++i) {
            int n5 = n3;
            int n6 = n3;
            if (i < cArray.length) {
                n5 = cArray[i];
            }
            if (i < cArray2.length) {
                n6 = cArray2[i];
            }
            if (n5 != n6 || n5 == n3 || n6 == n3) continue;
            ++n4;
        }
        return (double)n4 / (double)n2;
    }

    private boolean computeDP(String string, String string2) {
        Alignment alignment;
        if (!this.doDP) {
            return false;
        }
        Logger logger = null;
        logger = Logger.getLogger(SmithWatermanGotoh.class.getName());
        logger.setLevel(Level.OFF);
        logger = Logger.getLogger(MatrixLoader.class.getName());
        logger.setLevel(Level.OFF);
        Overlap overlap = this.ovlInfo.get(EstimateROC.getOvlName(string, string2));
        System.err.println("Aligning sequence " + overlap.id1 + " to " + overlap.id2 + " " + overlap.bfirst + " to " + overlap.bsecond + " and " + overlap.isFwd + " and " + overlap.afirst + " " + overlap.asecond);
        Sequence sequence = new Sequence(this.dataSeq[EstimateROC.getSequenceId(overlap.id1)].getString().substring(overlap.afirst, overlap.asecond));
        Sequence sequence2 = null;
        sequence2 = overlap.isFwd ? new Sequence(this.dataSeq[EstimateROC.getSequenceId(overlap.id2)].getString().substring(overlap.bfirst, overlap.bsecond)) : new Sequence(Utils.rc(this.dataSeq[EstimateROC.getSequenceId(overlap.id2)].getString().substring(overlap.bfirst, overlap.bsecond)));
        try {
            alignment = SmithWatermanGotoh.align((Sequence)sequence, (Sequence)sequence2, (Matrix)MatrixLoader.load((String)"MATCH"), (float)2.0f, (float)1.0f);
        }
        catch (MatrixLoaderException matrixLoaderException) {
            return false;
        }
        double d = EstimateROC.getScore(alignment);
        if (DEBUG) {
            System.err.println(alignment.getSummary());
            System.err.println("My score: " + d);
            System.err.println(new jaligner.formats.Pair().format(alignment));
        }
        return d > 0.7 && alignment.getLength() > this.minOvlLen;
    }

    private void estimateSensitivity() {
        for (int i = 0; i < this.numTrials; ++i) {
            String string = null;
            HashSet<String> hashSet = null;
            while (hashSet == null || hashSet.size() == 0) {
                string = this.pickRandomSequence();
                hashSet = this.getSequenceMatches(string, this.minOvlLen);
            }
            if (DEBUG) {
                System.err.println("Estimated sensitivity trial #" + i + " " + string + " matches " + hashSet);
            }
            this.checkMatches(string, hashSet);
        }
    }

    private void estimateSpecificity() {
        for (int i = 0; i < this.numTrials; ++i) {
            String string = this.pickRandomSequence();
            String string2 = this.pickRandomSequence();
            while (string.equalsIgnoreCase(string2)) {
                string2 = this.pickRandomSequence();
            }
            HashSet<String> hashSet = this.getSequenceMatches(string, 0);
            if (this.overlapExists(string, string2)) {
                if (hashSet.contains(string2)) continue;
                ++this.fp;
                continue;
            }
            if (hashSet.contains(string2)) continue;
            ++this.tn;
        }
    }

    private void estimatePPV() {
        int n = 0;
        for (int i = 0; i < this.numTrials; ++i) {
            Object object;
            int n2 = 0;
            String[] stringArray = null;
            String string = null;
            while (n2 < this.minOvlLen) {
                string = this.pickRandomMatch();
                object = this.ovlInfo.get(string);
                n2 = Utils.getRangeOverlap(((Overlap)object).afirst, ((Overlap)object).asecond, ((Overlap)object).bfirst, ((Overlap)object).bsecond);
            }
            if (string == null) {
                System.err.println("Could not find any computed overlaps > " + this.minOvlLen);
                System.exit(1);
                continue;
            }
            stringArray = string.split("_");
            object = stringArray[0];
            String string2 = stringArray[1];
            HashSet<String> hashSet = this.getSequenceMatches((String)object, 0);
            if (hashSet.contains(string2)) {
                ++n;
                continue;
            }
            if (this.computeDP((String)object, string2)) {
                ++n;
                continue;
            }
            if (!DEBUG) continue;
            System.err.println("Overlap between sequences: " + (String)object + ", " + string2 + " is not correct.");
        }
        this.ppv = (double)n / (double)this.numTrials;
    }

    private void fullEstimate() {
        for (int i = 0; i < this.seqToName.size(); ++i) {
            String string = this.seqToName.get(i);
            for (int j = i + 1; j < this.seqToName.size(); ++j) {
                String string2 = this.seqToName.get(j);
                if (string == null || string2 == null) continue;
                HashSet<String> hashSet = this.getSequenceMatches(string, 0);
                if (!this.overlapMatches(string, string2)) {
                    if (!hashSet.contains(string2)) {
                        ++this.tn;
                        continue;
                    }
                    if (this.getOverlapSize(string, string2) <= this.minOvlLen) continue;
                    ++this.fn;
                    continue;
                }
                if (hashSet.contains(string2)) {
                    ++this.tp;
                    continue;
                }
                if (this.computeDP(string, string2)) {
                    ++this.tp;
                    continue;
                }
                ++this.fp;
            }
        }
        this.ppv = (double)this.tp / ((double)this.tp + (double)this.fp);
    }

    private static class Overlap {
        public int afirst;
        public int bfirst;
        public int asecond;
        public int bsecond;
        public boolean isFwd;
        public String id1;
        public String id2;

        public int getSize() {
            double d = (double)Math.max(this.asecond, this.afirst) - (double)Math.min(this.asecond, this.afirst);
            return (int)Math.round((d += (double)Math.max(this.bsecond, this.bfirst) - (double)Math.min(this.bsecond, this.bfirst)) / 2.0);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Overlap Fwd=" + this.isFwd);
            stringBuilder.append(" Aid=");
            stringBuilder.append(this.id1);
            stringBuilder.append(" (");
            stringBuilder.append(this.afirst);
            stringBuilder.append(", ");
            stringBuilder.append(this.asecond);
            stringBuilder.append("), Bid=");
            stringBuilder.append(this.id2);
            stringBuilder.append(" (");
            stringBuilder.append(this.bfirst);
            stringBuilder.append(", ");
            stringBuilder.append(this.bsecond);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private static class Pair {
        public int first;
        public int second;

        public Pair(int n, int n2) {
            this.first = n;
            this.second = n2;
        }

        public int size() {
            return Math.max(this.first, this.second) - Math.min(this.first, this.second) + 1;
        }
    }
}

