/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.main;

import edu.umd.marbl.mhap.general.FastaData;
import edu.umd.marbl.mhap.general.MatchResult;
import edu.umd.marbl.mhap.general.Sequence;
import edu.umd.marbl.mhap.sketch.MinHashSearch;
import edu.umd.marbl.mhap.sketch.SequenceSketchStreamer;
import jaligner.Alignment;
import jaligner.SmithWatermanGotoh;
import jaligner.matrix.Matrix;
import jaligner.matrix.MatrixLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.LogManager;

public class AlignmentHashRun {
    private static final int DEFAULT_NUM_WORDS = 1024;
    private static final int DEFAULT_KMER_SIZE = 16;
    protected static final int DEFAULT_NUM_MIN_MATCHES = 1;
    protected static final int DEFAULT_SUB_SEQUENCE_SIZE = 5000;
    private static final double DEFAULT_THRESHOLD = 0.0;

    public static void main(String[] stringArray) throws Exception {
        String string = null;
        int n = 16;
        double d = 0.0;
        int n2 = 1024;
        int n3 = Runtime.getRuntime().availableProcessors() * 2;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].trim().equalsIgnoreCase("-k")) {
                n = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].trim().equalsIgnoreCase("-s")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].trim().equalsIgnoreCase("--num-hashes")) {
                n2 = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (!stringArray[i].trim().equalsIgnoreCase("--threshold")) continue;
            d = Double.parseDouble(stringArray[++i]);
        }
        System.err.println("Running with input fasta: " + string);
        System.err.println("kmer size:\t" + n);
        System.err.println("threshold:\t" + d);
        System.err.println("num hashes\t" + n2);
        LogManager.getLogManager().reset();
        long l = System.nanoTime();
        FastaData fastaData = new FastaData(string, 0);
        fastaData.enqueueFullFile();
        SequenceSketchStreamer sequenceSketchStreamer = new SequenceSketchStreamer(string, n, n2, 5000, 12, null, null, true, 0);
        MinHashSearch minHashSearch = new MinHashSearch(sequenceSketchStreamer, n2, 1, n3, true, 0, 800.0, 0.0);
        System.err.println("Processed " + sequenceSketchStreamer.getNumberProcessed() + " sequences.");
        System.err.println("Time (s) to hash: " + (double)(System.nanoTime() - l) * 1.0E-9);
        System.out.println("Read in and processed " + sequenceSketchStreamer.getNumberProcessed() + " sequences.");
        l = System.nanoTime();
        ArrayList<MatchResult> arrayList = minHashSearch.findMatches();
        System.err.println("Time (s) to score: " + (double)(System.nanoTime() - l) * 1.0E-9);
        ArrayList<MatchResult> arrayList2 = new ArrayList<MatchResult>();
        Collections.sort(arrayList);
        arrayList2.addAll(arrayList.subList(0, Math.min(arrayList.size(), 100)));
        arrayList2.addAll(arrayList.subList(Math.max(0, arrayList.size() - 50), arrayList.size()));
        System.out.println("Found " + arrayList.size() + " matches:");
        Matrix matrix = MatrixLoader.load((String)"/Users/kberlin/Dropbox/Projects/fast-align/src/test/resources/com/secret/fastalign/matrix/score_matrix.txt");
        int n4 = 0;
        double d2 = 0.0;
        for (MatchResult matchResult : arrayList2) {
            Sequence sequence = fastaData.getSequence(matchResult.getFromId());
            Sequence sequence2 = fastaData.getSequence(matchResult.getToId());
            double d3 = AlignmentHashRun.computeAlignment(sequence, sequence2, matrix);
            System.out.format("%s %f %f\n", matchResult, matchResult.getScore(), d3);
            d2 += matchResult.getScore();
            if (++n4 <= 200) continue;
            break;
        }
        System.out.println("Mean: " + (d2 /= (double)n4));
    }

    public static double computeAlignment(Sequence sequence, Sequence sequence2, Matrix matrix) {
        Alignment alignment = SmithWatermanGotoh.align((jaligner.Sequence)new jaligner.Sequence(sequence.getString()), (jaligner.Sequence)new jaligner.Sequence(sequence2.getString()), (Matrix)matrix, (float)5.0f, (float)3.0f);
        double d = AlignmentHashRun.getScoreWithNoTerminalGaps(alignment);
        return d;
    }

    public static float getScoreWithNoTerminalGaps(Alignment alignment) {
        char[] cArray = alignment.getSequence1();
        char[] cArray2 = alignment.getSequence2();
        char c = '-';
        float f = 1.0f;
        float f2 = 1.0f;
        float f3 = 0.0f;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = cArray.length - 1;
        if (cArray[n] == c) {
            while (cArray[n] == c) {
                ++n;
            }
        } else if (cArray2[n] == c) {
            while (cArray2[n] == c) {
                ++n;
            }
        }
        if (cArray[n2] == c) {
            while (cArray[n2] == c) {
                --n2;
            }
        } else if (cArray2[n2] == c) {
            while (cArray2[n2] == c) {
                --n2;
            }
        }
        for (int i = n; i <= n2; ++i) {
            char c2 = cArray[i];
            char c3 = cArray2[i];
            if (c2 == c) {
                f3 = bl ? (f3 -= f) : (f3 -= f2);
                bl = true;
                bl2 = false;
                continue;
            }
            if (c3 == c) {
                f3 = bl2 ? (f3 -= f) : (f3 -= f2);
                bl = false;
                bl2 = true;
                continue;
            }
            f3 += 1.0f;
            bl = false;
            bl2 = false;
        }
        return f3 /= (float)(n2 - n + 1);
    }
}

