/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.general;

import java.io.Serializable;

public final class SequenceId
implements Serializable {
    private static final long serialVersionUID = 2181572437818064822L;
    private final int id;
    private final boolean isFwd;
    private final String strId;
    public static boolean STORE_FULL_ID = false;

    public SequenceId(int n) {
        this(n, true);
    }

    public SequenceId(int n, boolean bl) {
        this.id = n;
        this.isFwd = bl;
        this.strId = null;
    }

    public SequenceId(int n, boolean bl, String string) {
        this.id = n;
        this.isFwd = bl;
        this.strId = string;
    }

    public SequenceId createOffset(int n) {
        return new SequenceId(this.id + n, this.isFwd, this.strId);
    }

    public SequenceId complimentId() {
        return new SequenceId(this.id, !this.isFwd, this.strId);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SequenceId sequenceId = (SequenceId)object;
        return this.id == sequenceId.id && this.isFwd == sequenceId.isFwd;
    }

    public boolean isForward() {
        return this.isFwd;
    }

    public int getHeaderId() {
        return this.id;
    }

    public String getHeader() {
        if (this.strId != null) {
            return this.strId;
        }
        return String.valueOf(this.id);
    }

    public int hashCode() {
        return this.isFwd ? this.id : -this.id;
    }

    public String toString() {
        return "" + this.getHeader() + (this.isFwd ? "(fwd)" : "(rev)");
    }

    public String toStringInt() {
        return "" + this.getHeader() + (this.isFwd ? " 1" : " 0");
    }
}

