/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.general;

import edu.umd.marbl.mhap.general.SequenceId;
import edu.umd.marbl.mhap.utils.Utils;

public final class Sequence {
    private final String sequence;
    private final SequenceId id;

    public Sequence(int[] nArray, SequenceId sequenceId) {
        this.id = sequenceId;
        StringBuilder stringBuilder = new StringBuilder();
        block6: for (int i = 0; i < nArray.length; ++i) {
            switch (nArray[i]) {
                case 0: {
                    stringBuilder.append("U");
                    continue block6;
                }
                case 1: {
                    stringBuilder.append("C");
                    continue block6;
                }
                case 2: {
                    stringBuilder.append("G");
                    continue block6;
                }
                case 3: {
                    stringBuilder.append("T");
                    continue block6;
                }
                default: {
                    throw new RuntimeException("Uknown integer value.");
                }
            }
        }
        this.sequence = stringBuilder.toString();
    }

    public Sequence(String string, SequenceId sequenceId) {
        this.sequence = string;
        this.id = sequenceId;
    }

    public String getString() {
        return this.sequence;
    }

    public SequenceId getId() {
        return this.id;
    }

    public Sequence getReverseCompliment() {
        return new Sequence(Utils.rc(this.sequence), this.id.complimentId());
    }

    public String getKmer(int n, int n2) {
        return this.sequence.substring(n, n + n2);
    }

    public int numKmers(int n) {
        return this.sequence.length() - n + 1;
    }

    public int length() {
        return this.sequence.length();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(">" + this.id + "\n");
        stringBuilder.append(this.sequence);
        return stringBuilder.toString();
    }
}

