/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.general;

import edu.umd.marbl.mhap.general.OverlapInfo;
import edu.umd.marbl.mhap.general.SequenceId;

public final class MatchResult
implements Comparable<MatchResult> {
    private final SequenceId fromId;
    private final SequenceId toId;
    private final int a1;
    private final int a2;
    private final int b1;
    private final int b2;
    private final double score;
    private final int kmerCount;
    private final int fromLength;
    private final int toLength;

    public MatchResult(SequenceId sequenceId, SequenceId sequenceId2, OverlapInfo overlapInfo, int n, int n2) {
        this.fromId = sequenceId;
        this.toId = sequenceId2;
        this.fromLength = n;
        this.toLength = n2;
        this.a1 = this.getFromId().isForward() ? overlapInfo.a1 : n - overlapInfo.b1;
        this.b1 = this.getFromId().isForward() ? overlapInfo.b1 : n - overlapInfo.a1;
        this.a2 = this.getToId().isForward() ? overlapInfo.a2 : n2 - overlapInfo.b2;
        this.b2 = this.getToId().isForward() ? overlapInfo.b2 : n2 - overlapInfo.a2;
        this.kmerCount = overlapInfo.kmerCount;
        this.score = overlapInfo.score > 1.0 ? 1.0 : overlapInfo.score;
    }

    public SequenceId getFromId() {
        return this.fromId;
    }

    public SequenceId getToId() {
        return this.toId;
    }

    public double getScore() {
        return this.score;
    }

    @Override
    public int compareTo(MatchResult matchResult) {
        return -Double.compare(this.score, matchResult.score);
    }

    public String toString() {
        return String.format("%s %s %.5f %d %d %d %d %d %d %d %d %d", this.getFromId().getHeader(), this.getToId().getHeader(), (1.0 - this.getScore()) * 100.0, this.kmerCount, this.getFromId().isForward() ? 0 : 1, this.a1, this.b1, this.fromLength, this.getToId().isForward() ? 0 : 1, this.a2, this.b2, this.toLength);
    }
}

