/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.general;

import edu.umd.marbl.mhap.general.Sequence;
import edu.umd.marbl.mhap.general.SequenceId;
import edu.umd.marbl.mhap.utils.MhapRuntimeException;
import edu.umd.marbl.mhap.utils.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;

public class FastaData
implements Cloneable {
    private final BufferedReader fileReader;
    private final int offset;
    private String lastLine;
    private AtomicLong numberProcessed;
    private boolean readFullFile;
    private final ConcurrentLinkedQueue<Sequence> sequenceList;
    private static final String[] fastaSuffix = new String[]{"fna", "contigs", "contig", "final", "fasta", "fa"};

    private FastaData(ConcurrentLinkedQueue<Sequence> concurrentLinkedQueue) {
        this.sequenceList = new ConcurrentLinkedQueue<Sequence>(concurrentLinkedQueue);
        this.fileReader = null;
        this.lastLine = null;
        this.readFullFile = true;
        this.numberProcessed = new AtomicLong(this.sequenceList.size());
        this.offset = 0;
    }

    public FastaData(String string, int n) throws IOException {
        try {
            this.fileReader = Utils.getFile(string, fastaSuffix);
        }
        catch (Exception exception) {
            throw new MhapRuntimeException(exception);
        }
        this.offset = n;
        this.lastLine = null;
        this.readFullFile = false;
        this.numberProcessed = new AtomicLong(0L);
        this.sequenceList = new ConcurrentLinkedQueue();
    }

    public synchronized FastaData clone() {
        try {
            this.enqueueFullFile();
        }
        catch (IOException iOException) {
            throw new MhapRuntimeException(iOException);
        }
        return new FastaData(this.sequenceList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence dequeue() throws IOException {
        Sequence sequence;
        ConcurrentLinkedQueue<Sequence> concurrentLinkedQueue = this.sequenceList;
        synchronized (concurrentLinkedQueue) {
            if (this.sequenceList.isEmpty()) {
                this.enqueueNextSequenceInFile();
            }
            sequence = this.sequenceList.poll();
        }
        return sequence;
    }

    public void enqueueFullFile() throws IOException {
        while (this.enqueueNextSequenceInFile()) {
        }
    }

    private boolean enqueueNextSequenceInFile() throws IOException {
        BufferedReader bufferedReader = this.fileReader;
        synchronized (bufferedReader) {
            if (this.readFullFile) {
                return false;
            }
            if (this.lastLine == null) {
                this.lastLine = this.fileReader.readLine();
                if (this.lastLine == null) {
                    this.fileReader.close();
                    this.readFullFile = true;
                    return false;
                }
            }
            if (!this.lastLine.startsWith(">")) {
                throw new MhapRuntimeException("Next sequence does not start with >. Invalid format.");
            }
            String string = null;
            if (SequenceId.STORE_FULL_ID) {
                string = this.lastLine.substring(1).split("[\\s,]+", 2)[0];
            }
            this.lastLine = this.fileReader.readLine();
            StringBuilder stringBuilder = new StringBuilder();
            while (true) {
                if (this.lastLine == null || this.lastLine.startsWith(">")) {
                    SequenceId sequenceId = SequenceId.STORE_FULL_ID ? new SequenceId(this.numberProcessed.intValue() + this.offset + 1, true, string) : new SequenceId(this.numberProcessed.intValue() + this.offset + 1);
                    Sequence sequence = new Sequence(stringBuilder.toString().toUpperCase(Locale.ENGLISH), sequenceId);
                    this.sequenceList.add(sequence);
                    this.numberProcessed.getAndIncrement();
                    if (this.lastLine == null) {
                        this.fileReader.close();
                        this.readFullFile = true;
                    }
                    return true;
                }
                stringBuilder.append(this.lastLine);
                this.lastLine = this.fileReader.readLine();
            }
        }
    }

    public int getNumberProcessed() {
        return this.numberProcessed.intValue();
    }

    public Sequence getSequence(SequenceId sequenceId) {
        if (sequenceId.isForward()) {
            for (Sequence sequence : this.sequenceList) {
                if (!sequence.getId().equals(sequenceId)) continue;
                return sequence;
            }
        }
        sequenceId = sequenceId.complimentId();
        for (Sequence sequence : this.sequenceList) {
            if (!sequence.getId().equals(sequenceId)) continue;
            return sequence.getReverseCompliment();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.sequenceList.isEmpty() && this.readFullFile;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.fileReader.close();
    }
}

