/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.general;

import edu.umd.marbl.mhap.general.MatchResult;
import edu.umd.marbl.mhap.general.SequenceId;
import edu.umd.marbl.mhap.sketch.SequenceSketch;
import edu.umd.marbl.mhap.sketch.SequenceSketchStreamer;
import edu.umd.marbl.mhap.utils.MhapRuntimeException;
import edu.umd.marbl.mhap.utils.ReadBuffer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractMatchSearch {
    private final AtomicLong matchesProcessed;
    protected final int numThreads;
    private final AtomicLong sequencesSearched;
    private final boolean storeResults;
    public static final int NUM_ELEMENTS_PER_OUTPUT = 20000;
    protected static final BufferedWriter STD_OUT_BUFFER = new BufferedWriter(new OutputStreamWriter(System.out), 0x800000);

    public AbstractMatchSearch(int n, boolean bl) {
        this.numThreads = n;
        this.storeResults = bl;
        this.matchesProcessed = new AtomicLong();
        this.sequencesSearched = new AtomicLong();
    }

    protected void addData(final SequenceSketchStreamer sequenceSketchStreamer) {
        ExecutorService executorService = Executors.newFixedThreadPool(this.numThreads);
        final AtomicInteger atomicInteger = new AtomicInteger();
        for (int i = 0; i < this.numThreads; ++i) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        ReadBuffer readBuffer = new ReadBuffer();
                        SequenceSketch sequenceSketch = sequenceSketchStreamer.dequeue(false, readBuffer);
                        while (sequenceSketch != null) {
                            AbstractMatchSearch.this.addSequence(sequenceSketch);
                            int n = atomicInteger.incrementAndGet();
                            if (n % 5000 == 0) {
                                System.err.println("Current # sequences stored: " + n + "...");
                            }
                            sequenceSketch = sequenceSketchStreamer.dequeue(false, readBuffer);
                        }
                    }
                    catch (IOException iOException) {
                        throw new MhapRuntimeException(iOException);
                    }
                }
            };
            executorService.execute(runnable);
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(365L, TimeUnit.DAYS);
        }
        catch (InterruptedException interruptedException) {
            executorService.shutdownNow();
            throw new MhapRuntimeException("Unable to finish all tasks.");
        }
    }

    protected abstract boolean addSequence(SequenceSketch var1);

    public ArrayList<MatchResult> findMatches() {
        ExecutorService executorService = Executors.newFixedThreadPool(this.numThreads);
        final ArrayList<MatchResult> arrayList = new ArrayList<MatchResult>();
        final ConcurrentLinkedQueue<SequenceId> concurrentLinkedQueue = new ConcurrentLinkedQueue<SequenceId>(this.getStoredForwardSequenceIds());
        for (int i = 0; i < this.numThreads; ++i) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ArrayList<MatchResult> arrayList3 = new ArrayList<MatchResult>();
                    SequenceId sequenceId = (SequenceId)concurrentLinkedQueue.poll();
                    while (sequenceId != null) {
                        SequenceSketch sequenceSketch = AbstractMatchSearch.this.getStoredSequenceHash(sequenceId);
                        arrayList3.addAll(AbstractMatchSearch.this.findMatches(sequenceSketch, true));
                        AbstractMatchSearch.this.sequencesSearched.getAndIncrement();
                        sequenceId = (SequenceId)concurrentLinkedQueue.poll();
                        if (sequenceId != null && arrayList3.size() < 20000) continue;
                        AbstractMatchSearch.this.matchesProcessed.getAndAdd(arrayList3.size());
                        if (AbstractMatchSearch.this.storeResults) {
                            ArrayList arrayList2 = arrayList;
                            synchronized (arrayList2) {
                                arrayList.addAll(arrayList3);
                            }
                        } else {
                            AbstractMatchSearch.this.outputResults(arrayList3);
                        }
                        arrayList3.clear();
                    }
                }
            };
            executorService.execute(runnable);
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(365L, TimeUnit.DAYS);
        }
        catch (InterruptedException interruptedException) {
            executorService.shutdownNow();
            throw new MhapRuntimeException("Unable to finish all tasks.");
        }
        this.flushOutput();
        return arrayList;
    }

    protected abstract List<MatchResult> findMatches(SequenceSketch var1, boolean var2);

    public ArrayList<MatchResult> findMatches(final SequenceSketchStreamer sequenceSketchStreamer) throws IOException {
        ExecutorService executorService = Executors.newFixedThreadPool(this.numThreads);
        final ArrayList<MatchResult> arrayList = new ArrayList<MatchResult>();
        for (int i = 0; i < this.numThreads; ++i) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ArrayList<MatchResult> arrayList3 = new ArrayList<MatchResult>();
                    try {
                        ReadBuffer readBuffer = new ReadBuffer();
                        SequenceSketch sequenceSketch = sequenceSketchStreamer.dequeue(true, readBuffer);
                        while (sequenceSketch != null) {
                            arrayList3.addAll(AbstractMatchSearch.this.findMatches(sequenceSketch, false));
                            AbstractMatchSearch.this.sequencesSearched.getAndIncrement();
                            sequenceSketch = sequenceSketchStreamer.dequeue(true, readBuffer);
                            if (sequenceSketch != null && arrayList3.size() < 20000) continue;
                            AbstractMatchSearch.this.matchesProcessed.getAndAdd(arrayList3.size());
                            if (AbstractMatchSearch.this.storeResults) {
                                ArrayList arrayList2 = arrayList;
                                synchronized (arrayList2) {
                                    arrayList.addAll(arrayList3);
                                }
                            } else {
                                AbstractMatchSearch.this.outputResults(arrayList3);
                            }
                            arrayList3.clear();
                        }
                    }
                    catch (IOException iOException) {
                        throw new MhapRuntimeException(iOException);
                    }
                }
            };
            executorService.execute(runnable);
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(365L, TimeUnit.DAYS);
        }
        catch (InterruptedException interruptedException) {
            executorService.shutdownNow();
            throw new MhapRuntimeException("Unable to finish all tasks.");
        }
        this.flushOutput();
        return arrayList;
    }

    protected void flushOutput() {
        try {
            STD_OUT_BUFFER.flush();
        }
        catch (IOException iOException) {
            throw new MhapRuntimeException(iOException);
        }
    }

    public long getMatchesProcessed() {
        return this.matchesProcessed.get();
    }

    public long getNumberSequencesSearched() {
        return this.sequencesSearched.get();
    }

    public abstract List<SequenceId> getStoredForwardSequenceIds();

    public abstract SequenceSketch getStoredSequenceHash(SequenceId var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void outputResults(List<MatchResult> list) {
        if (this.storeResults || list.isEmpty()) {
            return;
        }
        try {
            BufferedWriter bufferedWriter = STD_OUT_BUFFER;
            synchronized (bufferedWriter) {
                for (MatchResult matchResult : list) {
                    STD_OUT_BUFFER.write(matchResult.toString());
                    STD_OUT_BUFFER.newLine();
                }
                STD_OUT_BUFFER.flush();
            }
        }
        catch (IOException iOException) {
            throw new MhapRuntimeException(iOException);
        }
    }

    public abstract int size();
}

