##########################################################################################################
# R script to search for overlaps between meotic recombination ranges found by Strand-seq and Fan et al. #
##########################################################################################################

data <- read.table("SS2FAN_allRecs.csv", header=T, sep=",") #meiotic ranges stored as a bed file (chr start end ID [SS|FAN])
gr <- GRanges(seqnames=data$Chr, IRanges(start=data$Start, end=data$End), ID=data$ID)
gr.list <- split(gr, gr$ID)

overlap.father <- findOverlaps(gr.list[['FAN_father']], gr.list[['SS_father']])
overlap.mother <- findOverlaps(gr.list[['FAN_mother']], gr.list[['SS_mother']])


##Non-overlapping ranges father
gr.list[['FAN_father']][-subjectHits(overlap.father)]
gr.list[['SS_father']][-subjectHits(overlap.father)]

chr5 [171559996, 171650318]  FAN_father
chr5 [171656344, 171814443]  SS_father
Deviation: 6026

##Non-overlapping ranges mother
gr.list[['FAN_mother']][-subjectHits(overlap.mother)]
gr.list[['SS_mother']][-subjectHits(overlap.mother)]

chrX [14073189, 14077601]  FAN_mother
chrX [13472100, 13498213]  SS_mother
Deviation: 574976


##plot overlapping ranges
data <- read.table("SS2FAN_father.csv", header=T, sep=",")
data <- read.table("SS2FAN_mother.csv", header=T, sep=",")

store.plt <- list()
for (i in 1:(nrow(data)/2)) {
	subset <- data[data$IDX==i,]
	gr <- GRanges(seqnames=subset$Chr, IRanges(start=subset$Start, end=subset$End), ID=subset$ID)
	plt <- autoplot(gr, aes(fill = ID)) + scale_fill_manual(values = c("dodgerblue4","goldenrod3")) + theme(legend.position="none")
	fixed(plt) <- TRUE
	store.plt[[length(store.plt)+1]] <- plt
}

tracks(store.plt)

