

library(VariantAnnotation)

scanVcfHeader("Bdistachyon_283.vcf.gz")

vcf=readVcf('Bdistachyon_283.vcf.gz','Bd21Control')
vcf

genos=geno(vcf)$GT
summary.calls=cbind(rowSums(genos=='0/0'),rowSums(genos=='0/1'),rowSums(genos=='1/1'),rowSums(genos=='.'))
colnames(summary.calls)=c('WThom','het','ALThom','ND')

chr2=rep(as.character(rowData(vcf)@seqnames@values),chr)
start=rowData(vcf)@ranges@start
width=rowData(vcf)@ranges@width

out=cbind(chr2,start,width,genos,summary.calls)
write.table(out,'brachy_7geno_snp_calls.txt',sep='\t',row.names=F,quote=F)

###

new=read.delim('brachy_7geno_snp_calls.txt',head=T)
new=cbind(new[,1:2],new[,2],new[,3:ncol(new)])
new.sub=subset(new,new$width==1)
table(new.sub$Bd21control)
write.table(new.sub,'test.snps.bed',sep='\t',row.names=F,quote=F,col.names=F)
head(new.sub)

library(phyclust)
library(ape)
test=ifelse(new.sub[,5:11]=='0/0',0,ifelse(new.sub[,5:11]=='.',NA,ifelse(new.sub[,5:11]=='0/1',NA,1)))
test.sub=test[complete.cases(test),]
colnames(test.sub)=c('Bd1-1','Bd21-3','Bd3-1','Bd30-1','Koz-3','BdTR12c','Bd21')
stree=nj(dist.gene(t(test.sub)))
plotnj(stree,show.tip.label=T,edge.width=1)

new.sub2=subset(new.sub,new.sub$Bd1.1!='0/0')
write.table(new.sub2,'Bd1-1_snps.test.bed',sep='\t',col.names=F,row.names=F,quote=F)
new.sub2=subset(new.sub,new.sub$Bd21.3_r!='0/0')
write.table(new.sub2,'Bd21-3_snps.test.bed',sep='\t',col.names=F,row.names=F,quote=F)
new.sub2=subset(new.sub,new.sub$Bd3.1_r!='0/0')
write.table(new.sub2,'Bd3-1_snps.test.bed',sep='\t',col.names=F,row.names=F,quote=F)
new.sub2=subset(new.sub,new.sub$Bd30.1!='0/0')
write.table(new.sub2,'Bd30-1_snps.test.bed',sep='\t',col.names=F,row.names=F,quote=F)
new.sub2=subset(new.sub,new.sub$Koz.3!='0/0')
write.table(new.sub2,'Koz-3_snps.test.bed',sep='\t',col.names=F,row.names=F,quote=F)
new.sub2=subset(new.sub,new.sub$BdTR12c!='0/0')
write.table(new.sub2,'BdTR12c_snps.test.bed',sep='\t',col.names=F,row.names=F,quote=F)

######################################
```
bedtools intersect -wa -wb -a 1Mb.windows.bed -b Bd1-1_snps.test.bed > Bd1-1.snps.temp
bedtools intersect -wa -wb -a 1Mb.windows.bed -b Bd21-3_snps.test.bed > Bd21-3.snps.temp
bedtools intersect -wa -wb -a 1Mb.windows.bed -b Bd3-1_snps.test.bed > Bd3-1.snps.temp
bedtools intersect -wa -wb -a 1Mb.windows.bed -b Bd30-1_snps.test.bed > Bd30-1.snps.temp
bedtools intersect -wa -wb -a 1Mb.windows.bed -b Koz-3_snps.test.bed > Koz-3.snps.temp
bedtools intersect -wa -wb -a 1Mb.windows.bed -b BdTR12c_snps.test.bed > BdTR12c.snps.temp

bedtools groupby -i Bd1-1.snps.temp -g 1,2,3 -c 10 -o count > Bd1-1.snps.1Mb.count
bedtools groupby -i Bd21-3.snps.temp -g 1,2,3 -c 10 -o count > Bd21-3.snps.1Mb.count
bedtools groupby -i Bd3-1.snps.temp -g 1,2,3 -c 10 -o count > Bd3-1.snps.1Mb.count
bedtools groupby -i Bd30-1.snps.temp -g 1,2,3 -c 10 -o count > Bd30-1.snps.1Mb.count
bedtools groupby -i Koz-3.snps.temp -g 1,2,3 -c 10 -o count > Koz-3.snps.1Mb.count
bedtools groupby -i BdTR12c.snps.temp -g 1,2,3 -c 10 -o count > BdTR12c.snps.1Mb.count

bedtools intersect -wa -wb -a 1Mb.windows.bed -b Bd1-1.CG.dmr.windows.txt.bed.sizeflt.bed > Bd1-1.CG.dmrs.temp
bedtools intersect -wa -wb -a 1Mb.windows.bed -b Bd21-3.CG.dmr.windows.txt.bed.sizeflt.bed > Bd21-3.CG.dmrs.temp
bedtools intersect -wa -wb -a 1Mb.windows.bed -b Bd3-1.CG.dmr.windows.txt.bed.sizeflt.bed > Bd3-1.CG.dmrs.temp
bedtools intersect -wa -wb -a 1Mb.windows.bed -b Bd30-1.CG.dmr.windows.txt.bed.sizeflt.bed > Bd30-1.CG.dmrs.temp
bedtools intersect -wa -wb -a 1Mb.windows.bed -b Koz-3.CG.dmr.windows.txt.bed.sizeflt.bed > Koz-3.CG.dmrs.temp
bedtools intersect -wa -wb -a 1Mb.windows.bed -b BdTR12c.CG.dmr.windows.txt.bed.sizeflt.bed > BdTR12c.CG.dmrs.temp

bedtools groupby -i Bd1-1.CG.dmrs.temp -g 1,2,3 -c 10 -o count > Bd1-1.CG.dmrs.1Mb.count
bedtools groupby -i Bd21-3.CG.dmrs.temp -g 1,2,3 -c 10 -o count > Bd21-3.CG.dmrs.1Mb.count
bedtools groupby -i Bd3-1.CG.dmrs.temp -g 1,2,3 -c 10 -o count > Bd3-1.CG.dmrs.1Mb.count
bedtools groupby -i Bd30-1.CG.dmrs.temp -g 1,2,3 -c 10 -o count > Bd30-1.CG.dmrs.1Mb.count
bedtools groupby -i Koz-3.CG.dmrs.temp -g 1,2,3 -c 10 -o count > Koz-3.CG.dmrs.1Mb.count
bedtools groupby -i BdTR12c.CG.dmrs.temp -g 1,2,3 -c 10 -o count > BdTR12c.CG.dmrs.1Mb.count

bedtools intersect -wa -wb -a 1Mb.windows.bed -b Bd1-1.CHG.dmr.windows.txt.bed.sizeflt.bed > Bd1-1.CHG.dmrs.temp
bedtools intersect -wa -wb -a 1Mb.windows.bed -b Bd21-3.CHG.dmr.windows.txt.bed.sizeflt.bed > Bd21-3.CHG.dmrs.temp
bedtools intersect -wa -wb -a 1Mb.windows.bed -b Bd3-1.CHG.dmr.windows.txt.bed.sizeflt.bed > Bd3-1.CHG.dmrs.temp
bedtools intersect -wa -wb -a 1Mb.windows.bed -b Bd30-1.CHG.dmr.windows.txt.bed.sizeflt.bed > Bd30-1.CHG.dmrs.temp
bedtools intersect -wa -wb -a 1Mb.windows.bed -b Koz-3.CHG.dmr.windows.txt.bed.sizeflt.bed > Koz-3.CHG.dmrs.temp
bedtools intersect -wa -wb -a 1Mb.windows.bed -b BdTR12c.CHG.dmr.windows.txt.bed.sizeflt.bed > BdTR12c.CHG.dmrs.temp

bedtools groupby -i Bd1-1.CHG.dmrs.temp -g 1,2,3 -c 10 -o count > Bd1-1.CHG.dmrs.1Mb.count
bedtools groupby -i Bd21-3.CHG.dmrs.temp -g 1,2,3 -c 10 -o count > Bd21-3.CHG.dmrs.1Mb.count
bedtools groupby -i Bd3-1.CHG.dmrs.temp -g 1,2,3 -c 10 -o count > Bd3-1.CHG.dmrs.1Mb.count
bedtools groupby -i Bd30-1.CHG.dmrs.temp -g 1,2,3 -c 10 -o count > Bd30-1.CHG.dmrs.1Mb.count
bedtools groupby -i Koz-3.CHG.dmrs.temp -g 1,2,3 -c 10 -o count > Koz-3.CHG.dmrs.1Mb.count
bedtools groupby -i BdTR12c.CHG.dmrs.temp -g 1,2,3 -c 10 -o count > BdTR12c.CHG.dmrs.1Mb.count

bedtools intersect -wa -wb -a 1Mb.windows.bed -b Bd1-1.CHH.dmr.windows.txt.bed.sizeflt.bed > Bd1-1.CHH.dmrs.temp
bedtools intersect -wa -wb -a 1Mb.windows.bed -b Bd21-3.CHH.dmr.windows.txt.bed.sizeflt.bed > Bd21-3.CHH.dmrs.temp
bedtools intersect -wa -wb -a 1Mb.windows.bed -b Bd3-1.CHH.dmr.windows.txt.bed.sizeflt.bed > Bd3-1.CHH.dmrs.temp
bedtools intersect -wa -wb -a 1Mb.windows.bed -b Bd30-1.CHH.dmr.windows.txt.bed.sizeflt.bed > Bd30-1.CHH.dmrs.temp
bedtools intersect -wa -wb -a 1Mb.windows.bed -b Koz-3.CHH.dmr.windows.txt.bed.sizeflt.bed > Koz-3.CHH.dmrs.temp
bedtools intersect -wa -wb -a 1Mb.windows.bed -b BdTR12c.CHH.dmr.windows.txt.bed.sizeflt.bed > BdTR12c.CHH.dmrs.temp

bedtools groupby -i Bd1-1.CHH.dmrs.temp -g 1,2,3 -c 10 -o count > Bd1-1.CHH.dmrs.1Mb.count
bedtools groupby -i Bd21-3.CHH.dmrs.temp -g 1,2,3 -c 10 -o count > Bd21-3.CHH.dmrs.1Mb.count
bedtools groupby -i Bd3-1.CHH.dmrs.temp -g 1,2,3 -c 10 -o count > Bd3-1.CHH.dmrs.1Mb.count
bedtools groupby -i Bd30-1.CHH.dmrs.temp -g 1,2,3 -c 10 -o count > Bd30-1.CHH.dmrs.1Mb.count
bedtools groupby -i Koz-3.CHH.dmrs.temp -g 1,2,3 -c 10 -o count > Koz-3.CHH.dmrs.1Mb.count
bedtools groupby -i BdTR12c.CHH.dmrs.temp -g 1,2,3 -c 10 -o count > BdTR12c.CHH.dmrs.1Mb.count

#REPLICATE DSS DMRS

bedtools intersect -wa -wb -a 1Mb.windows.bed -b dmr_Bd21vs1_CG.txt.bed.sorted.bed > Bd1-1.CG.dss.dmrs.temp
bedtools intersect -wa -wb -a 1Mb.windows.bed -b dmr_Bd21vs3_CG.txt.bed.sorted.bed > Bd3-1.CG.dss.dmrs.temp
bedtools groupby -i Bd1-1.CG.dss.dmrs.temp -g 1,2,3 -c 4 -o count > Bd1-1.CG.dss.dmrs.1Mb.count
bedtools groupby -i Bd3-1.CG.dss.dmrs.temp -g 1,2,3 -c 4 -o count > Bd3-1.CG.dss.dmrs.1Mb.count

bedtools intersect -wa -wb -a 1Mb.windows.bed -b dmr_Bd21vs1_CHG.txt.bed.sorted.bed > Bd1-1.CHG.dss.dmrs.temp
bedtools intersect -wa -wb -a 1Mb.windows.bed -b dmr_Bd21vs3_CHG.txt.bed.sorted.bed > Bd3-1.CHG.dss.dmrs.temp
bedtools groupby -i Bd1-1.CHG.dss.dmrs.temp -g 1,2,3 -c 4 -o count > Bd1-1.CHG.dss.dmrs.1Mb.count
bedtools groupby -i Bd3-1.CHG.dss.dmrs.temp -g 1,2,3 -c 4 -o count > Bd3-1.CHG.dss.dmrs.1Mb.count

bedtools intersect -wa -wb -a 1Mb.windows.bed -b dmr_Bd21vs1_CHH.txt.bed.sorted.bed > Bd1-1.CHH.dss.dmrs.temp
bedtools intersect -wa -wb -a 1Mb.windows.bed -b dmr_Bd21vs3_CHH.txt.bed.sorted.bed > Bd3-1.CHH.dss.dmrs.temp
bedtools groupby -i Bd1-1.CHH.dss.dmrs.temp -g 1,2,3 -c 4 -o count > Bd1-1.CHH.dss.dmrs.1Mb.count
bedtools groupby -i Bd3-1.CHH.dss.dmrs.temp -g 1,2,3 -c 4 -o count > Bd3-1.CHH.dss.dmrs.1Mb.count


```
bd1.1.snps=read.delim('Bd1-1.snps.1Mb.count',head=F)
bd21.3.snps=read.delim('Bd21-3.snps.1Mb.count',head=F)
bd3.1.snps=read.delim('Bd3-1.snps.1Mb.count',head=F)
bd30.1.snps=read.delim('Bd30-1.snps.1Mb.count',head=F)
koz3.snps=read.delim('Koz-3.snps.1Mb.count',head=F)
bdtr12c.snps=read.delim('BdTR12c.snps.1Mb.count',head=F)

bd1.1.CG.dmrs=read.delim('Bd1-1.CG.dmrs.1Mb.count',head=F)
bd21.3.CG.dmrs=read.delim('Bd21-3.CG.dmrs.1Mb.count',head=F)
bd3.1.CG.dmrs=read.delim('Bd3-1.CG.dmrs.1Mb.count',head=F)
bd30.1.CG.dmrs=read.delim('Bd30-1.CG.dmrs.1Mb.count',head=F)
koz3.CG.dmrs=read.delim('Koz-3.CG.dmrs.1Mb.count',head=F)
bdtr12c.CG.dmrs=read.delim('BdTR12c.CG.dmrs.1Mb.count',head=F)

bd1.1.CHG.dmrs=read.delim('Bd1-1.CHG.dmrs.1Mb.count',head=F)
bd21.3.CHG.dmrs=read.delim('Bd21-3.CHG.dmrs.1Mb.count',head=F)
bd3.1.CHG.dmrs=read.delim('Bd3-1.CHG.dmrs.1Mb.count',head=F)
bd30.1.CHG.dmrs=read.delim('Bd30-1.CHG.dmrs.1Mb.count',head=F)
koz3.CHG.dmrs=read.delim('Koz-3.CHG.dmrs.1Mb.count',head=F)
bdtr12c.CHG.dmrs=read.delim('BdTR12c.CHG.dmrs.1Mb.count',head=F)

bd1.1.CHH.dmrs=read.delim('Bd1-1.CHH.dmrs.1Mb.count',head=F)
bd21.3.CHH.dmrs=read.delim('Bd21-3.CHH.dmrs.1Mb.count',head=F)
bd3.1.CHH.dmrs=read.delim('Bd3-1.CHH.dmrs.1Mb.count',head=F)
bd30.1.CHH.dmrs=read.delim('Bd30-1.CHH.dmrs.1Mb.count',head=F)
koz3.CHH.dmrs=read.delim('Koz-3.CHH.dmrs.1Mb.count',head=F)
bdtr12c.CHH.dmrs=read.delim('BdTR12c.CHH.dmrs.1Mb.count',head=F)

bd1.1.CG.dss=read.delim('Bd1-1.CG.dss.dmrs.1Mb.count',head=F)
bd1.1.CHG.dss=read.delim('Bd1-1.CHG.dss.dmrs.1Mb.count',head=F)
bd1.1.CHH.dss=read.delim('Bd1-1.CHH.dss.dmrs.1Mb.count',head=F)

bd3.1.CG.dss=read.delim('Bd1-1.CG.dss.dmrs.1Mb.count',head=F)
bd3.1.CHG.dss=read.delim('Bd1-1.CHG.dss.dmrs.1Mb.count',head=F)
bd3.1.CHH.dss=read.delim('Bd1-1.CHH.dss.dmrs.1Mb.count',head=F)


bd1.1.CG.merged=merge(bd1.1.CG.dmrs, bd1.1.snps,by=c('V1','V2','V3'))
bd21.3.CG.merged=merge(bd21.3.CG.dmrs, bd21.3.snps,by=c('V1','V2','V3'))
bd3.1.CG.merged=merge(bd3.1.CG.dmrs, bd3.1.snps,by=c('V1','V2','V3'))
bd30.1.CG.merged=merge(bd30.1.CG.dmrs, bd30.1.snps,by=c('V1','V2','V3'))
koz3.CG.merged=merge(koz3.CG.dmrs, koz3.snps,by=c('V1','V2','V3'))
bdtr12c.CG.merged=merge(bdtr12c.CG.dmrs, bdtr12c.snps,by=c('V1','V2','V3'))

bd1.1.CHG.merged=merge(bd1.1.CHG.dmrs, bd1.1.snps,by=c('V1','V2','V3'))
bd21.3.CHG.merged=merge(bd21.3.CHG.dmrs, bd21.3.snps,by=c('V1','V2','V3'))
bd3.1.CHG.merged=merge(bd3.1.CHG.dmrs, bd3.1.snps,by=c('V1','V2','V3'))
bd30.1.CHG.merged=merge(bd30.1.CHG.dmrs, bd30.1.snps,by=c('V1','V2','V3'))
koz3.CHG.merged=merge(koz3.CHG.dmrs, koz3.snps,by=c('V1','V2','V3'))
bdtr12c.CHG.merged=merge(bdtr12c.CHG.dmrs, bdtr12c.snps,by=c('V1','V2','V3'))

bd1.1.CHH.merged=merge(bd1.1.CHH.dmrs, bd1.1.snps,by=c('V1','V2','V3'))
bd21.3.CHH.merged=merge(bd21.3.CHH.dmrs, bd21.3.snps,by=c('V1','V2','V3'))
bd3.1.CHH.merged=merge(bd3.1.CHH.dmrs, bd3.1.snps,by=c('V1','V2','V3'))
bd30.1.CHH.merged=merge(bd30.1.CHH.dmrs, bd30.1.snps,by=c('V1','V2','V3'))
koz3.CHH.merged=merge(koz3.CHH.dmrs, koz3.snps,by=c('V1','V2','V3'))
bdtr12c.CHH.merged=merge(bdtr12c.CHH.dmrs, bdtr12c.snps,by=c('V1','V2','V3'))

bd1.1.CG.dss.merged=merge(bd1.1.CG.dss,bd1.1.snps,by=c('V1','V2','V3'))
bd1.1.CHG.dss.merged=merge(bd1.1.CHG.dss,bd1.1.snps,by=c('V1','V2','V3'))
bd1.1.CHH.dss.merged=merge(bd1.1.CHH.dss,bd1.1.snps,by=c('V1','V2','V3'))

bd3.1.CG.dss.merged=merge(bd3.1.CG.dss,bd3.1.snps,by=c('V1','V2','V3'))
bd3.1.CHG.dss.merged=merge(bd3.1.CHG.dss,bd3.1.snps,by=c('V1','V2','V3'))
bd3.1.CHH.dss.merged=merge(bd3.1.CHH.dss,bd3.1.snps,by=c('V1','V2','V3'))



pdf('DMRs_vs_SNPs_1MBwindows.pdf',width=14,height=8)
#CG DMRS vs SNPS
par(mfrow=c(2,3))
plot(bd1.1.CG.merged[,5],bd1.1.CG.merged[,4],xlab='SNPs/Mb',ylab='CG.dmrs/Mb',main='Bd1-1')
abline(lm(bd1.1.CG.merged[,4] ~ bd1.1.CG.merged[,5]),col='red')
cor(bd1.1.CG.merged[,4],bd1.1.CG.merged[,5])

plot(bd21.3.CG.merged[,5],bd21.3.CG.merged[,4],xlab='SNPs/Mb',ylab='CG.dmrs/Mb',main='Bd21-3')
abline(lm(bd21.3.CG.merged[,4] ~ bd21.3.CG.merged[,5]),col='red')
cor(bd21.3.CG.merged[,4],bd21.3.CG.merged[,5])

plot(bd3.1.CG.merged[,5],bd3.1.CG.merged[,4],xlab='SNPs/Mb',ylab='CG.dmrs/Mb',main='Bd3-1')
abline(lm(bd3.1.CG.merged[,4] ~ bd3.1.CG.merged[,5]),col='red')
cor(bd3.1.CG.merged[,4],bd3.1.CG.merged[,5])

plot(bd30.1.CG.merged[,5],bd30.1.CG.merged[,4],xlab='SNPs/Mb',ylab='CG.dmrs/Mb',main='Bd30-1')
abline(lm(bd30.1.CG.merged[,4] ~ bd30.1.CG.merged[,5]),col='red')
cor(bd30.1.CG.merged[,4],bd30.1.CG.merged[,5])

plot(koz3.CG.merged[,5],koz3.CG.merged[,4],xlab='SNPs/Mb',ylab='CG.dmrs/Mb',main='Koz-3')
abline(lm(koz3.CG.merged[,4] ~ koz3.CG.merged[,5]),col='red')
cor(koz3.CG.merged[,4],koz3.CG.merged[,5])

plot(bdtr12c.CG.merged[,5],bdtr12c.CG.merged[,4],xlab='SNPs/Mb',ylab='CG.dmrs/Mb',main='BdTR12c')
abline(lm(bdtr12c.CG.merged[,4] ~ bdtr12c.CG.merged[,5]),col='red')
cor(bdtr12c.CG.merged[,4],bdtr12c.CG.merged[,5])

par(mfrow=c(1,1))

all.CG.merged=rbind(bd1.1.CG.merged,bd21.3.CG.merged,bd3.1.CG.merged,bd30.1.CG.merged,koz3.CG.merged,bdtr12c.CG.merged)

plot(all.CG.merged[,5],all.CG.merged[,4],xlab='SNPs/Mb',ylab='CG.DMRs/Mb',main='All samples')
abline(lm(all.CG.merged[,4] ~ all.CG.merged[,5]),col='red')
cor(all.CG.merged[,4],all.CG.merged[,5])

plot(bd1.1.CG.dss.merged[,5],bd1.1.CG.dss.merged[,4],xlab='SNPs/Mb',ylab='CG.dmrs/Mb',main='Bd1-1 replicates via DSS')
abline(lm(bd1.1.CG.dss.merged[,4] ~ bd1.1.CG.dss.merged[,5]),col='red')
cor(bd1.1.CG.dss.merged[,4],bd1.1.CG.dss.merged[,5])

plot(bd3.1.CG.dss.merged[,5],bd3.1.CG.dss.merged[,4],xlab='SNPs/Mb',ylab='CG.dmrs/Mb',main='Bd3-1 replicates via DSS')
abline(lm(bd3.1.CG.dss.merged[,4] ~ bd3.1.CG.dss.merged[,5]),col='red')
cor(bd3.1.CG.dss.merged[,4],bd3.1.CG.dss.merged[,5])


#CHG DMRS vs SNPS
par(mfrow=c(2,3))
plot(bd1.1.CHG.merged[,5],bd1.1.CHG.merged[,4],xlab='SNPs/Mb',ylab='CHG.dmrs/Mb',main='Bd1-1')
abline(lm(bd1.1.CHG.merged[,4] ~ bd1.1.CHG.merged[,5]),col='red')
cor(bd1.1.CHG.merged[,4],bd1.1.CHG.merged[,5])

plot(bd21.3.CHG.merged[,5],bd21.3.CHG.merged[,4],xlab='SNPs/Mb',ylab='CHG.dmrs/Mb',main='Bd21-3')
abline(lm(bd21.3.CHG.merged[,4] ~ bd21.3.CHG.merged[,5]),col='red')
cor(bd21.3.CHG.merged[,4],bd21.3.CHG.merged[,5])

plot(bd3.1.CHG.merged[,5],bd3.1.CHG.merged[,4],xlab='SNPs/Mb',ylab='CHG.dmrs/Mb',main='Bd3-1')
abline(lm(bd3.1.CHG.merged[,4] ~ bd3.1.CHG.merged[,5]),col='red')
cor(bd3.1.CHG.merged[,4],bd3.1.CHG.merged[,5])

plot(bd30.1.CHG.merged[,5],bd30.1.CHG.merged[,4],xlab='SNPs/Mb',ylab='CHG.dmrs/Mb',main='Bd30-1')
abline(lm(bd30.1.CHG.merged[,4] ~ bd30.1.CHG.merged[,5]),col='red')
cor(bd30.1.CHG.merged[,4],bd30.1.CHG.merged[,5])

plot(koz3.CHG.merged[,5],koz3.CHG.merged[,4],xlab='SNPs/Mb',ylab='CHG.dmrs/Mb',main='Koz-3')
abline(lm(koz3.CHG.merged[,4] ~ koz3.CHG.merged[,5]),col='red')
cor(koz3.CHG.merged[,4],koz3.CHG.merged[,5])

plot(bdtr12c.CHG.merged[,5],bdtr12c.CHG.merged[,4],xlab='SNPs/Mb',ylab='CHG.dmrs/Mb',main='BdTR12c')
abline(lm(bdtr12c.CHG.merged[,4] ~ bdtr12c.CHG.merged[,5]),col='red')
cor(bdtr12c.CHG.merged[,4],bdtr12c.CHG.merged[,5])

par(mfrow=c(1,1))

all.CHG.merged=rbind(bd1.1.CHG.merged,bd21.3.CHG.merged,bd3.1.CHG.merged,bd30.1.CHG.merged,koz3.CHG.merged,bdtr12c.CHG.merged)

plot(all.CHG.merged[,5],all.CHG.merged[,4],xlab='SNPs/Mb',ylab='CHG.DMRs/Mb',main='All samples')
abline(lm(all.CHG.merged[,4] ~ all.CHG.merged[,5]),col='red')
cor(all.CHG.merged[,4],all.CHG.merged[,5])

plot(bd1.1.CHG.dss.merged[,5],bd1.1.CHG.dss.merged[,4],xlab='SNPs/Mb',ylab='CHG.dmrs/Mb',main='Bd1-1 replicates via DSS')
abline(lm(bd1.1.CHG.dss.merged[,4] ~ bd1.1.CHG.dss.merged[,5]),col='red')
cor(bd1.1.CHG.dss.merged[,4],bd1.1.CHG.dss.merged[,5])

plot(bd3.1.CHG.dss.merged[,5],bd3.1.CHG.dss.merged[,4],xlab='SNPs/Mb',ylab='CHG.dmrs/Mb',main='Bd3-1 replicates via DSS')
abline(lm(bd3.1.CHG.dss.merged[,4] ~ bd3.1.CHG.dss.merged[,5]),col='red')
cor(bd3.1.CHG.dss.merged[,4],bd3.1.CHG.dss.merged[,5])



#CHH DMRS vs SNPS
par(mfrow=c(2,3))
plot(bd1.1.CHH.merged[,5],bd1.1.CHH.merged[,4],xlab='SNPs/Mb',ylab='CHH.dmrs/Mb',main='Bd1-1')
abline(lm(bd1.1.CHH.merged[,4] ~ bd1.1.CHH.merged[,5]),col='red')
cor(bd1.1.CHH.merged[,4],bd1.1.CHH.merged[,5])

plot(bd21.3.CHH.merged[,5],bd21.3.CHH.merged[,4],xlab='SNPs/Mb',ylab='CHH.dmrs/Mb',main='Bd21-3')
abline(lm(bd21.3.CHH.merged[,4] ~ bd21.3.CHH.merged[,5]),col='red')
cor(bd21.3.CHH.merged[,4],bd21.3.CHH.merged[,5])

plot(bd3.1.CHH.merged[,5],bd3.1.CHH.merged[,4],xlab='SNPs/Mb',ylab='CHH.dmrs/Mb',main='Bd3-1')
abline(lm(bd3.1.CHH.merged[,4] ~ bd3.1.CHH.merged[,5]),col='red')
cor(bd3.1.CHH.merged[,4],bd3.1.CHH.merged[,5])

plot(bd30.1.CHH.merged[,5],bd30.1.CHH.merged[,4],xlab='SNPs/Mb',ylab='CHH.dmrs/Mb',main='Bd30-1')
abline(lm(bd30.1.CHH.merged[,4] ~ bd30.1.CHH.merged[,5]),col='red')
cor(bd30.1.CHH.merged[,4],bd30.1.CHH.merged[,5])

plot(koz3.CHH.merged[,5],koz3.CHH.merged[,4],xlab='SNPs/Mb',ylab='CHH.dmrs/Mb',main='Koz-3')
abline(lm(koz3.CHH.merged[,4] ~ koz3.CHH.merged[,5]),col='red')
cor(koz3.CHH.merged[,4],koz3.CHH.merged[,5])

plot(bdtr12c.CHH.merged[,5],bdtr12c.CHH.merged[,4],xlab='SNPs/Mb',ylab='CHH.dmrs/Mb',main='BdTR12c')
abline(lm(bdtr12c.CHH.merged[,4] ~ bdtr12c.CHH.merged[,5]),col='red')
cor(bdtr12c.CHH.merged[,4],bdtr12c.CHH.merged[,5])

par(mfrow=c(1,1))

all.CHH.merged=rbind(bd1.1.CHH.merged,bd21.3.CHH.merged,bd3.1.CHH.merged,bd30.1.CHH.merged,koz3.CHH.merged,bdtr12c.CHH.merged)

plot(all.CHH.merged[,5],all.CHH.merged[,4],xlab='SNPs/Mb',ylab='CHH.DMRs/Mb',main='All samples')
abline(lm(all.CHH.merged[,4] ~ all.CHH.merged[,5]),col='red')
cor(all.CHH.merged[,4],all.CHH.merged[,5])

plot(bd1.1.CHH.dss.merged[,5],bd1.1.CHH.dss.merged[,4],xlab='SNPs/Mb',ylab='CHH.dmrs/Mb',main='Bd1-1 replicates via DSS')
abline(lm(bd1.1.CHH.dss.merged[,4] ~ bd1.1.CHH.dss.merged[,5]),col='red')
cor(bd1.1.CHH.dss.merged[,4],bd1.1.CHH.dss.merged[,5])

plot(bd3.1.CHH.dss.merged[,5],bd3.1.CHH.dss.merged[,4],xlab='SNPs/Mb',ylab='CHH.dmrs/Mb',main='Bd3-1 replicates via DSS')
abline(lm(bd3.1.CHH.dss.merged[,4] ~ bd3.1.CHH.dss.merged[,5]),col='red')
cor(bd3.1.CHH.dss.merged[,4],bd3.1.CHH.dss.merged[,5])




```
bedtools intersect -wa -wb -a 5Mb.windows.bed -b Bd1-1_snps.test.bed > Bd1-1.snps.temp
bedtools intersect -wa -wb -a 5Mb.windows.bed -b Bd21-3_snps.test.bed > Bd21-3.snps.temp
bedtools intersect -wa -wb -a 5Mb.windows.bed -b Bd3-1_snps.test.bed > Bd3-1.snps.temp
bedtools intersect -wa -wb -a 5Mb.windows.bed -b Bd30-1_snps.test.bed > Bd30-1.snps.temp
bedtools intersect -wa -wb -a 5Mb.windows.bed -b Koz-3_snps.test.bed > Koz-3.snps.temp
bedtools intersect -wa -wb -a 5Mb.windows.bed -b BdTR12c_snps.test.bed > BdTR12c.snps.temp

bedtools groupby -i Bd1-1.snps.temp -g 1,2,3 -c 10 -o count > Bd1-1.snps.5Mb.count
bedtools groupby -i Bd21-3.snps.temp -g 1,2,3 -c 10 -o count > Bd21-3.snps.5Mb.count
bedtools groupby -i Bd3-1.snps.temp -g 1,2,3 -c 10 -o count > Bd3-1.snps.5Mb.count
bedtools groupby -i Bd30-1.snps.temp -g 1,2,3 -c 10 -o count > Bd30-1.snps.5Mb.count
bedtools groupby -i Koz-3.snps.temp -g 1,2,3 -c 10 -o count > Koz-3.snps.5Mb.count
bedtools groupby -i BdTR12c.snps.temp -g 1,2,3 -c 10 -o count > BdTR12c.snps.5Mb.count

bedtools intersect -wa -wb -a 5Mb.windows.bed -b Bd1-1.CHH.dmr.windows.txt.bed.sizeflt.bed > Bd1-1.CHH.dmrs.temp
bedtools intersect -wa -wb -a 5Mb.windows.bed -b Bd21-3.CHH.dmr.windows.txt.bed.sizeflt.bed > Bd21-3.CHH.dmrs.temp
bedtools intersect -wa -wb -a 5Mb.windows.bed -b Bd3-1.CHH.dmr.windows.txt.bed.sizeflt.bed > Bd3-1.CHH.dmrs.temp
bedtools intersect -wa -wb -a 5Mb.windows.bed -b Bd30-1.CHH.dmr.windows.txt.bed.sizeflt.bed > Bd30-1.CHH.dmrs.temp
bedtools intersect -wa -wb -a 5Mb.windows.bed -b Koz-3.CHH.dmr.windows.txt.bed.sizeflt.bed > Koz-3.CHH.dmrs.temp
bedtools intersect -wa -wb -a 5Mb.windows.bed -b BdTR12c.CHH.dmr.windows.txt.bed.sizeflt.bed > BdTR12c.CHH.dmrs.temp

bedtools groupby -i Bd1-1.CHH.dmrs.temp -g 1,2,3 -c 10 -o count > Bd1-1.CHH.dmrs.5Mb.count
bedtools groupby -i Bd21-3.CHH.dmrs.temp -g 1,2,3 -c 10 -o count > Bd21-3.CHH.dmrs.5Mb.count
bedtools groupby -i Bd3-1.CHH.dmrs.temp -g 1,2,3 -c 10 -o count > Bd3-1.CHH.dmrs.5Mb.count
bedtools groupby -i Bd30-1.CHH.dmrs.temp -g 1,2,3 -c 10 -o count > Bd30-1.CHH.dmrs.5Mb.count
bedtools groupby -i Koz-3.CHH.dmrs.temp -g 1,2,3 -c 10 -o count > Koz-3.CHH.dmrs.5Mb.count
bedtools groupby -i BdTR12c.CHH.dmrs.temp -g 1,2,3 -c 10 -o count > BdTR12c.CHH.dmrs.5Mb.count

bedtools intersect -wa -wb -a 5Mb.windows.bed -b dmr_Bd21vs1_CHH.txt.bed.sorted.bed > Bd1-1.CHH.dss.dmrs.temp
bedtools intersect -wa -wb -a 5Mb.windows.bed -b dmr_Bd21vs3_CHH.txt.bed.sorted.bed > Bd3-1.CHH.dss.dmrs.temp
bedtools groupby -i Bd1-1.CHH.dss.dmrs.temp -g 1,2,3 -c 4 -o count > Bd1-1.CHH.dss.dmrs.5Mb.count
bedtools groupby -i Bd3-1.CHH.dss.dmrs.temp -g 1,2,3 -c 4 -o count > Bd3-1.CHH.dss.dmrs.5Mb.count

```

bd1.1.snps=read.delim('Bd1-1.snps.5Mb.count',head=F)
bd21.3.snps=read.delim('Bd21-3.snps.5Mb.count',head=F)
bd3.1.snps=read.delim('Bd3-1.snps.5Mb.count',head=F)
bd30.1.snps=read.delim('Bd30-1.snps.5Mb.count',head=F)
koz3.snps=read.delim('Koz-3.snps.5Mb.count',head=F)
bdtr12c.snps=read.delim('BdTR12c.snps.5Mb.count',head=F)

bd1.1.CHH.dmrs=read.delim('Bd1-1.CHH.dmrs.5Mb.count',head=F)
bd21.3.CHH.dmrs=read.delim('Bd21-3.CHH.dmrs.5Mb.count',head=F)
bd3.1.CHH.dmrs=read.delim('Bd3-1.CHH.dmrs.5Mb.count',head=F)
bd30.1.CHH.dmrs=read.delim('Bd30-1.CHH.dmrs.5Mb.count',head=F)
koz3.CHH.dmrs=read.delim('Koz-3.CHH.dmrs.5Mb.count',head=F)
bdtr12c.CHH.dmrs=read.delim('BdTR12c.CHH.dmrs.5Mb.count',head=F)

bd1.1.CHH.merged=merge(bd1.1.CHH.dmrs, bd1.1.snps,by=c('V1','V2','V3'))
bd21.3.CHH.merged=merge(bd21.3.CHH.dmrs, bd21.3.snps,by=c('V1','V2','V3'))
bd3.1.CHH.merged=merge(bd3.1.CHH.dmrs, bd3.1.snps,by=c('V1','V2','V3'))
bd30.1.CHH.merged=merge(bd30.1.CHH.dmrs, bd30.1.snps,by=c('V1','V2','V3'))
koz3.CHH.merged=merge(koz3.CHH.dmrs, koz3.snps,by=c('V1','V2','V3'))
bdtr12c.CHH.merged=merge(bdtr12c.CHH.dmrs, bdtr12c.snps,by=c('V1','V2','V3'))


bd1.1.CHH.dss=read.delim('Bd1-1.CHH.dss.dmrs.5Mb.count',head=F)
bd3.1.CHH.dss=read.delim('Bd1-1.CHH.dss.dmrs.5Mb.count',head=F)
bd1.1.CHH.dss.merged=merge(bd1.1.CHH.dss,bd1.1.snps,by=c('V1','V2','V3'))
bd3.1.CHH.dss.merged=merge(bd3.1.CHH.dss,bd3.1.snps,by=c('V1','V2','V3'))

#CHH DMRS vs SNPS
par(mfrow=c(2,3))
plot(bd1.1.CHH.merged[,5],bd1.1.CHH.merged[,4],xlab='SNPs/5Mb',ylab='CHH.dmrs/5Mb',main='Bd1-1')
abline(lm(bd1.1.CHH.merged[,4] ~ bd1.1.CHH.merged[,5]),col='red')
cor(bd1.1.CHH.merged[,4],bd1.1.CHH.merged[,5])

plot(bd21.3.CHH.merged[,5],bd21.3.CHH.merged[,4],xlab='SNPs/5Mb',ylab='CHH.dmrs/5Mb',main='Bd21-3')
abline(lm(bd21.3.CHH.merged[,4] ~ bd21.3.CHH.merged[,5]),col='red')
cor(bd21.3.CHH.merged[,4],bd21.3.CHH.merged[,5])

plot(bd3.1.CHH.merged[,5],bd3.1.CHH.merged[,4],xlab='SNPs/5Mb',ylab='CHH.dmrs/5Mb',main='Bd3-1')
abline(lm(bd3.1.CHH.merged[,4] ~ bd3.1.CHH.merged[,5]),col='red')
cor(bd3.1.CHH.merged[,4],bd3.1.CHH.merged[,5])

plot(bd30.1.CHH.merged[,5],bd30.1.CHH.merged[,4],xlab='SNPs/5Mb',ylab='CHH.dmrs/5Mb',main='Bd30-1')
abline(lm(bd30.1.CHH.merged[,4] ~ bd30.1.CHH.merged[,5]),col='red')
cor(bd30.1.CHH.merged[,4],bd30.1.CHH.merged[,5])

plot(koz3.CHH.merged[,5],koz3.CHH.merged[,4],xlab='SNPs/5Mb',ylab='CHH.dmrs/5Mb',main='Koz-3')
abline(lm(koz3.CHH.merged[,4] ~ koz3.CHH.merged[,5]),col='red')
cor(koz3.CHH.merged[,4],koz3.CHH.merged[,5])

plot(bdtr12c.CHH.merged[,5],bdtr12c.CHH.merged[,4],xlab='SNPs/5Mb',ylab='CHH.dmrs/5Mb',main='BdTR12c')
abline(lm(bdtr12c.CHH.merged[,4] ~ bdtr12c.CHH.merged[,5]),col='red')
cor(bdtr12c.CHH.merged[,4],bdtr12c.CHH.merged[,5])

par(mfrow=c(1,1))

all.CHH.merged=rbind(bd1.1.CHH.merged,bd21.3.CHH.merged,bd3.1.CHH.merged,bd30.1.CHH.merged,koz3.CHH.merged,bdtr12c.CHH.merged)

plot(all.CHH.merged[,5],all.CHH.merged[,4],xlab='SNPs/5Mb',ylab='CHH.DMRs/5Mb',main='All samples')
abline(lm(all.CHH.merged[,4] ~ all.CHH.merged[,5]),col='red')
cor(all.CHH.merged[,4],all.CHH.merged[,5])

plot(bd1.1.CHH.dss.merged[,5],bd1.1.CHH.dss.merged[,4],xlab='SNPs/Mb',ylab='CHH.dmrs/5Mb',main='Bd1-1 replicates via DSS')
abline(lm(bd1.1.CHH.dss.merged[,4] ~ bd1.1.CHH.dss.merged[,5]),col='red')
cor(bd1.1.CHH.dss.merged[,4],bd1.1.CHH.dss.merged[,5])

plot(bd3.1.CHH.dss.merged[,5],bd3.1.CHH.dss.merged[,4],xlab='SNPs/Mb',ylab='CHH.dmrs/5Mb',main='Bd3-1 replicates via DSS')
abline(lm(bd3.1.CHH.dss.merged[,4] ~ bd3.1.CHH.dss.merged[,5]),col='red')
cor(bd3.1.CHH.dss.merged[,4],bd3.1.CHH.dss.merged[,5])


dev.off()