/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import hep.aida.IAxis;
import hep.aida.IHistogram1D;
import hep.aida.ref.AbstractHistogram1D;
import hep.aida.ref.FixedAxis;
import hep.aida.ref.VariableAxis;

public class Histogram1D
extends AbstractHistogram1D
implements IHistogram1D {
    private double[] errors;
    private double[] heights;
    private int[] entries;
    private int nEntry;
    private double sumWeight;
    private double sumWeightSquared;
    private double mean;
    private double rms;

    public Histogram1D(String string, double[] dArray) {
        this(string, new VariableAxis(dArray));
    }

    public Histogram1D(String string, int n, double d, double d2) {
        this(string, new FixedAxis(n, d, d2));
    }

    public Histogram1D(String string, IAxis iAxis) {
        super(string);
        this.xAxis = iAxis;
        int n = iAxis.bins();
        this.entries = new int[n + 2];
        this.heights = new double[n + 2];
        this.errors = new double[n + 2];
    }

    @Override
    public int allEntries() {
        return this.nEntry;
    }

    @Override
    public int binEntries(int n) {
        return this.entries[this.map(n)];
    }

    @Override
    public double binError(int n) {
        return Math.sqrt(this.errors[this.map(n)]);
    }

    @Override
    public double binHeight(int n) {
        return this.heights[this.map(n)];
    }

    @Override
    public double equivalentBinEntries() {
        return this.sumWeight * this.sumWeight / this.sumWeightSquared;
    }

    @Override
    public void fill(double d) {
        int n;
        int n2 = n = this.map(this.xAxis.coordToIndex(d));
        this.entries[n2] = this.entries[n2] + 1;
        int n3 = n;
        this.heights[n3] = this.heights[n3] + 1.0;
        int n4 = n;
        this.errors[n4] = this.errors[n4] + 1.0;
        ++this.nEntry;
        this.sumWeight += 1.0;
        this.sumWeightSquared += 1.0;
        this.mean += d;
        this.rms += d * d;
    }

    @Override
    public void fill(double d, double d2) {
        int n;
        int n2 = n = this.map(this.xAxis.coordToIndex(d));
        this.entries[n2] = this.entries[n2] + 1;
        int n3 = n;
        this.heights[n3] = this.heights[n3] + d2;
        int n4 = n;
        this.errors[n4] = this.errors[n4] + d2 * d2;
        ++this.nEntry;
        this.sumWeight += d2;
        this.sumWeightSquared += d2 * d2;
        this.mean += d * d2;
        this.rms += d * d2 * d2;
    }

    @Override
    public double mean() {
        return this.mean / this.sumWeight;
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = 0;
            this.heights[i] = 0.0;
            this.errors[i] = 0.0;
        }
        this.nEntry = 0;
        this.sumWeight = 0.0;
        this.sumWeightSquared = 0.0;
        this.mean = 0.0;
        this.rms = 0.0;
    }

    @Override
    public double rms() {
        return Math.sqrt(this.rms / this.sumWeight - this.mean * this.mean / this.sumWeight / this.sumWeight);
    }

    void setContents(int[] nArray, double[] dArray, double[] dArray2) {
        this.entries = nArray;
        this.heights = dArray;
        this.errors = dArray2;
        for (int i = 0; i < nArray.length; ++i) {
            this.nEntry += nArray[i];
            this.sumWeight += dArray[i];
        }
        this.sumWeightSquared = Double.NaN;
        this.mean = Double.NaN;
        this.rms = Double.NaN;
    }
}

