/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.bin;

import cern.colt.list.DoubleArrayList;
import cern.jet.random.engine.DRand;
import cern.jet.random.engine.RandomEngine;
import cern.jet.stat.quantile.DoubleQuantileFinder;
import cern.jet.stat.quantile.QuantileFinderFactory;
import hep.aida.IAxis;
import hep.aida.bin.AbstractBin1D;
import hep.aida.bin.MightyStaticBin1D;
import hep.aida.ref.Converter;
import java.util.Date;

public class QuantileBin1D
extends MightyStaticBin1D {
    protected DoubleQuantileFinder finder = null;

    protected QuantileBin1D() {
        super(false, false, 2);
    }

    public QuantileBin1D(double d) {
        this(false, Long.MAX_VALUE, d, 0.001, 10000, new DRand(new Date()));
    }

    public QuantileBin1D(boolean bl, long l, double d, double d2, int n, RandomEngine randomEngine) {
        this(bl, l, d, d2, n, randomEngine, false, false, 2);
    }

    public QuantileBin1D(boolean bl, long l, double d, double d2, int n, RandomEngine randomEngine, boolean bl2, boolean bl3, int n2) {
        super(bl2, bl3, n2);
        this.finder = QuantileFinderFactory.newDoubleQuantileFinder(bl, l, d, d2, n, randomEngine);
        this.clear();
    }

    @Override
    public synchronized void addAllOfFromTo(DoubleArrayList doubleArrayList, int n, int n2) {
        super.addAllOfFromTo(doubleArrayList, n, n2);
        if (this.finder != null) {
            this.finder.addAllOfFromTo(doubleArrayList, n, n2);
        }
    }

    @Override
    public synchronized void clear() {
        super.clear();
        if (this.finder != null) {
            this.finder.clear();
        }
    }

    @Override
    public synchronized Object clone() {
        QuantileBin1D quantileBin1D = (QuantileBin1D)super.clone();
        if (this.finder != null) {
            quantileBin1D.finder = (DoubleQuantileFinder)quantileBin1D.finder.clone();
        }
        return quantileBin1D;
    }

    @Override
    public String compareWith(AbstractBin1D abstractBin1D) {
        StringBuffer stringBuffer = new StringBuffer(super.compareWith(abstractBin1D));
        if (abstractBin1D instanceof QuantileBin1D) {
            QuantileBin1D quantileBin1D = (QuantileBin1D)abstractBin1D;
            stringBuffer.append("25%, 50% and 75% Quantiles: " + this.relError(this.quantile(0.25), quantileBin1D.quantile(0.25)) + ", " + this.relError(this.quantile(0.5), quantileBin1D.quantile(0.5)) + ", " + this.relError(this.quantile(0.75), quantileBin1D.quantile(0.75)));
            stringBuffer.append("\nquantileInverse(mean): " + this.relError(this.quantileInverse(this.mean()), quantileBin1D.quantileInverse(quantileBin1D.mean())) + " %");
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public double median() {
        return this.quantile(0.5);
    }

    public synchronized double quantile(double d) {
        return this.quantiles(new DoubleArrayList(new double[]{d})).get(0);
    }

    public synchronized double quantileInverse(double d) {
        return this.finder.phi(d);
    }

    public synchronized DoubleArrayList quantiles(DoubleArrayList doubleArrayList) {
        return this.finder.quantileElements(doubleArrayList);
    }

    public int sizeOfRange(double d, double d2) {
        return (int)Math.round((double)this.size() * (this.quantileInverse(d2) - this.quantileInverse(d)));
    }

    public synchronized MightyStaticBin1D[] splitApproximately(DoubleArrayList doubleArrayList, int n) {
        int n2;
        int n3 = doubleArrayList.size();
        if (n < 1 || n3 < 2) {
            throw new IllegalArgumentException();
        }
        double[] dArray = doubleArrayList.elements();
        int n4 = n3 - 1;
        double[] dArray2 = new double[1 + n * (n3 - 1)];
        dArray2[0] = dArray[0];
        int n5 = 1;
        for (int i = 0; i < n4; ++i) {
            double d = (dArray[i + 1] - dArray[i]) / (double)n;
            for (n2 = 1; n2 <= n; ++n2) {
                dArray2[n5++] = dArray[i] + (double)n2 * d;
            }
        }
        double[] dArray3 = this.quantiles(new DoubleArrayList(dArray2)).elements();
        MightyStaticBin1D[] mightyStaticBin1DArray = new MightyStaticBin1D[n4];
        int n6 = this.getMaxOrderForSumOfPowers();
        n6 = Math.min(10, n6);
        n2 = this.size();
        n5 = 0;
        for (int i = 0; i < n4; ++i) {
            double d;
            int n7;
            double d2;
            double d3 = (dArray[i + 1] - dArray[i]) / (double)n;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double[] dArray4 = null;
            if (n6 > 2) {
                dArray4 = new double[n6 - 2];
            }
            double d8 = d2 = dArray3[n5++];
            double d9 = (double)n2 * d3;
            for (n7 = 1; n7 <= n; ++n7) {
                d = dArray3[n5++];
                double d10 = (d2 + d) / 2.0;
                d4 += d10 * d9;
                d5 += d10 * d10 * d9;
                if (this.hasSumOfLogarithms) {
                    d6 += Math.log(d10) * d9;
                }
                if (this.hasSumOfInversions) {
                    d7 += 1.0 / d10 * d9;
                }
                if (n6 >= 3) {
                    dArray4[0] = dArray4[0] + d10 * d10 * d10 * d9;
                }
                if (n6 >= 4) {
                    dArray4[1] = dArray4[1] + d10 * d10 * d10 * d10 * d9;
                }
                for (int j = 5; j <= n6; ++j) {
                    int n8 = j - 3;
                    dArray4[n8] = dArray4[n8] + Math.pow(d10, j) * d9;
                }
                d2 = d;
            }
            --n5;
            n7 = (int)Math.round((dArray[i + 1] - dArray[i]) * (double)n2);
            d = d2;
            d2 = d8;
            mightyStaticBin1DArray[i] = new MightyStaticBin1D(this.hasSumOfLogarithms, this.hasSumOfInversions, n6);
            if (n7 <= 0) continue;
            mightyStaticBin1DArray[i].size = n7;
            mightyStaticBin1DArray[i].min = d2;
            mightyStaticBin1DArray[i].max = d;
            mightyStaticBin1DArray[i].sum = d4;
            mightyStaticBin1DArray[i].sum_xx = d5;
            mightyStaticBin1DArray[i].sumOfLogarithms = d6;
            mightyStaticBin1DArray[i].sumOfInversions = d7;
            mightyStaticBin1DArray[i].sumOfPowers = dArray4;
        }
        return mightyStaticBin1DArray;
    }

    public synchronized MightyStaticBin1D[] splitApproximately(IAxis iAxis, int n) {
        DoubleArrayList doubleArrayList = new DoubleArrayList(new Converter().edges(iAxis));
        doubleArrayList.beforeInsert(0, Double.NEGATIVE_INFINITY);
        doubleArrayList.add(Double.POSITIVE_INFINITY);
        int n2 = doubleArrayList.size();
        while (--n2 >= 0) {
            doubleArrayList.set(n2, this.quantileInverse(doubleArrayList.get(n2)));
        }
        return this.splitApproximately(doubleArrayList, n);
    }

    @Override
    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("25%, 50%, 75% Quantiles: " + this.quantile(0.25) + ", " + this.quantile(0.5) + ", " + this.quantile(0.75));
        stringBuffer.append("\nquantileInverse(median): " + this.quantileInverse(this.median()));
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

