/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.engine.RandomEngine;
import cern.jet.stat.Probability;

public class Normal
extends AbstractContinousDistribution {
    protected double mean;
    protected double variance;
    protected double standardDeviation;
    protected double cache;
    protected boolean cacheFilled;
    protected double SQRT_INV;
    protected static Normal shared = new Normal(0.0, 1.0, Normal.makeDefaultGenerator());

    public Normal(double d, double d2, RandomEngine randomEngine) {
        this.setRandomGenerator(randomEngine);
        this.setState(d, d2);
    }

    public double cdf(double d) {
        return Probability.normal(this.mean, this.variance, d);
    }

    @Override
    public double nextDouble() {
        return this.nextDouble(this.mean, this.standardDeviation);
    }

    public double nextDouble(double d, double d2) {
        double d3;
        double d4;
        double d5;
        if (this.cacheFilled && this.mean == d && this.standardDeviation == d2) {
            this.cacheFilled = false;
            return this.cache;
        }
        while ((d5 = (d4 = 2.0 * this.randomGenerator.raw() - 1.0) * d4 + (d3 = 2.0 * this.randomGenerator.raw() - 1.0) * d3) >= 1.0) {
        }
        double d6 = Math.sqrt(-2.0 * Math.log(d5) / d5);
        this.cache = d + d2 * d4 * d6;
        this.cacheFilled = true;
        return d + d2 * d3 * d6;
    }

    public double pdf(double d) {
        double d2 = d - this.mean;
        return this.SQRT_INV * Math.exp(-(d2 * d2) / (2.0 * this.variance));
    }

    @Override
    protected void setRandomGenerator(RandomEngine randomEngine) {
        super.setRandomGenerator(randomEngine);
        this.cacheFilled = false;
    }

    public void setState(double d, double d2) {
        if (d != this.mean || d2 != this.standardDeviation) {
            this.mean = d;
            this.standardDeviation = d2;
            this.variance = d2 * d2;
            this.cacheFilled = false;
            this.SQRT_INV = 1.0 / Math.sqrt(Math.PI * 2 * this.variance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double d, double d2) {
        Normal normal = shared;
        synchronized (normal) {
            return shared.nextDouble(d, d2);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.mean + "," + this.standardDeviation + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(RandomEngine randomEngine) {
        Normal normal = shared;
        synchronized (normal) {
            shared.setRandomGenerator(randomEngine);
        }
    }
}

