/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math;

import cern.colt.function.IntFunction;
import cern.colt.function.IntIntFunction;
import cern.colt.function.IntIntProcedure;
import cern.colt.function.IntProcedure;
import cern.jet.math.Arithmetic;
import cern.jet.random.engine.MersenneTwister;
import java.util.Date;

public class IntFunctions {
    public static final IntFunctions intFunctions = new IntFunctions();
    public static final IntFunction abs = new IntFunction(){

        @Override
        public final int apply(int n) {
            return n < 0 ? -n : n;
        }
    };
    public static final IntFunction dec = new IntFunction(){

        @Override
        public final int apply(int n) {
            return n--;
        }
    };
    public static final IntFunction factorial = new IntFunction(){

        @Override
        public final int apply(int n) {
            return (int)Arithmetic.factorial(n);
        }
    };
    public static final IntFunction identity = new IntFunction(){

        @Override
        public final int apply(int n) {
            return n;
        }
    };
    public static final IntFunction inc = new IntFunction(){

        @Override
        public final int apply(int n) {
            return n++;
        }
    };
    public static final IntFunction neg = new IntFunction(){

        @Override
        public final int apply(int n) {
            return -n;
        }
    };
    public static final IntFunction not = new IntFunction(){

        @Override
        public final int apply(int n) {
            return ~n;
        }
    };
    public static final IntFunction sign = new IntFunction(){

        @Override
        public final int apply(int n) {
            return n < 0 ? -1 : (n > 0 ? 1 : 0);
        }
    };
    public static final IntFunction square = new IntFunction(){

        @Override
        public final int apply(int n) {
            return n * n;
        }
    };
    public static final IntIntFunction and = new IntIntFunction(){

        @Override
        public final int apply(int n, int n2) {
            return n & n2;
        }
    };
    public static final IntIntFunction compare = new IntIntFunction(){

        @Override
        public final int apply(int n, int n2) {
            return n < n2 ? -1 : (n > n2 ? 1 : 0);
        }
    };
    public static final IntIntFunction div = new IntIntFunction(){

        @Override
        public final int apply(int n, int n2) {
            return n / n2;
        }
    };
    public static final IntIntFunction equals = new IntIntFunction(){

        @Override
        public final int apply(int n, int n2) {
            return n == n2 ? 1 : 0;
        }
    };
    public static final IntIntProcedure isEqual = new IntIntProcedure(){

        @Override
        public final boolean apply(int n, int n2) {
            return n == n2;
        }
    };
    public static final IntIntProcedure isLess = new IntIntProcedure(){

        @Override
        public final boolean apply(int n, int n2) {
            return n < n2;
        }
    };
    public static final IntIntProcedure isGreater = new IntIntProcedure(){

        @Override
        public final boolean apply(int n, int n2) {
            return n > n2;
        }
    };
    public static final IntIntFunction max = new IntIntFunction(){

        @Override
        public final int apply(int n, int n2) {
            return n >= n2 ? n : n2;
        }
    };
    public static final IntIntFunction min = new IntIntFunction(){

        @Override
        public final int apply(int n, int n2) {
            return n <= n2 ? n : n2;
        }
    };
    public static final IntIntFunction minus = new IntIntFunction(){

        @Override
        public final int apply(int n, int n2) {
            return n - n2;
        }
    };
    public static final IntIntFunction mod = new IntIntFunction(){

        @Override
        public final int apply(int n, int n2) {
            return n % n2;
        }
    };
    public static final IntIntFunction mult = new IntIntFunction(){

        @Override
        public final int apply(int n, int n2) {
            return n * n2;
        }
    };
    public static final IntIntFunction or = new IntIntFunction(){

        @Override
        public final int apply(int n, int n2) {
            return n | n2;
        }
    };
    public static final IntIntFunction plus = new IntIntFunction(){

        @Override
        public final int apply(int n, int n2) {
            return n + n2;
        }
    };
    public static final IntIntFunction pow = new IntIntFunction(){

        @Override
        public final int apply(int n, int n2) {
            return (int)Math.pow(n, n2);
        }
    };
    public static final IntIntFunction shiftLeft = new IntIntFunction(){

        @Override
        public final int apply(int n, int n2) {
            return n << n2;
        }
    };
    public static final IntIntFunction shiftRightSigned = new IntIntFunction(){

        @Override
        public final int apply(int n, int n2) {
            return n >> n2;
        }
    };
    public static final IntIntFunction shiftRightUnsigned = new IntIntFunction(){

        @Override
        public final int apply(int n, int n2) {
            return n >>> n2;
        }
    };
    public static final IntIntFunction xor = new IntIntFunction(){

        @Override
        public final int apply(int n, int n2) {
            return n ^ n2;
        }
    };

    protected IntFunctions() {
    }

    public static IntFunction and(final int n) {
        return new IntFunction(){

            @Override
            public final int apply(int n2) {
                return n2 & n;
            }
        };
    }

    public static IntFunction between(final int n, final int n2) {
        return new IntFunction(){

            @Override
            public final int apply(int n3) {
                return n <= n3 && n3 <= n2 ? 1 : 0;
            }
        };
    }

    public static IntFunction bindArg1(final IntIntFunction intIntFunction, final int n) {
        return new IntFunction(){

            @Override
            public final int apply(int n2) {
                return intIntFunction.apply(n, n2);
            }
        };
    }

    public static IntFunction bindArg2(final IntIntFunction intIntFunction, final int n) {
        return new IntFunction(){

            @Override
            public final int apply(int n2) {
                return intIntFunction.apply(n2, n);
            }
        };
    }

    public static IntFunction chain(final IntFunction intFunction, final IntFunction intFunction2) {
        return new IntFunction(){

            @Override
            public final int apply(int n) {
                return intFunction.apply(intFunction2.apply(n));
            }
        };
    }

    public static IntIntFunction chain(final IntFunction intFunction, final IntIntFunction intIntFunction) {
        return new IntIntFunction(){

            @Override
            public final int apply(int n, int n2) {
                return intFunction.apply(intIntFunction.apply(n, n2));
            }
        };
    }

    public static IntIntFunction chain(final IntIntFunction intIntFunction, final IntFunction intFunction, final IntFunction intFunction2) {
        return new IntIntFunction(){

            @Override
            public final int apply(int n, int n2) {
                return intIntFunction.apply(intFunction.apply(n), intFunction2.apply(n2));
            }
        };
    }

    public static IntFunction compare(final int n) {
        return new IntFunction(){

            @Override
            public final int apply(int n2) {
                return n2 < n ? -1 : (n2 > n ? 1 : 0);
            }
        };
    }

    public static IntFunction constant(final int n) {
        return new IntFunction(){

            @Override
            public final int apply(int n2) {
                return n;
            }
        };
    }

    public static IntFunction div(final int n) {
        return new IntFunction(){

            @Override
            public final int apply(int n2) {
                return n2 / n;
            }
        };
    }

    public static IntFunction equals(final int n) {
        return new IntFunction(){

            @Override
            public final int apply(int n2) {
                return n2 == n ? 1 : 0;
            }
        };
    }

    public static IntProcedure isBetween(final int n, final int n2) {
        return new IntProcedure(){

            @Override
            public final boolean apply(int n3) {
                return n <= n3 && n3 <= n2;
            }
        };
    }

    public static IntProcedure isEqual(final int n) {
        return new IntProcedure(){

            @Override
            public final boolean apply(int n2) {
                return n2 == n;
            }
        };
    }

    public static IntProcedure isGreater(final int n) {
        return new IntProcedure(){

            @Override
            public final boolean apply(int n2) {
                return n2 > n;
            }
        };
    }

    public static IntProcedure isLess(final int n) {
        return new IntProcedure(){

            @Override
            public final boolean apply(int n2) {
                return n2 < n;
            }
        };
    }

    public static IntFunction max(final int n) {
        return new IntFunction(){

            @Override
            public final int apply(int n2) {
                return n2 >= n ? n2 : n;
            }
        };
    }

    public static IntFunction min(final int n) {
        return new IntFunction(){

            @Override
            public final int apply(int n2) {
                return n2 <= n ? n2 : n;
            }
        };
    }

    public static IntFunction minus(final int n) {
        return new IntFunction(){

            @Override
            public final int apply(int n2) {
                return n2 - n;
            }
        };
    }

    public static IntFunction mod(final int n) {
        return new IntFunction(){

            @Override
            public final int apply(int n2) {
                return n2 % n;
            }
        };
    }

    public static IntFunction mult(final int n) {
        return new IntFunction(){

            @Override
            public final int apply(int n2) {
                return n2 * n;
            }
        };
    }

    public static IntFunction or(final int n) {
        return new IntFunction(){

            @Override
            public final int apply(int n2) {
                return n2 | n;
            }
        };
    }

    public static IntFunction plus(final int n) {
        return new IntFunction(){

            @Override
            public final int apply(int n2) {
                return n2 + n;
            }
        };
    }

    public static IntFunction pow(final int n) {
        return new IntFunction(){

            @Override
            public final int apply(int n2) {
                return (int)Math.pow(n2, n);
            }
        };
    }

    public static IntFunction random() {
        return new MersenneTwister(new Date());
    }

    public static IntFunction shiftLeft(final int n) {
        return new IntFunction(){

            @Override
            public final int apply(int n2) {
                return n2 << n;
            }
        };
    }

    public static IntFunction shiftRightSigned(final int n) {
        return new IntFunction(){

            @Override
            public final int apply(int n2) {
                return n2 >> n;
            }
        };
    }

    public static IntFunction shiftRightUnsigned(final int n) {
        return new IntFunction(){

            @Override
            public final int apply(int n2) {
                return n2 >>> n;
            }
        };
    }

    public static IntIntFunction swapArgs(final IntIntFunction intIntFunction) {
        return new IntIntFunction(){

            @Override
            public final int apply(int n, int n2) {
                return intIntFunction.apply(n2, n);
            }
        };
    }

    public static IntFunction xor(final int n) {
        return new IntFunction(){

            @Override
            public final int apply(int n2) {
                return n2 ^ n;
            }
        };
    }
}

