/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.map.AbstractIntDoubleMap;
import cern.colt.map.OpenIntDoubleHashMap;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.DoubleMatrix3D;
import cern.colt.matrix.impl.SelectedSparseDoubleMatrix3D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;

public class SparseDoubleMatrix3D
extends DoubleMatrix3D {
    protected AbstractIntDoubleMap elements;

    public SparseDoubleMatrix3D(double[][][] dArray) {
        this(dArray.length, dArray.length == 0 ? 0 : dArray[0].length, dArray.length == 0 ? 0 : (dArray[0].length == 0 ? 0 : dArray[0][0].length));
        this.assign(dArray);
    }

    public SparseDoubleMatrix3D(int n, int n2, int n3) {
        this(n, n2, n3, n * n2 * (n3 / 1000), 0.2, 0.5);
    }

    public SparseDoubleMatrix3D(int n, int n2, int n3, int n4, double d, double d2) {
        this.setUp(n, n2, n3);
        this.elements = new OpenIntDoubleHashMap(n4, d, d2);
    }

    protected SparseDoubleMatrix3D(int n, int n2, int n3, AbstractIntDoubleMap abstractIntDoubleMap, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setUp(n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.elements = abstractIntDoubleMap;
        this.isNoView = false;
    }

    @Override
    public DoubleMatrix3D assign(double d) {
        if (this.isNoView && d == 0.0) {
            this.elements.clear();
        } else {
            super.assign(d);
        }
        return this;
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public void ensureCapacity(int n) {
        this.elements.ensureCapacity(n);
    }

    @Override
    public double getQuick(int n, int n2, int n3) {
        return this.elements.get(this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride);
    }

    @Override
    protected boolean haveSharedCellsRaw(DoubleMatrix3D doubleMatrix3D) {
        if (doubleMatrix3D instanceof SelectedSparseDoubleMatrix3D) {
            SelectedSparseDoubleMatrix3D selectedSparseDoubleMatrix3D = (SelectedSparseDoubleMatrix3D)doubleMatrix3D;
            return this.elements == selectedSparseDoubleMatrix3D.elements;
        }
        if (doubleMatrix3D instanceof SparseDoubleMatrix3D) {
            SparseDoubleMatrix3D sparseDoubleMatrix3D = (SparseDoubleMatrix3D)doubleMatrix3D;
            return this.elements == sparseDoubleMatrix3D.elements;
        }
        return false;
    }

    @Override
    protected int index(int n, int n2, int n3) {
        return this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride;
    }

    @Override
    public DoubleMatrix3D like(int n, int n2, int n3) {
        return new SparseDoubleMatrix3D(n, n2, n3);
    }

    @Override
    protected DoubleMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        return new SparseDoubleMatrix2D(n, n2, this.elements, n3, n4, n5, n6);
    }

    @Override
    public void setQuick(int n, int n2, int n3, double d) {
        int n4 = this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride;
        if (d == 0.0) {
            this.elements.removeKey(n4);
        } else {
            this.elements.put(n4, d);
        }
    }

    @Override
    public void trimToSize() {
        this.elements.trimToSize();
    }

    @Override
    protected DoubleMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedSparseDoubleMatrix3D(this.elements, nArray, nArray2, nArray3, 0);
    }
}

