/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.function.ObjectFunction;
import cern.colt.function.ObjectObjectFunction;
import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.impl.DenseObjectMatrix2D;
import cern.colt.matrix.impl.SelectedDenseObjectMatrix1D;

public class DenseObjectMatrix1D
extends ObjectMatrix1D {
    protected Object[] elements;

    public DenseObjectMatrix1D(Object[] objectArray) {
        this(objectArray.length);
        this.assign(objectArray);
    }

    public DenseObjectMatrix1D(int n) {
        this.setUp(n);
        this.elements = new Object[n];
    }

    protected DenseObjectMatrix1D(int n, Object[] objectArray, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = objectArray;
        this.isNoView = false;
    }

    @Override
    public ObjectMatrix1D assign(Object[] objectArray) {
        if (this.isNoView) {
            if (objectArray.length != this.size) {
                throw new IllegalArgumentException("Must have same number of cells: length=" + objectArray.length + "size()=" + this.size());
            }
            System.arraycopy(objectArray, 0, this.elements, 0, objectArray.length);
        } else {
            super.assign(objectArray);
        }
        return this;
    }

    @Override
    public ObjectMatrix1D assign(ObjectFunction objectFunction) {
        int n = this.stride;
        int n2 = this.index(0);
        Object[] objectArray = this.elements;
        if (this.elements == null) {
            throw new InternalError();
        }
        int n3 = this.size;
        while (--n3 >= 0) {
            objectArray[n2] = objectFunction.apply(objectArray[n2]);
            n2 += n;
        }
        return this;
    }

    @Override
    public ObjectMatrix1D assign(ObjectMatrix1D objectMatrix1D) {
        Object[] objectArray;
        if (!(objectMatrix1D instanceof DenseObjectMatrix1D)) {
            return super.assign(objectMatrix1D);
        }
        DenseObjectMatrix1D denseObjectMatrix1D = (DenseObjectMatrix1D)objectMatrix1D;
        if (denseObjectMatrix1D == this) {
            return this;
        }
        this.checkSize(denseObjectMatrix1D);
        if (this.isNoView && denseObjectMatrix1D.isNoView) {
            System.arraycopy(denseObjectMatrix1D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(denseObjectMatrix1D)) {
            objectArray = denseObjectMatrix1D.copy();
            if (!(objectArray instanceof DenseObjectMatrix1D)) {
                return super.assign(objectMatrix1D);
            }
            denseObjectMatrix1D = (DenseObjectMatrix1D)objectArray;
        }
        objectArray = this.elements;
        Object[] objectArray2 = denseObjectMatrix1D.elements;
        if (this.elements == null || objectArray2 == null) {
            throw new InternalError();
        }
        int n = this.stride;
        int n2 = denseObjectMatrix1D.stride;
        int n3 = this.index(0);
        int n4 = denseObjectMatrix1D.index(0);
        int n5 = this.size;
        while (--n5 >= 0) {
            objectArray[n3] = objectArray2[n4];
            n3 += n;
            n4 += n2;
        }
        return this;
    }

    @Override
    public ObjectMatrix1D assign(ObjectMatrix1D objectMatrix1D, ObjectObjectFunction objectObjectFunction) {
        if (!(objectMatrix1D instanceof DenseObjectMatrix1D)) {
            return super.assign(objectMatrix1D, objectObjectFunction);
        }
        DenseObjectMatrix1D denseObjectMatrix1D = (DenseObjectMatrix1D)objectMatrix1D;
        this.checkSize(objectMatrix1D);
        Object[] objectArray = this.elements;
        Object[] objectArray2 = denseObjectMatrix1D.elements;
        if (this.elements == null || objectArray2 == null) {
            throw new InternalError();
        }
        int n = this.stride;
        int n2 = denseObjectMatrix1D.stride;
        int n3 = this.index(0);
        int n4 = denseObjectMatrix1D.index(0);
        int n5 = this.size;
        while (--n5 >= 0) {
            objectArray[n3] = objectObjectFunction.apply(objectArray[n3], objectArray2[n4]);
            n3 += n;
            n4 += n2;
        }
        return this;
    }

    @Override
    public Object getQuick(int n) {
        return this.elements[this.zero + n * this.stride];
    }

    @Override
    protected boolean haveSharedCellsRaw(ObjectMatrix1D objectMatrix1D) {
        if (objectMatrix1D instanceof SelectedDenseObjectMatrix1D) {
            SelectedDenseObjectMatrix1D selectedDenseObjectMatrix1D = (SelectedDenseObjectMatrix1D)objectMatrix1D;
            return this.elements == selectedDenseObjectMatrix1D.elements;
        }
        if (objectMatrix1D instanceof DenseObjectMatrix1D) {
            DenseObjectMatrix1D denseObjectMatrix1D = (DenseObjectMatrix1D)objectMatrix1D;
            return this.elements == denseObjectMatrix1D.elements;
        }
        return false;
    }

    @Override
    protected int index(int n) {
        return this.zero + n * this.stride;
    }

    @Override
    public ObjectMatrix1D like(int n) {
        return new DenseObjectMatrix1D(n);
    }

    @Override
    public ObjectMatrix2D like2D(int n, int n2) {
        return new DenseObjectMatrix2D(n, n2);
    }

    @Override
    public void setQuick(int n, Object object) {
        this.elements[this.zero + n * this.stride] = object;
    }

    @Override
    public void swap(ObjectMatrix1D objectMatrix1D) {
        DenseObjectMatrix1D denseObjectMatrix1D;
        if (!(objectMatrix1D instanceof DenseObjectMatrix1D)) {
            super.swap(objectMatrix1D);
        }
        if ((denseObjectMatrix1D = (DenseObjectMatrix1D)objectMatrix1D) == this) {
            return;
        }
        this.checkSize(denseObjectMatrix1D);
        Object[] objectArray = this.elements;
        Object[] objectArray2 = denseObjectMatrix1D.elements;
        if (this.elements == null || objectArray2 == null) {
            throw new InternalError();
        }
        int n = this.stride;
        int n2 = denseObjectMatrix1D.stride;
        int n3 = this.index(0);
        int n4 = denseObjectMatrix1D.index(0);
        int n5 = this.size;
        while (--n5 >= 0) {
            Object object = objectArray[n3];
            objectArray[n3] = objectArray2[n4];
            objectArray2[n4] = object;
            n3 += n;
            n4 += n2;
        }
    }

    @Override
    public void toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, objectArray, 0, this.elements.length);
        } else {
            super.toArray(objectArray);
        }
    }

    @Override
    protected ObjectMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedDenseObjectMatrix1D(this.elements, nArray);
    }
}

