/*
 * Decompiled with CFR 0.152.
 */
package jsc.onesample;

import jsc.ci.AbstractConfidenceInterval;
import jsc.distributions.ChiSquared;

public class PoissonMeanCI
extends AbstractConfidenceInterval {
    public PoissonMeanCI(double d, double d2) {
        super(d2);
        ChiSquared chiSquared;
        double d3 = 1.0 - d2;
        double d4 = 0.5 * d3;
        if (d > 0.0) {
            chiSquared = new ChiSquared(d + d);
            this.lowerLimit = 0.5 * chiSquared.inverseCdf(d4);
        } else {
            this.lowerLimit = 0.0;
        }
        chiSquared = new ChiSquared(d + d + 2.0);
        this.upperLimit = 0.5 * chiSquared.inverseCdf(1.0 - d4);
    }

    public PoissonMeanCI(double d, int n, double d2) {
        this(d2, (double)n * d);
        if (n < 1) {
            throw new IllegalArgumentException("Invalid number of observations.");
        }
        this.lowerLimit /= (double)n;
        this.upperLimit /= (double)n;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            PoissonMeanCI poissonMeanCI = new PoissonMeanCI(3.0, 0.95);
            System.out.println("CI = [" + poissonMeanCI.getLowerLimit() + ", " + poissonMeanCI.getUpperLimit() + "]");
            PoissonMeanCI poissonMeanCI2 = new PoissonMeanCI(3.0, 7, 0.95);
            System.out.println("CI = [" + poissonMeanCI2.getLowerLimit() + ", " + poissonMeanCI2.getUpperLimit() + "]");
        }
    }
}

