/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.distributions.AbstractDistribution;
import jsc.goodnessfit.KolmogorovTest;
import jsc.tests.H1;
import jsc.util.Maths;

public class Weibull
extends AbstractDistribution {
    private double LOGC;
    private double LOGB;
    private double RECIPC;
    private double scale;
    private double shape;

    public Weibull(double d, double d2) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException("Invalid distribution parameter.");
        }
        this.scale = d;
        this.shape = d2;
        this.LOGC = Math.log(d2);
        this.LOGB = Math.log(d);
        this.RECIPC = 1.0 / d2;
    }

    public double cdf(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        return 1.0 - Math.exp(-Math.pow(d / this.scale, this.shape));
    }

    public double getScale() {
        return this.scale;
    }

    public double getShape() {
        return this.shape;
    }

    public double inverseCdf(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        if (d == 0.0) {
            return 0.0;
        }
        return this.scale * Math.pow(Math.log(1.0 / (1.0 - d)), this.RECIPC);
    }

    public double mean() {
        return Math.exp(this.LOGB + Maths.logGamma(1.0 + this.RECIPC));
    }

    public double pdf(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        double d2 = Math.log(d);
        double d3 = this.shape * (d2 - this.LOGB);
        return Math.exp(this.LOGC - d2 + d3 - Math.exp(d3));
    }

    public double random() {
        return this.scale * Math.pow(-Math.log(1.0 - this.rand.nextDouble()), this.RECIPC);
    }

    public String toString() {
        return new String("Weibull distribution: scale = " + this.scale + ", shape = " + this.shape + ".");
    }

    public double variance() {
        return Math.exp(this.LOGB + this.LOGB + Maths.logGamma(1.0 + this.RECIPC + this.RECIPC)) - Math.exp(2.0 * Maths.logGamma(1.0 + this.RECIPC));
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = 10000;
            Weibull weibull = new Weibull(5.0, 0.5);
            double[] dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = weibull.random();
                ++n2;
            }
            KolmogorovTest kolmogorovTest = new KolmogorovTest(dArray, weibull, H1.NOT_EQUAL, true);
            System.out.println("m = " + n + " D = " + kolmogorovTest.getTestStatistic() + " SP = " + kolmogorovTest.getSP());
        }
    }
}

