/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.distributions.AbstractContinuousDistribution;
import jsc.distributions.ChiSquared;
import jsc.goodnessfit.KolmogorovTest;
import jsc.tests.H1;
import jsc.util.Maths;

public class NoncentralChiSquared
extends AbstractContinuousDistribution {
    static final int ITRMAX = 100;
    static final double LOG2 = Math.log(2.0);
    private double delta;
    private double df;
    private double halfDf;
    private double logGammaHalfDf1;
    private double logDelta;
    private double sqrtDelta;
    private double expMhalfDelta;
    private ChiSquared chiSquared;
    private ChiSquared chiSquaredVm1;

    public NoncentralChiSquared(double d, double d2) {
        super(0.0, Double.POSITIVE_INFINITY, true);
        this.setParameters(d, d2);
    }

    public double cdf(double d) {
        double d2;
        double d3;
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        if (d == 0.0) {
            return 0.0;
        }
        if (this.delta == 0.0) {
            return this.chiSquared.cdf(d);
        }
        double d4 = this.df;
        double d5 = this.delta / 2.0;
        double d6 = 1.0;
        double d7 = d3 = this.expMhalfDelta;
        double d8 = d / 2.0;
        double d9 = this.halfDf;
        double d10 = Math.pow(d8, d9) * Math.exp(-d8) / this.logGammaHalfDf1;
        double d11 = d2 = d7 * d10;
        while (d4 + 2.0 * d6 - d <= 0.0) {
            d3 = d3 * d5 / d6;
            d10 = d10 * d / (d4 + 2.0 * d6);
            d2 = (d7 += d3) * d10;
            d11 += d2;
            d6 += 1.0;
        }
        do {
            double d12;
            if ((d12 = d10 * d / (d4 + 2.0 * d6 - d)) < this.tolerance) {
                return d11;
            }
            d3 = d3 * d5 / d6;
            d10 = d10 * d / (d4 + 2.0 * d6);
            d2 = (d7 += d3) * d10;
            d11 += d2;
        } while ((d6 += 1.0) <= 100.0);
        throw new RuntimeException("Cannot calculate cdf to required accuracy.");
    }

    public double getDelta() {
        return this.delta;
    }

    public double getDf() {
        return this.df;
    }

    public double inverseCdf(double d) {
        if (this.delta == 0.0) {
            return this.chiSquared.inverseCdf(d);
        }
        return super.inverseCdf(d);
    }

    public double mean() {
        return this.df + this.delta;
    }

    public double pdf(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        if (this.delta == 0.0) {
            return this.chiSquared.pdf(d);
        }
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = 0.0;
        double d3 = -0.5 * (d + this.delta + this.df * LOG2);
        double d4 = Math.log(d);
        int n = 0;
        while (n < 1000) {
            double d5 = Math.exp(d3 + (double)n * this.logDelta + ((double)(n - 1) + this.halfDf) * d4 - 2.0 * (double)n * LOG2 - Maths.logGamma(n + 1) - Maths.logGamma(this.halfDf + (double)n));
            if (d5 < this.tolerance * (d2 += d5)) {
                return d2;
            }
            ++n;
        }
        throw new RuntimeException("Cannot calculate pdf to required accuracy.");
    }

    public double random() {
        if (this.delta == 0.0) {
            return this.chiSquared.random();
        }
        if (this.df > 1.0 && this.df == Math.floor(this.df)) {
            double d = this.rand.nextGaussian() + this.sqrtDelta;
            return d * d + this.chiSquaredVm1.random();
        }
        return super.random();
    }

    public void setParameters(double d, double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Invalid noncentrality parameter.");
        }
        if (d < 0.0 || d == 0.0 && d2 == 0.0) {
            throw new IllegalArgumentException("Invalid degrees of freedom.");
        }
        this.delta = d2;
        this.df = d;
        if (d2 == 0.0) {
            this.chiSquared = new ChiSquared(d);
        } else {
            this.chiSquared = null;
            this.logDelta = Math.log(d2);
            this.sqrtDelta = Math.sqrt(d2);
            this.expMhalfDelta = Math.exp(-0.5 * d2);
            if (d > 1.0 && d == Math.floor(d)) {
                this.chiSquaredVm1 = new ChiSquared(d - 1.0);
            }
            this.halfDf = 0.5 * d;
            this.logGammaHalfDf1 = Math.exp(Maths.logGamma(this.halfDf + 1.0));
        }
    }

    public String toString() {
        return new String("Noncentral chi-squared distribution: df = " + this.df + ", delta = " + this.delta + ".");
    }

    public double variance() {
        return 2.0 * (this.df + this.delta + this.delta);
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = 10000;
            NoncentralChiSquared noncentralChiSquared = new NoncentralChiSquared(4.1, 0.5);
            double[] dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = noncentralChiSquared.random();
                ++n2;
            }
            KolmogorovTest kolmogorovTest = new KolmogorovTest(dArray, noncentralChiSquared, H1.NOT_EQUAL, true);
            System.out.println("m = " + n + " D = " + kolmogorovTest.getTestStatistic() + " SP = " + kolmogorovTest.getSP());
        }
    }
}

