/*
 * Decompiled with CFR 0.152.
 */
package jsc.curvefitting;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import jsc.curvefitting.FunctionVector;
import jsc.curvefitting.PolynomialFunctionVector;
import jsc.datastructures.PairedData;
import jsc.distributions.Normal;

public class GeneralLinearLeastSquares {
    private final int n;
    private final int ma;
    private final double[] weight;
    private double[] a;
    private Matrix cvm;
    private final FunctionVector fv;
    private double chisq;

    public GeneralLinearLeastSquares(PairedData pairedData, double[] dArray, int n, FunctionVector functionVector) {
        this.n = pairedData.getN();
        this.ma = n;
        if (this.n < n) {
            throw new IllegalArgumentException("Insufficient data to estimate model.");
        }
        if (dArray == null) {
            this.weight = new double[this.n];
            int n2 = 0;
            while (n2 < this.n) {
                this.weight[n2] = 1.0;
                ++n2;
            }
        } else {
            if (this.n != dArray.length) {
                throw new IllegalArgumentException("Weights array is wrong length.");
            }
            this.weight = dArray;
        }
        this.fv = functionVector;
        this.svdfit(pairedData.getX(), pairedData.getY());
    }

    public GeneralLinearLeastSquares(PairedData pairedData, int n, FunctionVector functionVector) {
        this(pairedData, null, n, functionVector);
    }

    public double[] getA() {
        return this.a;
    }

    public Matrix getCovariance() {
        return this.cvm;
    }

    public int getM() {
        return this.ma;
    }

    public int getN() {
        return this.n;
    }

    public double getSumOfSquares() {
        return this.chisq;
    }

    private double[] svbksb(Matrix matrix, double[] dArray, Matrix matrix2, double[] dArray2) {
        double d;
        int n = matrix.getColumnDimension();
        int n2 = matrix.getRowDimension();
        double[] dArray3 = new double[n];
        int n3 = 0;
        while (n3 < n) {
            d = 0.0;
            if (dArray[n3] != 0.0) {
                int n4 = 0;
                while (n4 < n2) {
                    d += matrix.get(n4, n3) * dArray2[n4];
                    ++n4;
                }
                d /= dArray[n3];
            }
            dArray3[n3] = d;
            ++n3;
        }
        double[] dArray4 = new double[n];
        n3 = 0;
        while (n3 < n) {
            d = 0.0;
            int n5 = 0;
            while (n5 < n) {
                d += matrix2.get(n3, n5) * dArray3[n5];
                ++n5;
            }
            dArray4[n3] = d;
            ++n3;
        }
        return dArray4;
    }

    private void svdfit(double[] dArray, double[] dArray2) {
        int n;
        double d;
        double[] dArray3;
        double d2 = (double)this.n * Double.MIN_VALUE;
        double[] dArray4 = new double[this.n];
        Matrix matrix = new Matrix(this.n, this.ma);
        int n2 = 0;
        while (n2 < this.n) {
            dArray3 = this.fv.function(dArray[n2]);
            d = this.weight[n2];
            n = 0;
            while (n < this.ma) {
                matrix.set(n2, n, dArray3[n] * d);
                ++n;
            }
            dArray4[n2] = dArray2[n2] * d;
            ++n2;
        }
        SingularValueDecomposition singularValueDecomposition = new SingularValueDecomposition(matrix);
        double[] dArray5 = singularValueDecomposition.getSingularValues();
        Matrix matrix2 = singularValueDecomposition.getV();
        double d3 = 0.0;
        n = 0;
        while (n < this.ma) {
            if (dArray5[n] > d3) {
                d3 = dArray5[n];
            }
            ++n;
        }
        double d4 = d2 * d3;
        n = 0;
        while (n < this.ma) {
            if (dArray5[n] < d4) {
                dArray5[n] = 0.0;
            }
            ++n;
        }
        matrix = singularValueDecomposition.getU();
        this.a = this.svbksb(matrix, dArray5, matrix2, dArray4);
        this.chisq = 0.0;
        n2 = 0;
        while (n2 < this.n) {
            dArray3 = this.fv.function(dArray[n2]);
            double d5 = 0.0;
            n = 0;
            while (n < this.ma) {
                d5 += this.a[n] * dArray3[n];
                ++n;
            }
            d = (dArray2[n2] - d5) * this.weight[n2];
            this.chisq += d * d;
            ++n2;
        }
        this.cvm = new Matrix(this.ma, this.ma);
        this.svdvar(matrix2, dArray5);
    }

    private void svdvar(Matrix matrix, double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray2[n2] = 0.0;
            if (dArray[n2] != 0.0) {
                dArray2[n2] = 1.0 / (dArray[n2] * dArray[n2]);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 <= n2) {
                double d = 0.0;
                int n4 = 0;
                while (n4 < n) {
                    d += matrix.get(n2, n4) * matrix.get(n3, n4) * dArray2[n4];
                    ++n4;
                }
                this.cvm.set(n3, n2, d);
                this.cvm.set(n2, n3, d);
                ++n3;
            }
            ++n2;
        }
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n;
            Object object;
            int n2 = 20;
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            double[] dArray3 = new double[]{1.0, 2.0, 3.0, -1.0, 0.5};
            int n3 = dArray3.length;
            Normal normal = new Normal(0.0, 0.01);
            PolynomialFunctionVector polynomialFunctionVector = new PolynomialFunctionVector(n3 - 1);
            int n4 = 0;
            while (n4 < n2) {
                dArray[n4] = 1.0 + (double)n4;
                object = polynomialFunctionVector.function(dArray[n4]);
                double d = 0.0;
                n = 0;
                while (n < n3) {
                    d += dArray3[n] * object[n];
                    ++n;
                }
                dArray2[n4] = d + normal.random();
                ++n4;
            }
            object = new GeneralLinearLeastSquares(new PairedData(dArray, dArray2), n3, polynomialFunctionVector);
            double[] dArray4 = ((GeneralLinearLeastSquares)object).getA();
            n = 0;
            while (n < ((GeneralLinearLeastSquares)object).getM()) {
                System.out.println("a(" + n + ") = " + dArray4[n]);
                ++n;
            }
            System.out.println("Sum of squares = " + ((GeneralLinearLeastSquares)object).getSumOfSquares());
            System.out.println("\nCovariance matrix");
            Matrix matrix = ((GeneralLinearLeastSquares)object).getCovariance();
            matrix.print(12, 4);
        }
    }
}

