/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

import cern.jet.math.Bessel;
import umontreal.iro.lecuyer.util.Misc;

public class Num {
    private static final double XBIG = 40.0;
    private static final double SQPI_2 = 0.886226925452758;
    private static final double RACPI = 1.772453850905516;
    private static final double LOG_SQPI_2 = -0.1207822376352453;
    private static final double LOG4 = 1.3862943611198906;
    private static final double LOG_PI = 1.1447298858494002;
    private static final double PIsur2 = 1.5707963267948966;
    private static final double UNSIX = 0.16666666666666666;
    private static final double QUARAN = 0.023809523809523808;
    private static final double UNTRENTE = 0.03333333333333333;
    private static final double DTIERS = 0.6666666666666666;
    private static final double CTIERS = 1.6666666666666667;
    private static final double STIERS = 2.3333333333333335;
    private static final double QTIERS = 4.666666666666667;
    private static final double[] AERF = new double[]{1.4831105640848037, -0.30107107338659495, 0.06899483068983156, -0.013916271264722188, 0.0024207995224334636, -3.658639685848086E-4, 4.862098443231905E-5, -5.749256558035685E-6, 6.113243578434765E-7, -5.8991015312958435E-8, 5.2070090920686485E-9, -4.2329758799655433E-10, 3.188113506649175E-11, -2.2361550188326843E-12, 1.467329847991085E-13, -9.044001985381747E-15, 5.25481371547092E-16};
    private static final double[] AERFC = new double[]{0.6101430819232004, -0.4348412727125775, 0.1763511936436055, -0.06071079560924941, 0.017712068995694115, -0.004321119385567294, 8.542166768870987E-4, -1.2715509060916275E-4, 1.1248167243671189E-5, 3.1306388542182096E-7, -2.70988068537762E-7, 3.073762270140769E-8, 2.515620384817623E-9, -1.0289299213203192E-9, 2.994405211994994E-11, 2.6051789687266936E-11, -2.6348399241719693E-12, -6.434045098906365E-13, 1.1245740180166345E-13, 1.7281533389986097E-14, -4.2641016949424E-15, -5.4537197788E-16, 1.5869760776E-16, 2.08998378E-17, -5.9E-18};
    private static final double[] AlnGamma = new double[]{0.5285430369822346, 0.5498764461214141, 0.02073980061613665, -5.691677042154384E-4, 2.324587210400169E-5, -1.13060758570393E-6, 6.065653098948E-8, -3.4628435777E-9, 2.0624998806E-10, -1.266351116E-11, 7.9531007E-13, -5.082077E-14, 3.29187E-15, -2.1556E-16, 1.424E-17, -9.5E-19};
    public static final double DBL_EPSILON = 2.220446049250313E-16;
    public static final int DBL_MAX_EXP = 1024;
    public static final int DBL_MIN_EXP = -1021;
    public static final int DBL_MAX_10_EXP = 308;
    public static final double DBL_MIN = Double.MIN_NORMAL;
    public static final double LN_DBL_MIN = -708.3964185322641;
    public static final int DBL_DIG = 15;
    public static final double EBASE = Math.E;
    public static final double EULER = 0.5772156649015329;
    public static final double RAC2 = 1.4142135623730951;
    public static final double IRAC2 = 0.7071067811865476;
    public static final double LN2 = 0.6931471805599453;
    public static final double ILN2 = 1.4426950408889634;
    public static final double MAXINTDOUBLE = 9.007199254740992E15;
    public static final double MAXTWOEXP = 64.0;
    public static final double[] TWOEXP = new double[]{1.0, 2.0, 4.0, 8.0, 16.0, 32.0, 64.0, 128.0, 256.0, 512.0, 1024.0, 2048.0, 4096.0, 8192.0, 16384.0, 32768.0, 65536.0, 131072.0, 262144.0, 524288.0, 1048576.0, 2097152.0, 4194304.0, 8388608.0, 1.6777216E7, 3.3554432E7, 6.7108864E7, 1.34217728E8, 2.68435456E8, 5.36870912E8, 1.073741824E9, 2.147483648E9, 4.294967296E9, 8.589934592E9, 1.7179869184E10, 3.4359738368E10, 6.8719476736E10, 1.37438953472E11, 2.74877906944E11, 5.49755813888E11, 1.099511627776E12, 2.199023255552E12, 4.398046511104E12, 8.796093022208E12, 1.7592186044416E13, 3.5184372088832E13, 7.0368744177664E13, 1.40737488355328E14, 2.81474976710656E14, 5.62949953421312E14, 1.125899906842624E15, 2.251799813685248E15, 4.503599627370496E15, 9.007199254740992E15, 1.8014398509481984E16, 3.602879701896397E16, 7.205759403792794E16, 1.4411518807585587E17, 2.8823037615171174E17, 5.764607523034235E17, 1.152921504606847E18, 2.305843009213694E18, 4.611686018427388E18, 9.223372036854776E18, 1.8446744073709552E19};
    public static final double[] TEN_NEG_POW = new double[]{1.0, 0.1, 0.01, 0.001, 1.0E-4, 1.0E-5, 1.0E-6, 1.0E-7, 1.0E-8, 1.0E-9, 1.0E-10, 1.0E-11, 1.0E-12, 1.0E-13, 1.0E-14, 1.0E-15, 1.0E-16};
    private static final double[] InvP1 = new double[]{16.030495584406623, -90.78495926296033, 186.44914861620987, -169.0014273464238, 65.45466284794487, -8.642130115872478, 0.176058782139059};
    private static final double[] InvQ1 = new double[]{14.780647071513831, -91.37416702426032, 210.1579048620532, -222.10254121855132, 107.60453916055124, -20.601073032826545, 1.0};
    private static final double[] InvP2 = new double[]{-0.015238926344072612, 0.3444556924136125, -2.9344398672542478, 11.763505705217828, -22.655292823101103, 19.12133439658033, -5.478927619598319, 0.237516689024448};
    private static final double[] InvQ2 = new double[]{-0.010846516960205995, 0.2610628885843079, -2.406831810439376, 10.695129973387015, -23.71671552159658, 24.640158943917285, -10.01437634978307, 1.0};
    private static final double[] InvP3 = new double[]{5.6451977709864484E-5, 0.005350414748789302, 0.12969550099727353, 1.0426158549298266, 2.830267790175449, 2.6255672879448073, 2.078974263017492, 0.7271880623155681, 0.066816807711805, -0.01779100457511176, 0.0022419563223346345};
    private static final double[] InvQ3 = new double[]{5.645169986276065E-5, 0.005350558706793065, 0.12986615416911648, 1.0542932232626492, 3.0379331173522206, 3.763116853640503, 3.878285827704201, 2.0372431817412178, 1.0};

    private Num() {
    }

    public static int gcd(int x, int y) {
        if (x < 0) {
            x = -x;
        }
        if (y < 0) {
            y = -y;
        }
        while (y != 0) {
            int r = x % y;
            x = y;
            y = r;
        }
        return x;
    }

    public static long gcd(long x, long y) {
        if (x < 0L) {
            x = -x;
        }
        if (y < 0L) {
            y = -y;
        }
        while (y != 0L) {
            long r = x % y;
            x = y;
            y = r;
        }
        return x;
    }

    public static double combination(int n, int s) {
        int NLIM = 100;
        if (s == 0 || s == n) {
            return 1.0;
        }
        if (s < 0) {
            System.err.println("combination:   s < 0");
            return 0.0;
        }
        if (s > n) {
            System.err.println("combination:   s > n");
            return 0.0;
        }
        if (s > n / 2) {
            s = n - s;
        }
        if (n <= 100) {
            double Res = 1.0;
            int Diff = n - s;
            for (int i = 1; i <= s; ++i) {
                Res *= (double)(Diff + i) / (double)i;
            }
            return Res;
        }
        double Res = Num.lnFactorial(n) - Num.lnFactorial(s) - Num.lnFactorial(n - s);
        return Math.exp(Res);
    }

    public static double factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("factorial:   n < 0");
        }
        double T = 1.0;
        for (int j = 2; j <= n; ++j) {
            T *= (double)j;
        }
        return T;
    }

    public static double lnFactorial(int n) {
        int NLIM = 14;
        if (n < 0) {
            throw new IllegalArgumentException("lnFactorial:   n < 0");
        }
        if (n == 0 || n == 1) {
            return 0.0;
        }
        if (n <= 14) {
            long z = 1L;
            long x = 1L;
            for (int i = 2; i <= n; ++i) {
                z *= ++x;
            }
            return Math.log(z);
        }
        double x = n + 1;
        double y = 1.0 / (x * x);
        double z = ((-(5.95238095238E-4 * y) + 7.936500793651E-4) * y - 0.0027777777777778) * y + 0.083333333333333;
        z = (x - 0.5) * Math.log(x) - x + 0.91893853320467 + z / x;
        return z;
    }

    public static double factoPow(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("factoPow :   n < 0");
        }
        double res = 1.0 / (double)n;
        for (int i = 2; i <= n; ++i) {
            res *= (double)i / (double)n;
        }
        return res;
    }

    public static double[][] calcMatStirling(int m, int n) {
        int j;
        int i;
        double[][] M = new double[m + 1][n + 1];
        for (i = 0; i <= m; ++i) {
            for (j = 0; j <= n; ++j) {
                M[i][j] = 0.0;
            }
        }
        M[0][0] = 1.0;
        for (j = 1; j <= n; ++j) {
            int k;
            M[0][j] = 0.0;
            if (j <= m) {
                k = j - 1;
                M[j][j] = 1.0;
            } else {
                k = m;
            }
            for (i = 1; i <= k; ++i) {
                M[i][j] = (double)i * M[i][j - 1] + M[i - 1][j - 1];
            }
        }
        return M;
    }

    public static double log2(double x) {
        return 1.4426950408889634 * Math.log(x);
    }

    public static double lnGamma(double x) {
        double y;
        double z;
        if (x <= 0.0) {
            throw new IllegalArgumentException("lnGamma:   x <= 0");
        }
        double XLIMBIG = 4.503599627370496E15;
        double XLIM1 = 18.0;
        double DK2 = 0.9189385332046728;
        double DK1 = 0.9574186990510627;
        int N = 15;
        if (x > 18.0) {
            double y2 = x > 4.503599627370496E15 ? 0.0 : 1.0 / (x * x);
            double z2 = ((-(5.95238095238E-4 * y2) + 7.936500793651E-4) * y2 - 0.0027777777777778) * y2 + 0.083333333333333;
            z2 = (x - 0.5) * Math.log(x) - x + 0.9189385332046728 + z2 / x;
            return z2;
        }
        if (x > 4.0) {
            int k = (int)x;
            z = x - (double)k;
            y = 1.0;
            for (int i = 3; i < k; ++i) {
                y *= z + (double)i;
            }
            y = Math.log(y);
        } else {
            if (x <= 0.0) {
                return Double.MAX_VALUE;
            }
            if (x < 3.0) {
                int k = (int)x;
                z = x - (double)k;
                y = 1.0;
                for (int i = 2; i >= k; --i) {
                    y *= z + (double)i;
                }
                y = -Math.log(y);
            } else {
                z = x - 3.0;
                y = 0.0;
            }
        }
        z = Num.evalCheby(AlnGamma, 15, 2.0 * z - 1.0);
        return z + 0.9574186990510627 + y;
    }

    public static double lnBeta(double lam, double nu) {
        return Num.lnGamma(lam) + Num.lnGamma(nu) - Num.lnGamma(lam + nu);
    }

    public static double digamma(double x) {
        double[][] C7 = new double[][]{{13524.999667726346, 45285.60169954729, 45135.168469736665, 18529.01181858261, 3329.1525149406934, 240.68032474357202, 5.157789200013909, 0.006228350691898475}, {6.938911175376345E-7, 19768.574263046736, 41255.16083535383, 29390.287119932684, 9081.966607485518, 1244.7477785670856, 67.4291295163786, 1.0}};
        double[][] C4 = new double[][]{{-2.7281757513152966E-15, -0.6481571237661965, -4.486165439180193, -7.016772277667586, -2.1294044513101054}, {7.777885485229616, 54.61177381032151, 89.29207004818613, 32.270349379114336, 1.0}};
        double prodPj = 0.0;
        double prodQj = 0.0;
        double digX = 0.0;
        if (x >= 3.0) {
            double x2 = 1.0 / (x * x);
            for (int j = 4; j >= 0; --j) {
                prodPj = prodPj * x2 + C4[0][j];
                prodQj = prodQj * x2 + C4[1][j];
            }
            digX = Math.log(x) - 0.5 / x + prodPj / prodQj;
        } else if (x >= 0.5) {
            double X0 = 1.4616321449683622;
            for (int j = 7; j >= 0; --j) {
                prodPj = x * prodPj + C7[0][j];
                prodQj = x * prodQj + C7[1][j];
            }
            digX = (x - 1.4616321449683622) * (prodPj / prodQj);
        } else {
            double f = 1.0 - x - Math.floor(1.0 - x);
            digX = Num.digamma(1.0 - x) + Math.PI / Math.tan(Math.PI * f);
        }
        return digX;
    }

    public static double trigamma(double x) {
        if (x < 0.5) {
            double y = 1.0 - x - Math.floor(1.0 - x);
            double sum = Math.PI / Math.sin(Math.PI * y);
            return sum * sum - Num.trigamma(1.0 - x);
        }
        if (x >= 40.0) {
            double y = 1.0 / (x * x);
            double sum = 1.0 + y * (0.16666666666666666 - y * (0.03333333333333333 - y * (0.023809523809523808 - 0.03333333333333333 * y)));
            return (sum += 0.5 / x) / x;
        }
        int p = (int)x;
        double y = x - (double)p;
        double sum = 0.0;
        if (p > 3) {
            for (int i = 3; i < p; ++i) {
                sum -= 1.0 / ((y + (double)i) * (y + (double)i));
            }
        } else if (p < 3) {
            for (int i = 2; i >= p; --i) {
                sum += 1.0 / ((y + (double)i) * (y + (double)i));
            }
        }
        int N = 15;
        double[] A = new double[]{0.6696773958218988, -0.05518748204873009, 0.004510190736011502, -3.657058883037208E-4, 2.943462746822336E-5, -2.35277681515061E-6, 1.8685317663281E-7, -1.475072018379E-8, 1.15799333714E-9, -9.043917904E-11, 7.029627E-12, -5.4398873E-13, 4.192525E-14, -3.21903E-15, 2.463E-16, -1.878E-17, 0.0, 0.0};
        return sum + Num.evalChebyStar(A, 15, y);
    }

    public static double tetragamma(double x) {
        if (x < 0.5) {
            double y = 1.0 - x - Math.floor(1.0 - x);
            double sum = Math.PI / Math.sin(Math.PI * y);
            return 2.0 * Math.cos(Math.PI * y) * sum * sum * sum + Num.tetragamma(1.0 - x);
        }
        if (x >= 20.0) {
            double y = 1.0 / (x * x);
            double sum = y * (0.5 - y * (0.16666666666666666 - y * (0.16666666666666666 - y * (0.3 - 0.8333333333333334 * y))));
            return -(sum += 1.0 + 1.0 / x) * y;
        }
        int p = (int)x;
        double y = x - (double)p;
        double sum = 0.0;
        if (p > 3) {
            for (int i = 3; i < p; ++i) {
                sum += 1.0 / ((y + (double)i) * (y + (double)i) * (y + (double)i));
            }
        } else if (p < 3) {
            for (int i = 2; i >= p; --i) {
                sum -= 1.0 / ((y + (double)i) * (y + (double)i) * (y + (double)i));
            }
        }
        int N = 16;
        double[] A = new double[]{-0.22518587069094767, 0.03655700174282094, -0.004435942496027283, 4.7547585472892647E-4, -4.747183638263232E-5, 4.52181523735268E-6, -4.1630007962011E-7, 3.733899816535E-8, -3.2799144741E-9, 2.8321137682E-10, -2.410402848E-11, 2.0262969E-12, -1.6852418E-13, 1.388481E-14, -1.13451E-15, 9.201E-17, -7.41E-18, 5.9E-19, -5.0E-20};
        return 2.0 * sum + Num.evalChebyStar(A, 16, y);
    }

    public static double gammaRatioHalf(double x) {
        if (x <= 0.0) {
            throw new IllegalArgumentException("gammaRatioHalf:   x <= 0");
        }
        if (x <= 10.0) {
            double y = Num.lnGamma(x + 0.5) - Num.lnGamma(x);
            return Math.exp(y);
        }
        if (x <= 300.0) {
            double EPSILON = 1.0E-15;
            double term = 1.0;
            double sum = 1.0;
            int i = 1;
            while (term > 1.0E-15 * sum) {
                sum += (term *= ((double)i - 1.5) * ((double)i - 1.5) / ((double)i * (x + (double)i - 1.5)));
                ++i;
            }
            return Math.sqrt((x - 0.5) * sum);
        }
        double y = 1.0 / (8.0 * x);
        double sum = 1.0 + y * (-1.0 + y * (0.5 + y * (2.5 - y * (2.625 + 49.875 * y))));
        return sum * Math.sqrt(x);
    }

    public static double sumKahan(double[] A, int n) {
        if (A.length < n) {
            n = A.length;
        }
        double sum = 0.0;
        double c = 0.0;
        for (int i = 0; i < n; ++i) {
            double y = A[i] - c;
            double t = sum + y;
            c = t - sum - y;
            sum = t;
        }
        return sum;
    }

    public static double harmonic(long n) {
        if (n < 1L) {
            throw new IllegalArgumentException("n < 1");
        }
        return Num.digamma(n + 1L) + 0.5772156649015329;
    }

    public static double harmonic2(long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (1L == n) {
            return 0.0;
        }
        if (2L == n) {
            return 1.0;
        }
        long k = n / 2L;
        if ((n & 1L) == 1L) {
            return 2.0 * Num.harmonic(k);
        }
        return 1.0 / (double)k + 2.0 * Num.harmonic(k - 1L);
    }

    public static double volumeSphere(double p, int t) {
        double EPS = 4.440892098500626E-16;
        int pLR = (int)p;
        double kLR = t;
        if (p < 0.0) {
            throw new IllegalArgumentException("volumeSphere:   p < 0");
        }
        if (Math.abs(p - (double)pLR) <= 4.440892098500626E-16) {
            switch (pLR) {
                case 0: {
                    return TWOEXP[t];
                }
                case 1: {
                    return TWOEXP[t] / Num.factorial(t);
                }
                case 2: {
                    if (t % 2 == 0) {
                        return Math.pow(Math.PI, kLR / 2.0) / Num.factorial(t / 2);
                    }
                    int s = (t + 1) / 2;
                    return Math.pow(Math.PI, (double)s - 1.0) * Num.factorial(s) * TWOEXP[2 * s] / Num.factorial(2 * s);
                }
            }
        }
        double Vol = kLR * (0.6931471805599453 + Num.lnGamma(1.0 + 1.0 / p)) - Num.lnGamma(1.0 + kLR / p);
        return Math.exp(Vol);
    }

    public static double bernoulliPoly(int n, double x) {
        switch (n) {
            case 0: {
                return 1.0;
            }
            case 1: {
                return x - 0.5;
            }
            case 2: {
                return x * (x - 1.0) + 0.16666666666666666;
            }
            case 3: {
                return ((2.0 * x - 3.0) * x + 1.0) * x * 0.5;
            }
            case 4: {
                return ((x - 2.0) * x + 1.0) * x * x - 0.03333333333333333;
            }
            case 5: {
                return (((x - 2.5) * x + 1.6666666666666667) * x * x - 0.16666666666666666) * x;
            }
            case 6: {
                return (((x - 3.0) * x + 2.5) * x * x - 0.5) * x * x + 0.023809523809523808;
            }
            case 7: {
                return ((((x - 3.5) * x + 3.5) * x * x - 1.1666666666666667) * x * x + 0.16666666666666666) * x;
            }
            case 8: {
                return ((((x - 4.0) * x + 4.666666666666667) * x * x - 2.3333333333333335) * x * x + 0.6666666666666666) * x * x - 0.03333333333333333;
            }
        }
        throw new IllegalArgumentException("n must be <= 8");
    }

    public static double evalCheby(double[] a, int n, double x) {
        if (Math.abs(x) > 1.0) {
            System.err.println("Chebychev polynomial evaluated at x outside [-1, 1]");
        }
        double xx = 2.0 * x;
        double b0 = 0.0;
        double b1 = 0.0;
        double b2 = 0.0;
        for (int j = n; j >= 0; --j) {
            b2 = b1;
            b1 = b0;
            b0 = xx * b1 - b2 + a[j];
        }
        return (b0 - b2) / 2.0;
    }

    public static double evalChebyStar(double[] a, int n, double x) {
        if (x > 1.0 || x < 0.0) {
            System.err.println("Shifted Chebychev polynomial evaluated at x outside [0, 1]");
        }
        double xx = 2.0 * (2.0 * x - 1.0);
        double b0 = 0.0;
        double b1 = 0.0;
        double b2 = 0.0;
        for (int j = n; j >= 0; --j) {
            b2 = b1;
            b1 = b0;
            b0 = xx * b1 - b2 + a[j];
        }
        return (b0 - b2) / 2.0;
    }

    public static double besselK025(double x) {
        int DEG = 6;
        double[] c = new double[]{3.2177591145E10, 2.09933633952E12, 1.6281990144E13, 3.461195759616E13, 2.664028962816E13, 7.901666082816E12, 7.55914244096E11};
        double[] b = new double[]{7.5293843625E10, 2.8912835952E12, 1.8691126272E13, 3.68071409664E13, 2.7348959232E13, 7.9725330432E12, 7.55914244096E11};
        if (x < 1.0E-300) {
            return Double.MIN_VALUE;
        }
        if (x >= 0.6) {
            double B = b[6];
            double C = c[6];
            for (int j = 6; j >= 1; --j) {
                B = B * x + b[j - 1];
                C = C * x + c[j - 1];
            }
            double Res1 = Math.sqrt(Math.PI / (2.0 * x)) * Math.exp(-x) * (C / B);
            return Res1;
        }
        double xx = x * x;
        double rac = Math.pow(x / 2.0, 0.25);
        double Res = (((xx / 1386.0 + 0.023809523809523808) * xx + 0.3333333333333333) * xx + 1.0) / (1.225416702465177 * rac);
        double temp = (((xx / 3510.0 + 0.011111111111111112) * xx + 0.2) * xx + 1.0) * rac / 0.906402477055477;
        Res = Math.PI * (Res - temp) / 1.4142135623730951;
        return Res;
    }

    public static double expBesselK1(double x, double y) {
        if (y > 500.0) {
            double sum = 1.0 + 3.0 / (8.0 * y) - 15.0 / (128.0 * y * y) + 105.0 / (1024.0 * y * y * y);
            return Math.sqrt(1.5707963267948966 / y) * sum * Math.exp(x - y);
        }
        if (Math.abs(x) > 500.0) {
            double b = Bessel.k1(y);
            return Math.exp(x + Math.log(b));
        }
        return Math.exp(x) * Bessel.k1(y);
    }

    public static double erf(double x) {
        if (x < 0.0) {
            return -Num.erf(-x);
        }
        if (x >= 6.0) {
            return 1.0;
        }
        if (x >= 2.0) {
            return 1.0 - Num.erfc(x);
        }
        double t = 0.5 * x * x - 1.0;
        double y = Num.evalCheby(AERF, 16, t);
        return x * y;
    }

    public static double erfc(double x) {
        if (x < 0.0) {
            return 2.0 - Num.erfc(-x);
        }
        if (x >= 40.0) {
            return 0.0;
        }
        double t = (x - 3.75) / (x + 3.75);
        double y = Num.evalCheby(AERFC, 24, t);
        return y *= Math.exp(-x * x);
    }

    public static double erfInv(double u) {
        double z;
        if (u < 0.0) {
            return -Num.erfInv(-u);
        }
        if (u > 1.0) {
            throw new IllegalArgumentException("u is not in [-1, 1]");
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (u <= 0.75) {
            double t = u * u - 0.5625;
            double v = Misc.evalPoly(InvP1, 6, t);
            double w = Misc.evalPoly(InvQ1, 6, t);
            z = v / w * u;
        } else if (u <= 0.9375) {
            double t = u * u - 0.87890625;
            double v = Misc.evalPoly(InvP2, 7, t);
            double w = Misc.evalPoly(InvQ2, 7, t);
            z = v / w * u;
        } else {
            double t = 1.0 / Math.sqrt(-Math.log(1.0 - u));
            double v = Misc.evalPoly(InvP3, 10, t);
            double w = Misc.evalPoly(InvQ3, 8, t);
            z = v / w / t;
        }
        return z;
    }

    public static double erfcInv(double u) {
        if (u < 0.0 || u > 2.0) {
            throw new IllegalArgumentException("u is not in [0, 2]");
        }
        if (u > 0.005) {
            return Num.erfInv(1.0 - u);
        }
        if (u <= 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double x = Math.sqrt(-Math.log(1.772453850905516 * u));
        x = Math.sqrt(-Math.log(1.772453850905516 * u * x));
        for (int i = 0; i < 3; ++i) {
            double w = -2.0 * Math.exp(-x * x) / 1.772453850905516;
            x += (u - Num.erfc(x)) / w;
        }
        return x;
    }
}

