/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.functionfit;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import java.io.Serializable;
import umontreal.iro.lecuyer.functionfit.PolInterp;
import umontreal.iro.lecuyer.functions.Polynomial;

public class LeastSquares
extends Polynomial
implements Serializable {
    private static final long serialVersionUID = -4997132164503234983L;
    private static final Algebra alg = new Algebra();
    private double[] x;
    private double[] y;

    public LeastSquares(double[] x, double[] y, int degree) {
        super(LeastSquares.getCoefficients(x, y, degree));
        this.x = (double[])x.clone();
        this.y = (double[])y.clone();
    }

    public static double[] getCoefficients(double[] x, double[] y, int degree) {
        int j;
        if (x.length != y.length) {
            throw new IllegalArgumentException("Length of x and y not equal");
        }
        if (x.length < degree + 1) {
            throw new IllegalArgumentException("Not enough points");
        }
        double[] xSums = new double[2 * degree + 1];
        double[] xySums = new double[degree + 1];
        xSums[0] = x.length;
        for (int i = 0; i < x.length; ++i) {
            double xv = x[i];
            xySums[0] = xySums[0] + y[i];
            for (j = 1; j <= 2 * degree; ++j) {
                int n = j;
                xSums[n] = xSums[n] + xv;
                if (j <= degree) {
                    int n2 = j;
                    xySums[n2] = xySums[n2] + xv * y[i];
                }
                xv *= x[i];
            }
        }
        DenseDoubleMatrix2D A = new DenseDoubleMatrix2D(degree + 1, degree + 1);
        DenseDoubleMatrix2D B = new DenseDoubleMatrix2D(degree + 1, 1);
        for (int i = 0; i <= degree; ++i) {
            for (j = 0; j <= degree; ++j) {
                int d = i + j;
                ((DoubleMatrix2D)A).setQuick(i, j, xSums[d]);
            }
            ((DoubleMatrix2D)B).setQuick(i, 0, xySums[i]);
        }
        DoubleMatrix2D aVec = alg.solve(A, B);
        return aVec.viewColumn(0).toArray();
    }

    public double[] getX() {
        return this.x;
    }

    public double[] getY() {
        return this.y;
    }

    public String toString() {
        return PolInterp.toString(this.x, this.y);
    }

    public LeastSquares clone() {
        LeastSquares ls = (LeastSquares)super.clone();
        ls.x = (double[])this.x.clone();
        ls.y = (double[])this.y.clone();
        return ls;
    }
}

