/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JVMSystemUtils {
    private static final String JAVA_VERSION_KEY = "java.version";
    private static final String JDK5_VERSION = "1.5";
    private static final String METHOD_NAME = "getSystemLoadAverage";
    private static final String JDK_VERSION = System.getProperty("java.version");
    private static OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
    private static Method averageLoad;

    public static double getSystemLoad() {
        if (JDK_VERSION.startsWith(JDK5_VERSION)) {
            return -1.0;
        }
        double systemLoad = -1.0;
        try {
            systemLoad = new Double(averageLoad.invoke((Object)bean, new Object[0]).toString());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        return systemLoad;
    }

    static {
        try {
            averageLoad = bean.getClass().getMethod(METHOD_NAME, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

