/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.statcap;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.utilint.LongMaxStat;
import com.sleepycat.je.utilint.LongMinStat;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatManager {
    protected final Map<Integer, StatContext> statContextMap = new HashMap<Integer, StatContext>();
    private UpdateMinMax updateMinMaxStat = null;
    protected final EnvironmentImpl env;

    public StatManager(EnvironmentImpl env) {
        this.env = env;
    }

    public synchronized Integer registerStatContext() {
        StatContext sctx = new StatContext(null);
        int max = 0;
        for (Integer key : this.statContextMap.keySet()) {
            if (key <= max) continue;
            max = key;
        }
        Integer newkey = new Integer(max + 1);
        this.statContextMap.put(newkey, sctx);
        return newkey;
    }

    public synchronized void unregisterStatContext(Integer key) {
        this.statContextMap.remove(key);
    }

    public synchronized EnvironmentStats loadStats(StatsConfig config, Integer contextKey) {
        Map<String, StatGroup> base;
        StatContext sc = this.statContextMap.get(contextKey);
        if (sc == null) {
            throw EnvironmentFailureException.unexpectedState("Internal error stat context is not registered");
        }
        EnvironmentStats curstats = this.env.loadStatsInternal(config);
        Map<String, StatGroup> cur = curstats.getStatGroupsMap();
        if (this.updateMinMaxStat == null) {
            this.updateMinMaxStat = new UpdateMinMax(cur);
        }
        EnvironmentStats intervalStats = (base = sc.getBase()) != null ? this.computeIntervalStats(cur, base) : curstats;
        if (config.getClear()) {
            for (StatContext context : this.statContextMap.values()) {
                if (context.getBase() == null) continue;
                this.updateMinMaxStat.updateBase(context.getBase(), cur);
            }
            for (StatContext context : this.statContextMap.values()) {
                if (context == sc) {
                    context.setBase(null);
                    continue;
                }
                if (context.getBase() == null) {
                    context.setBase(this.cloneAndNegate(cur));
                    continue;
                }
                context.setBase(this.computeIntervalStats(context.getBase(), cur).getStatGroupsMap());
            }
        }
        return intervalStats;
    }

    private EnvironmentStats computeIntervalStats(Map<String, StatGroup> current, Map<String, StatGroup> base) {
        EnvironmentStats envStats = new EnvironmentStats();
        for (StatGroup cg : current.values()) {
            StatGroup bg = base.get(cg.getName());
            envStats.setStatGroup(cg.computeInterval(bg));
        }
        return envStats;
    }

    protected Map<String, StatGroup> cloneAndNegate(Map<String, StatGroup> in) {
        HashMap<String, StatGroup> retval = new HashMap<String, StatGroup>();
        for (Map.Entry<String, StatGroup> e : in.entrySet()) {
            StatGroup negatedGroup = e.getValue().cloneGroup(false);
            negatedGroup.negate();
            retval.put(e.getKey(), negatedGroup);
        }
        return retval;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UpdateMinMax {
        private final ArrayList<SDef> minStats = new ArrayList();
        private final ArrayList<SDef> maxStats = new ArrayList();

        public UpdateMinMax(Map<String, StatGroup> groups) {
            for (StatGroup group : groups.values()) {
                for (Map.Entry<StatDefinition, Stat<?>> e : group.getStats().entrySet()) {
                    if (e.getValue() instanceof LongMaxStat) {
                        this.maxStats.add(new SDef(group.getName(), e.getKey()));
                        continue;
                    }
                    if (!(e.getValue() instanceof LongMinStat)) continue;
                    this.minStats.add(new SDef(group.getName(), e.getKey()));
                }
            }
        }

        public void updateBase(Map<String, StatGroup> base, Map<String, StatGroup> other) {
            for (SDef sd : this.minStats) {
                base.get(sd.groupName).getLongMinStat(sd.definition).setMin(other.get(sd.groupName).getLongStat(sd.definition).get());
            }
            for (SDef sd : this.maxStats) {
                base.get(sd.groupName).getLongMaxStat(sd.definition).setMax(other.get(sd.groupName).getLongStat(sd.definition).get());
            }
        }

        class SDef {
            String groupName;
            StatDefinition definition;

            SDef(String groupname, StatDefinition sd) {
                this.definition = sd;
                this.groupName = groupname;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class StatContext {
        private Map<String, StatGroup> base;
        private Map<String, StatGroup> repbase = null;

        StatContext(Map<String, StatGroup> base) {
            this.base = base;
        }

        void setBase(Map<String, StatGroup> base) {
            this.base = base;
        }

        Map<String, StatGroup> getBase() {
            return this.base;
        }

        public void setRepBase(Map<String, StatGroup> base) {
            this.repbase = base;
        }

        public Map<String, StatGroup> getRepBase() {
            return this.repbase;
        }
    }
}

