/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.txn;

import com.sleepycat.je.CommitToken;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockNotAvailableException;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.rep.InsufficientAcksException;
import com.sleepycat.je.rep.ReplicaWriteException;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.UnknownMasterException;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.Replay;
import com.sleepycat.je.rep.txn.ReplayTxn;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.txn.TxnManager;
import com.sleepycat.je.txn.WriteLockInfo;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import com.sleepycat.je.utilint.VLSN;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MasterTxn
extends Txn {
    private VLSN commitVLSN = VLSN.NULL_VLSN;
    private final NameIdPair nameIdPair;
    private int requiredAckCount = -1;
    private final long startMs = System.currentTimeMillis();
    private int preLogCommitEndDeltaMs = 0;
    private int repWriteStartDeltaMs = 0;
    private boolean locked;
    private volatile boolean freeze;
    private TestHook<Integer> convertHook;
    private static final MasterTxnFactory DEFAULT_FACTORY;
    private static MasterTxnFactory factory;

    public MasterTxn(EnvironmentImpl envImpl, TransactionConfig config, NameIdPair nameIdPair) throws DatabaseException {
        super(envImpl, config, ReplicationContext.MASTER);
        this.nameIdPair = nameIdPair;
    }

    @Override
    public CommitToken getCommitToken() {
        if (this.commitVLSN.isNull()) {
            return null;
        }
        RepImpl repImpl = (RepImpl)this.envImpl;
        return new CommitToken(repImpl.getUUID(), this.commitVLSN.getSequence());
    }

    public VLSN getCommitVLSN() {
        return this.commitVLSN;
    }

    @Override
    protected long generateId(TxnManager txnManager, long ignore) {
        assert (ignore == 0L);
        return txnManager.getNextReplicatedTxnId();
    }

    @Override
    protected void txnBeginHook(TransactionConfig config) throws DatabaseException {
        RepImpl repImpl = (RepImpl)this.envImpl;
        try {
            repImpl.txnBeginHook(this);
        }
        catch (InterruptedException e) {
            throw new ThreadInterruptedException(this.envImpl, (Throwable)e);
        }
    }

    @Override
    protected void preLogCommitHook() throws DatabaseException {
        RepImpl repImpl = (RepImpl)this.envImpl;
        Durability.ReplicaAckPolicy ackPolicy = this.getCommitDurability().getReplicaAck();
        this.requiredAckCount = repImpl.getRepNode().getDurabilityQuorum().getCurrentRequiredAckCount(ackPolicy);
        repImpl.preLogCommitHook(this);
        this.preLogCommitEndDeltaMs = (int)(System.currentTimeMillis() - this.startMs);
    }

    @Override
    protected void postLogCommitHook(LogItem commitItem) throws DatabaseException {
        this.commitVLSN = commitItem.getHeader().getVLSN();
        try {
            RepImpl repImpl = (RepImpl)this.envImpl;
            repImpl.postLogCommitHook(this);
        }
        catch (InterruptedException e) {
            throw new ThreadInterruptedException(this.envImpl, (Throwable)e);
        }
    }

    @Override
    protected void preLogAbortHook() throws DatabaseException {
        RepImpl repImpl = (RepImpl)this.envImpl;
        repImpl.preLogAbortHook(this);
    }

    @Override
    protected void postLogCommitAbortHook() {
        RepImpl repImpl = (RepImpl)this.envImpl;
        repImpl.postLogCommitAbortHook(this);
    }

    @Override
    protected void postLogAbortHook() {
        RepImpl repImpl = (RepImpl)this.envImpl;
        repImpl.postLogAbortHook(this);
    }

    @Override
    public LockResult lockInternal(long lsn, LockType lockType, boolean noWait, boolean jumpAheadOfWaiters, DatabaseImpl database) throws LockNotAvailableException, LockConflictException, DatabaseException {
        ReplicatedEnvironment.State nodeState = ((RepImpl)this.envImpl).getState();
        if (nodeState.isMaster()) {
            return super.lockInternal(lsn, lockType, noWait, jumpAheadOfWaiters, database);
        }
        this.throwNotMaster(nodeState);
        return null;
    }

    private void throwNotMaster(ReplicatedEnvironment.State nodeState) {
        if (nodeState.isReplica()) {
            throw new ReplicaWriteException(this, ((RepImpl)this.envImpl).getStateChangeEvent());
        }
        throw new UnknownMasterException("Transaction " + this.getId() + " cannot execute write operations because this node is" + " no longer a master");
    }

    @Override
    public synchronized void preLogWithoutLock(DatabaseImpl database) {
        ReplicatedEnvironment.State nodeState = ((RepImpl)this.envImpl).getState();
        if (nodeState.isMaster()) {
            super.preLogWithoutLock(database);
            return;
        }
        this.throwNotMaster(nodeState);
    }

    public boolean lockOnce() {
        if (this.locked) {
            return false;
        }
        this.locked = true;
        return true;
    }

    public boolean unlockOnce() {
        if (this.locked) {
            this.locked = false;
            return true;
        }
        return false;
    }

    public int getRequiredAckCount() {
        return this.requiredAckCount;
    }

    public void resetRequiredAckCount() {
        this.requiredAckCount = 0;
    }

    @Override
    protected int getReplicatorNodeId() {
        return this.nameIdPair.getId();
    }

    public long getStartMs() {
        return this.startMs;
    }

    public void stampRepWriteTime() {
        this.repWriteStartDeltaMs = (int)(System.currentTimeMillis() - this.startMs);
    }

    public long messageTransferMs() {
        return this.repWriteStartDeltaMs > 0 ? (long)(this.repWriteStartDeltaMs - this.preLogCommitEndDeltaMs) : 0L;
    }

    @Override
    protected boolean propagatePostCommitException(DatabaseException postCommitException) {
        return postCommitException instanceof InsufficientAcksException ? true : super.propagatePostCommitException(postCommitException);
    }

    public static MasterTxn create(EnvironmentImpl envImpl, TransactionConfig config, NameIdPair nameIdPair) {
        return factory.create(envImpl, config, nameIdPair);
    }

    public static void setFactory(MasterTxnFactory factory) {
        MasterTxn.factory = factory == null ? DEFAULT_FACTORY : factory;
    }

    @Override
    public boolean isReplicationDefined() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReplayTxn convertToReplayTxnAndClose(Logger logger, Replay replay) {
        boolean needToClose;
        ReplayTxn replayTxn;
        int hookCount;
        block27: {
            ReplayTxn replayTxn2;
            block26: {
                ReplayTxn replayTxn3;
                block25: {
                    if (!this.freeze) {
                        throw EnvironmentFailureException.unexpectedState(this.envImpl, "Txn " + this.getId() + " should be frozen when converting to replay txn");
                    }
                    LoggerUtils.info(logger, this.envImpl, "Transforming txn " + this.getId() + " from MasterTxn to ReplayTxn");
                    hookCount = 0;
                    replayTxn = null;
                    needToClose = true;
                    try {
                        MasterTxn masterTxn = this;
                        synchronized (masterTxn) {
                            if (this.isClosed()) {
                                LoggerUtils.info(logger, this.envImpl, "Txn " + this.getId() + " is closed, no tranform needed");
                                needToClose = false;
                                replayTxn3 = null;
                                // MONITOREXIT @DISABLED, blocks:[0, 4, 24] lbl14 : MonitorExitStatement: MONITOREXIT : var6_6
                                Object var15_9 = null;
                                if ($assertionsDisabled || TestHookExecute.doHookIfSet(this.convertHook, hookCount++)) break block25;
                                throw new AssertionError();
                            }
                            Set<Long> lockedLSNs = this.getWriteLockIds();
                            if (lockedLSNs.size() == 0) {
                                LoggerUtils.info(logger, this.envImpl, "Txn " + this.getId() + " had no write locks, didn't create" + " ReplayTxn");
                                needToClose = false;
                                replayTxn2 = null;
                                // MONITOREXIT @DISABLED, blocks:[0, 4, 23] lbl24 : MonitorExitStatement: MONITOREXIT : var6_6
                                break block26;
                            }
                            this.setOnlyAbortable(new UnknownMasterException(this.envImpl.getNodeName() + " is no longer a master"));
                            replayTxn = replay.getReplayTxn(this.getId(), false);
                            ArrayList<Long> sortedLsns = new ArrayList<Long>(lockedLSNs);
                            Collections.sort(sortedLsns);
                            LoggerUtils.info(logger, this.envImpl, "Txn " + this.getId() + " has " + lockedLSNs.size() + " locks to transform");
                            for (Long lsn : sortedLsns) {
                                LoggerUtils.info(logger, this.envImpl, "Txn " + this.getId() + " is transferring lock " + lsn);
                                replayTxn.stealLockFromMasterTxn(lsn);
                                WriteLockInfo replayWLI = replayTxn.getWriteLockInfo(lsn);
                                WriteLockInfo masterWLI = this.getWriteLockInfo(lsn);
                                replayWLI.copyAllInfo(masterWLI);
                                this.removeLock(lsn);
                            }
                            replayTxn.copyDatabasesForConversion(this);
                            this.deletedDatabases = null;
                            this.lastLoggedLsn = -1L;
                            this.firstLoggedLsn = -1L;
                            this.clearReadLocks();
                        }
                        break block27;
                    }
                    catch (Throwable throwable) {
                        Object var15_12 = null;
                        assert (TestHookExecute.doHookIfSet(this.convertHook, hookCount++));
                        this.unfreeze();
                        assert (TestHookExecute.doHookIfSet(this.convertHook, hookCount++));
                        if (needToClose) {
                            LoggerUtils.info(logger, this.envImpl, "About to close txn " + this.getId() + " state=" + (Object)((Object)this.getState()));
                            this.close(false);
                            LoggerUtils.info(logger, this.envImpl, "Closed txn " + this.getId() + " state=" + (Object)((Object)this.getState()));
                        }
                        if ($assertionsDisabled || TestHookExecute.doHookIfSet(this.convertHook, hookCount++)) throw throwable;
                        throw new AssertionError();
                    }
                }
                this.unfreeze();
                assert (TestHookExecute.doHookIfSet(this.convertHook, hookCount++));
                if (needToClose) {
                    LoggerUtils.info(logger, this.envImpl, "About to close txn " + this.getId() + " state=" + (Object)((Object)this.getState()));
                    this.close(false);
                    LoggerUtils.info(logger, this.envImpl, "Closed txn " + this.getId() + " state=" + (Object)((Object)this.getState()));
                }
                assert (TestHookExecute.doHookIfSet(this.convertHook, hookCount++));
                return replayTxn3;
            }
            Object var15_10 = null;
            assert (TestHookExecute.doHookIfSet(this.convertHook, hookCount++));
            this.unfreeze();
            assert (TestHookExecute.doHookIfSet(this.convertHook, hookCount++));
            if (needToClose) {
                LoggerUtils.info(logger, this.envImpl, "About to close txn " + this.getId() + " state=" + (Object)((Object)this.getState()));
                this.close(false);
                LoggerUtils.info(logger, this.envImpl, "Closed txn " + this.getId() + " state=" + (Object)((Object)this.getState()));
            }
            assert (TestHookExecute.doHookIfSet(this.convertHook, hookCount++));
            return replayTxn2;
        }
        Object var15_11 = null;
        assert (TestHookExecute.doHookIfSet(this.convertHook, hookCount++));
        this.unfreeze();
        assert (TestHookExecute.doHookIfSet(this.convertHook, hookCount++));
        if (needToClose) {
            LoggerUtils.info(logger, this.envImpl, "About to close txn " + this.getId() + " state=" + (Object)((Object)this.getState()));
            this.close(false);
            LoggerUtils.info(logger, this.envImpl, "Closed txn " + this.getId() + " state=" + (Object)((Object)this.getState()));
        }
        assert (TestHookExecute.doHookIfSet(this.convertHook, hookCount++));
        return replayTxn;
    }

    public void freeze() {
        this.freeze = true;
    }

    private void unfreeze() {
        this.freeze = false;
    }

    @Override
    protected void checkIfFrozen(boolean isCommit) {
        if (this.freeze) {
            try {
                ((RepImpl)this.envImpl).checkIfMaster(this);
            }
            catch (DatabaseException e) {
                if (isCommit) {
                    this.postLogCommitAbortHook();
                } else {
                    this.postLogAbortHook();
                }
                throw e;
            }
        }
    }

    public void setConvertHook(TestHook<Integer> hook) {
        this.convertHook = hook;
    }

    @Override
    public boolean isMasterTxn() {
        return true;
    }

    static {
        factory = DEFAULT_FACTORY = new MasterTxnFactory(){

            public MasterTxn create(EnvironmentImpl envImpl, TransactionConfig config, NameIdPair nameIdPair) {
                return new MasterTxn(envImpl, config, nameIdPair);
            }
        };
    }

    public static interface MasterTxnFactory {
        public MasterTxn create(EnvironmentImpl var1, TransactionConfig var2, NameIdPair var3);
    }
}

